/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.utility.shape;

import com.copycatsplus.copycats.mixin.copycat.VoxelShapeAccessor;
import com.copycatsplus.copycats.utility.shape.ExtensibleVoxelShape;
import com.copycatsplus.copycats.utility.shape.NoneVoxelShape;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelCollection
extends ExtensibleVoxelShape {
    private VoxelShape collisionShape;
    private VoxelShape outlineShape;
    private VoxelShape particleShape;
    private final List<NoneVoxelShape> noneVoxels = Lists.newArrayList();

    public VoxelCollection(VoxelShape baseShape) {
        this(baseShape, baseShape);
    }

    public VoxelCollection(VoxelShape baseShape, VoxelShape outlineBaseShape) {
        super(baseShape);
        this.collisionShape = baseShape;
        this.outlineShape = outlineBaseShape;
        this.particleShape = baseShape;
    }

    @Override
    protected DoubleList m_7700_(Direction.Axis axis) {
        return ((VoxelShapeAccessor)this.collisionShape).copycats$callGetCoords(axis);
    }

    private void setCollisionShape(VoxelShape voxelShape) {
        this.collisionShape = voxelShape;
        ((VoxelShapeAccessor)((Object)this)).copycats$setShape(((VoxelShapeAccessor)this.collisionShape).copycats$getShape());
    }

    public void addVoxelShape(VoxelShape voxelShape, VoxelShape particleShape) {
        if (voxelShape instanceof NoneVoxelShape) {
            this.addNoneVoxelShape((NoneVoxelShape)voxelShape);
        } else {
            this.setCollisionShape(Shapes.m_83148_((VoxelShape)this.collisionShape, (VoxelShape)voxelShape, (BooleanOp)BooleanOp.f_82695_));
            this.outlineShape = Shapes.m_83148_((VoxelShape)this.outlineShape, (VoxelShape)voxelShape, (BooleanOp)BooleanOp.f_82695_);
        }
        this.particleShape = Shapes.m_83148_((VoxelShape)this.particleShape, (VoxelShape)particleShape, (BooleanOp)BooleanOp.f_82695_);
    }

    private void addNoneVoxelShape(NoneVoxelShape voxelShape) {
        this.noneVoxels.add(voxelShape);
        this.setCollisionShape(Shapes.m_83148_((VoxelShape)this.collisionShape, (VoxelShape)voxelShape, (BooleanOp)BooleanOp.f_82695_));
    }

    public VoxelCollection optimize() {
        this.setCollisionShape(this.collisionShape.m_83296_());
        this.outlineShape = this.outlineShape.m_83296_();
        this.particleShape = this.particleShape.m_83296_();
        return this;
    }

    public void forAllParticleBoxes(Shapes.DoubleLineConsumer doubleLineConsumer) {
        this.particleShape.m_83286_(doubleLineConsumer);
    }

    public void m_83224_(Shapes.DoubleLineConsumer boxConsumer) {
        this.outlineShape.m_83224_(boxConsumer);
        this.noneVoxels.forEach(voxelShape -> voxelShape.m_83224_(boxConsumer));
    }
}

