/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.common.registry.fluid;

import earth.terrarium.botarium.common.registry.fluid.FluidData;
import earth.terrarium.botarium.forge.regsitry.fluid.ForgeFluidData;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;

public class BotariumSourceFluid
extends FlowingFluid {
    private final FluidData data;

    public BotariumSourceFluid(FluidData data) {
        this.data = data;
        data.setStillFluid(() -> this);
    }

    public FluidData getData() {
        return this.data;
    }

    public Fluid m_5615_() {
        return (Fluid)this.getData().getFlowingFluid().get();
    }

    public Fluid m_5613_() {
        return (Fluid)this.getData().getStillFluid().get();
    }

    protected boolean m_6760_(Level level) {
        return this.getData().getInformation().canConvertToSource();
    }

    protected void m_7456_(@NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Block.m_49892_((BlockState)state, (LevelAccessor)level, (BlockPos)pos, state.m_155947_() ? level.m_7702_(pos) : null);
    }

    protected int m_6719_(@NotNull LevelReader level) {
        return this.getData().getInformation().slopeFindDistance();
    }

    protected int m_6713_(@NotNull LevelReader level) {
        return this.getData().getInformation().dropOff();
    }

    public Item m_6859_() {
        return this.getData().getOptionalBucket().orElse(Items.f_41852_);
    }

    protected boolean m_5486_(@NotNull FluidState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Fluid fluid, @NotNull Direction direction) {
        return direction == Direction.DOWN && !this.m_6212_(fluid);
    }

    public int m_6718_(@NotNull LevelReader level) {
        return this.getData().getInformation().tickDelay();
    }

    protected float m_6752_() {
        return this.getData().getInformation().explosionResistance();
    }

    protected BlockState m_5804_(@NotNull FluidState state) {
        return this.getData().getOptionalBlock().map(Block::m_49966_).map(block -> (BlockState)block.m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(BotariumSourceFluid.m_76092_((FluidState)state)))).orElse(Blocks.f_50016_.m_49966_());
    }

    public boolean m_7444_(@NotNull FluidState state) {
        return true;
    }

    protected void m_7180_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Fluid, FluidState> builder) {
        super.m_7180_(builder);
    }

    public int m_7430_(@NotNull FluidState state) {
        return 8;
    }

    public boolean m_6212_(@NotNull Fluid fluid) {
        return fluid == this.m_5613_() || fluid == this.m_5615_();
    }

    public Optional<SoundEvent> m_142520_() {
        SoundEvent event = this.getData().getInformation().sounds().getSound("bucket_fill");
        if (event == null) {
            event = SoundEvents.f_11781_;
        }
        return Optional.ofNullable(event);
    }

    @NotNull
    public FluidType getFluidType() {
        FluidData fluidData = this.data;
        if (fluidData instanceof ForgeFluidData) {
            ForgeFluidData forgeHolder = (ForgeFluidData)fluidData;
            return forgeHolder.getType().get();
        }
        return super.getFluidType();
    }
}

