/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.turtle;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommand;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.upgrades.UpgradeData;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.NonExtendable
public interface ITurtleAccess {
    public Level getLevel();

    public BlockPos getPosition();

    public boolean isRemoved();

    public boolean teleportTo(Level var1, BlockPos var2);

    public Direction getDirection();

    public void setDirection(Direction var1);

    public int getSelectedSlot();

    public void setSelectedSlot(int var1);

    public void setColour(int var1);

    public int getColour();

    @Nullable
    public GameProfile getOwningPlayer();

    public Container getInventory();

    public boolean isFuelNeeded();

    public int getFuelLevel();

    public void setFuelLevel(int var1);

    public int getFuelLimit();

    public boolean consumeFuel(int var1);

    public void addFuel(int var1);

    public MethodResult executeCommand(TurtleCommand var1);

    public void playAnimation(TurtleAnimation var1);

    @Nullable
    public ITurtleUpgrade getUpgrade(TurtleSide var1);

    @Nullable
    default public UpgradeData<ITurtleUpgrade> getUpgradeWithData(TurtleSide side) {
        ITurtleUpgrade upgrade = this.getUpgrade(side);
        return upgrade == null ? null : UpgradeData.of(upgrade, this.getUpgradeNBTData(side));
    }

    @Deprecated
    default public void setUpgrade(TurtleSide side, @Nullable ITurtleUpgrade upgrade) {
        this.setUpgradeWithData(side, upgrade == null ? null : UpgradeData.ofDefault(upgrade));
    }

    public void setUpgradeWithData(TurtleSide var1, @Nullable UpgradeData<ITurtleUpgrade> var2);

    @Nullable
    public IPeripheral getPeripheral(TurtleSide var1);

    public CompoundTag getUpgradeNBTData(TurtleSide var1);

    public void updateUpgradeNBTData(TurtleSide var1);
}

