/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.util;

public final class StringUtil {
    private StringUtil() {
    }

    private static boolean isAllowed(char c) {
        return c >= ' ' && c <= '~' || c >= '\u00a1' && c <= '\u00ac' || c >= '\u00ae' && c <= '\u00ff';
    }

    private static String removeSpecialCharacters(String text, int length) {
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            builder.append(StringUtil.isAllowed(c) ? c : (char)'?');
        }
        return builder.toString();
    }

    public static String normaliseLabel(String text) {
        return StringUtil.removeSpecialCharacters(text, Math.min(32, text.length()));
    }

    public static String normaliseClipboardString(String clipboard) {
        int newLineIndex1 = clipboard.indexOf(13);
        int newLineIndex2 = clipboard.indexOf(10);
        int length = newLineIndex1 >= 0 && newLineIndex2 >= 0 ? Math.min(newLineIndex1, newLineIndex2) : (newLineIndex1 >= 0 ? newLineIndex1 : (newLineIndex2 >= 0 ? newLineIndex2 : clipboard.length()));
        return StringUtil.removeSpecialCharacters(clipboard, Math.min(length, 512));
    }
}

