/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data;

import dan200.computercraft.shared.ModRegistry;
import java.util.Optional;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public final class ItemModelProvider {
    private ItemModelProvider() {
    }

    public static void addItemModels(ItemModelGenerators generators) {
        ItemModelProvider.registerDisk(generators, (Item)ModRegistry.Items.DISK.get());
        ItemModelProvider.registerDisk(generators, (Item)ModRegistry.Items.TREASURE_DISK.get());
        ItemModelProvider.registerPocketComputer(generators, ModelLocationUtils.m_125571_((Item)((Item)ModRegistry.Items.POCKET_COMPUTER_NORMAL.get())), false);
        ItemModelProvider.registerPocketComputer(generators, ModelLocationUtils.m_125571_((Item)((Item)ModRegistry.Items.POCKET_COMPUTER_ADVANCED.get())), false);
        ItemModelProvider.registerPocketComputer(generators, new ResourceLocation("computercraft", "item/pocket_computer_colour"), true);
        generators.m_125088_((Item)ModRegistry.Items.PRINTED_BOOK.get(), ModelTemplates.f_125658_);
        generators.m_125088_((Item)ModRegistry.Items.PRINTED_PAGE.get(), ModelTemplates.f_125658_);
        generators.m_125088_((Item)ModRegistry.Items.PRINTED_PAGES.get(), ModelTemplates.f_125658_);
    }

    private static void registerPocketComputer(ItemModelGenerators generators, ResourceLocation id, boolean off) {
        ItemModelProvider.createFlatItem(generators, ItemModelProvider.addSuffix(id, "_blinking"), new ResourceLocation("computercraft", "item/pocket_computer_blink"), id, new ResourceLocation("computercraft", "item/pocket_computer_light"));
        ItemModelProvider.createFlatItem(generators, ItemModelProvider.addSuffix(id, "_on"), new ResourceLocation("computercraft", "item/pocket_computer_on"), id, new ResourceLocation("computercraft", "item/pocket_computer_light"));
        if (off) {
            ItemModelProvider.createFlatItem(generators, id, new ResourceLocation("computercraft", "item/pocket_computer_frame"), id);
        }
    }

    private static void registerDisk(ItemModelGenerators generators, Item item) {
        ItemModelProvider.createFlatItem(generators, item, new ResourceLocation("computercraft", "item/disk_frame"), new ResourceLocation("computercraft", "item/disk_colour"));
    }

    private static void createFlatItem(ItemModelGenerators generators, Item item, ResourceLocation ... ids) {
        ItemModelProvider.createFlatItem(generators, ModelLocationUtils.m_125571_((Item)item), ids);
    }

    private static void createFlatItem(ItemModelGenerators generators, ResourceLocation model, ResourceLocation ... textures) {
        if (textures.length > 5) {
            throw new IndexOutOfBoundsException("Too many layers");
        }
        if (textures.length == 0) {
            throw new IndexOutOfBoundsException("Must have at least one texture");
        }
        if (textures.length == 1) {
            ModelTemplates.f_125658_.m_125612_(model, TextureMapping.m_125820_((ResourceLocation)textures[0]), generators.f_125080_);
            return;
        }
        TextureSlot[] slots = new TextureSlot[textures.length];
        TextureMapping mapping = new TextureMapping();
        for (int i = 0; i < textures.length; ++i) {
            TextureSlot slot = slots[i] = TextureSlot.m_125898_((String)("layer" + i));
            mapping.m_125758_(slot, textures[i]);
        }
        new ModelTemplate(Optional.of(new ResourceLocation("item/generated")), Optional.empty(), slots).m_125612_(model, mapping, generators.f_125080_);
    }

    private static ResourceLocation addSuffix(ResourceLocation location, String suffix) {
        return new ResourceLocation(location.m_135827_(), location.m_135815_() + suffix);
    }
}

