/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommand;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.shared.platform.ContainerTransfer;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.turtle.TurtleUtil;
import dan200.computercraft.shared.turtle.core.InteractDirection;
import dan200.computercraft.shared.util.WorldUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class TurtleDropCommand
implements TurtleCommand {
    private final InteractDirection direction;
    private final int quantity;

    public TurtleDropCommand(InteractDirection direction, int quantity) {
        this.direction = direction;
        this.quantity = quantity;
    }

    @Override
    public TurtleCommandResult execute(ITurtleAccess turtle) {
        int transferred;
        if (this.quantity == 0) {
            turtle.playAnimation(TurtleAnimation.WAIT);
            return TurtleCommandResult.success();
        }
        Direction direction = this.direction.toWorldDir(turtle);
        ContainerTransfer source = TurtleUtil.getSelectedSlot(turtle);
        Level world = turtle.getLevel();
        BlockPos oldPosition = turtle.getPosition();
        BlockPos newPosition = oldPosition.m_121945_(direction);
        Direction side = direction.m_122424_();
        ContainerTransfer inventory = PlatformHelper.get().getContainer((ServerLevel)world, newPosition, side);
        if (inventory != null) {
            transferred = source.moveTo(inventory, this.quantity);
        } else {
            ItemStack stack = turtle.getInventory().m_7407_(turtle.getSelectedSlot(), this.quantity);
            if (stack.m_41619_()) {
                transferred = -1;
            } else {
                turtle.getInventory().m_6596_();
                transferred = stack.m_41613_();
                WorldUtil.dropItemStack(world, oldPosition, direction, stack);
                world.m_6798_(1000, newPosition, 0);
            }
        }
        switch (transferred) {
            case -2: {
                return TurtleCommandResult.failure("No space for items");
            }
            case -1: {
                return TurtleCommandResult.failure("No items to drop");
            }
        }
        turtle.playAnimation(TurtleAnimation.WAIT);
        return TurtleCommandResult.success();
    }
}

