/*
 * Decompiled with CFR 0.152.
 */
package top.leonx.irisflw.transformer;

import com.jozufozu.flywheel.core.compile.Template;
import com.jozufozu.flywheel.core.compile.VertexData;
import com.jozufozu.flywheel.core.source.FileResolution;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import top.leonx.irisflw.transformer.ShaderPatcherBase;

public class TemplateShaderPatcher
extends ShaderPatcherBase {
    public String headerPlaceholder = "/\\*\\s*FLW_HEADER\\s*\\*/";
    public String structPlaceholder = "/\\*\\s*FLW_STRUCT\\s*\\*/";
    public String createVertexPlaceholder = "/\\*\\s*FLW_CREATE_VERTEX\\s*\\*/";
    public String assignPlaceholder = "/\\*\\s*.*\\s?=\\s?<FLW_\\w+>\\s*\\*/";
    public String leftValue = "(?<=/\\*).*\\s?(?=\\=)";
    public String rightValue = "(?<=\\=)\\s*<.*>";
    private final Pattern structPattern = Pattern.compile(this.structPlaceholder);
    private final Pattern createVertexPattern = Pattern.compile(this.createVertexPlaceholder);
    private final Pattern assignPattern = Pattern.compile(this.assignPlaceholder);
    private final Pattern leftValuePattern = Pattern.compile(this.leftValue);
    private final Pattern rightValuePattern = Pattern.compile(this.rightValue);
    private final Pattern headerPattern = Pattern.compile(this.headerPlaceholder);

    public TemplateShaderPatcher(Template<? extends VertexData> template, FileResolution header) {
        super(template, header);
    }

    @Override
    public String patch(String irisSource, ShaderPatcherBase.Context key) {
        irisSource = this.patchHead(irisSource, key);
        VertexData appliedTemplate = (VertexData)this.template.apply(key.file);
        StringBuilder structBuilder = new StringBuilder();
        this.genCommonSource(structBuilder, key, appliedTemplate);
        Matcher matcher = this.structPattern.matcher(irisSource);
        irisSource = matcher.replaceAll(structBuilder.toString());
        StringBuilder createVertexBuilder = new StringBuilder();
        this.generateCreateVertex(appliedTemplate, createVertexBuilder);
        matcher = this.createVertexPattern.matcher(irisSource);
        irisSource = matcher.replaceAll(createVertexBuilder.toString());
        matcher = this.assignPattern.matcher(irisSource);
        StringBuilder buffer = new StringBuilder(irisSource);
        block14: while (matcher.find()) {
            String rValue;
            String rValueMark;
            String assignMark = matcher.group();
            Matcher lValMatcher = this.leftValuePattern.matcher(assignMark);
            Matcher rValMatcher = this.rightValuePattern.matcher(assignMark);
            if (!lValMatcher.find() || !rValMatcher.find()) continue;
            String lValue = lValMatcher.group();
            switch (rValueMark = rValMatcher.group().strip()) {
                case "<FLW_POSITION>": {
                    rValue = "FLWVertex(v)";
                    break;
                }
                case "<FLW_TEXCOORDS>": {
                    rValue = "v.texCoords";
                    break;
                }
                case "<FLW_LIGHT>": {
                    rValue = "v.light";
                    break;
                }
                case "<FLW_NORMAL>": {
                    rValue = "v.normal";
                    break;
                }
                case "<FLW_COLOR>": {
                    rValue = "v.color";
                    break;
                }
                default: {
                    continue block14;
                }
            }
            String assignStat = String.format("%s = %s;", lValue, rValue);
            buffer.replace(matcher.start(), matcher.end(), assignStat);
            matcher = this.assignPattern.matcher(buffer);
        }
        return buffer.toString();
    }

    private String patchHead(String irisSource, ShaderPatcherBase.Context key) {
        StringBuilder headerBuilder = new StringBuilder();
        this.genHeadSource(headerBuilder, key);
        Matcher matcher = this.headerPattern.matcher(irisSource);
        irisSource = matcher.replaceAll(headerBuilder.toString());
        return irisSource;
    }
}

