/*
 * Decompiled with CFR 0.152.
 */
package de.pixelboystm.blockEntity;

import com.simibubi.create.AllTags;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Lang;
import de.pixelboystm.block.DoenerSpear;
import de.pixelboystm.createdoener.CreateDoener;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class DoenerSpearBlockEntity
extends KineticBlockEntity {
    private int ticksBurning = 0;

    public DoenerSpearBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public static BlazeBurnerBlock.HeatLevel getHeatLevelOf(BlockState state) {
        if (state.m_61138_((Property)BlazeBurnerBlock.HEAT_LEVEL)) {
            return (BlazeBurnerBlock.HeatLevel)state.m_61143_((Property)BlazeBurnerBlock.HEAT_LEVEL);
        }
        return AllTags.AllBlockTags.PASSIVE_BOILER_HEATERS.matches(state) && BlockHelper.isNotUnheated((BlockState)state) ? BlazeBurnerBlock.HeatLevel.SMOULDERING : BlazeBurnerBlock.HeatLevel.NONE;
    }

    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_) {
            return;
        }
        BlockState state = this.m_58900_();
        if (state.m_61143_(DoenerSpear.FILL) == DoenerSpear.Fill.None) {
            this.ticksBurning = 0;
        }
        if (state.m_61143_(DoenerSpear.FILL) != DoenerSpear.Fill.None && DoenerSpearBlockEntity.getHeatLevelOf(this.f_58857_.m_8055_(this.m_58899_().m_7495_())).isAtLeast(BlazeBurnerBlock.HeatLevel.FADING) && (double)Math.abs(this.getSpeed()) >= 10.0) {
            if (state.m_61143_(DoenerSpear.STATE) == DoenerSpear.CookState.Raw) {
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_(DoenerSpear.STATE, (Comparable)((Object)DoenerSpear.CookState.Medium)));
                this.ticksBurning = 0;
            } else if (state.m_61143_(DoenerSpear.STATE) == DoenerSpear.CookState.Medium) {
                if (this.ticksBurning >= 120) {
                    this.ticksBurning = 0;
                    this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_(DoenerSpear.STATE, (Comparable)((Object)DoenerSpear.CookState.Cooked)));
                    CreateDoener.LOGGER.debug("DONE");
                } else {
                    ++this.ticksBurning;
                }
            }
            this.f_58857_.m_7260_(this.m_58899_(), state, state, 1);
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean show = false;
        Lang.translate((String)"googles.spear.fill", (Object[])new Object[0]).space().add(Lang.text((String)((DoenerSpear.Fill)((Object)this.m_58900_().m_61143_(DoenerSpear.FILL))).m_7912_())).forGoggles(tooltip);
        if (!DoenerSpearBlockEntity.getHeatLevelOf(this.f_58857_.m_8055_(this.m_58899_().m_7495_())).isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
            Lang.translate((String)"googles.spear.cold", (Object[])new Object[0]).color(new Color(0, 0, 255).getRGB()).forGoggles(tooltip);
            show = true;
        }
        if (this.getSpeed() < 10.0f) {
            Lang.translate((String)"googles.spear.slow", (Object[])new Object[0]).forGoggles(tooltip);
            show = true;
        }
        if (this.ticksBurning > 0) {
            Lang.translate((String)"googles.spear.progress", (Object[])new Object[0]).space().add(Lang.number((double)this.ticksBurning).color(Color.RED.getRGB())).forGoggles(tooltip);
            show = true;
        }
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking) || show;
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("time", this.ticksBurning);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.ticksBurning = compound.m_128451_("time");
    }
}

