/*
 * Decompiled with CFR 0.152.
 */
package org.thinkingstudio.ryoamiclights.api.item;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.thinkingstudio.ryoamiclights.RyoamicLights;
import org.thinkingstudio.ryoamiclights.api.item.ItemLightSource;

public final class ItemLightSources {
    private static final Map<Item, ItemLightSource> ITEM_LIGHT_SOURCES = new Reference2ObjectOpenHashMap();
    private static final Map<Item, ItemLightSource> STATIC_ITEM_LIGHT_SOURCES = new Reference2ObjectOpenHashMap();

    private ItemLightSources() {
        throw new UnsupportedOperationException("ItemLightSources only contains static definitions.");
    }

    public static void load(ResourceManager resourceManager) {
        ITEM_LIGHT_SOURCES.clear();
        resourceManager.m_214159_("dynamiclights/item", path -> path.m_135815_().endsWith(".json")).forEach(ItemLightSources::load);
        ITEM_LIGHT_SOURCES.putAll(STATIC_ITEM_LIGHT_SOURCES);
    }

    private static void load(ResourceLocation resourceId, Resource resource) {
        ResourceLocation id = new ResourceLocation(resourceId.m_135827_(), resourceId.m_135815_().replace(".json", ""));
        try (InputStreamReader reader = new InputStreamReader(resource.m_215507_());){
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            ItemLightSource.fromJson(id, json).ifPresent(data -> {
                if (!STATIC_ITEM_LIGHT_SOURCES.containsKey(data.item())) {
                    ItemLightSources.register(data);
                }
            });
        }
        catch (IOException | IllegalStateException e) {
            RyoamicLights.get().warn("Failed to load item light source \"" + String.valueOf(id) + "\".");
        }
    }

    private static void register(ItemLightSource data) {
        ItemLightSource other = ITEM_LIGHT_SOURCES.get(data.item());
        if (other != null) {
            RyoamicLights.get().warn("Failed to register item light source \"" + String.valueOf(data.id()) + "\", duplicates item \"" + String.valueOf(BuiltInRegistries.f_257033_.m_7981_((Object)data.item())) + "\" found in \"" + String.valueOf(other.id()) + "\".");
            return;
        }
        ITEM_LIGHT_SOURCES.put(data.item(), data);
    }

    public static void registerItemLightSource(ItemLightSource data) {
        ItemLightSource other = STATIC_ITEM_LIGHT_SOURCES.get(data.item());
        if (other != null) {
            RyoamicLights.get().warn("Failed to register item light source \"" + String.valueOf(data.id()) + "\", duplicates item \"" + String.valueOf(BuiltInRegistries.f_257033_.m_7981_((Object)data.item())) + "\" found in \"" + String.valueOf(other.id()) + "\".");
            return;
        }
        STATIC_ITEM_LIGHT_SOURCES.put(data.item(), data);
    }

    public static int getLuminance(ItemStack stack, boolean submergedInWater) {
        ItemLightSource data = ITEM_LIGHT_SOURCES.get(stack.m_41720_());
        if (RyoamicLights.get().keyBinding.m_90859_()) {
            return 0;
        }
        if (data != null) {
            return data.getLuminance(stack, submergedInWater);
        }
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return ItemLightSource.BlockItemLightSource.getLuminance(stack, blockItem.m_40614_().m_49966_());
        }
        return 0;
    }
}

