/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.client.display;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import me.lib720.caprica.vlcj.player.base.State;
import me.srrapero720.waterframes.WFConfig;
import me.srrapero720.waterframes.WaterFrames;
import me.srrapero720.waterframes.client.display.DisplayControl;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import me.srrapero720.watermedia.api.image.ImageAPI;
import me.srrapero720.watermedia.api.image.ImageCache;
import me.srrapero720.watermedia.api.math.MathAPI;
import me.srrapero720.watermedia.api.player.SyncVideoPlayer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;

public class TextureDisplay {
    private static final ImageCache VLC_NOT_FOUND = new ImageCache(ImageAPI.failedVLC());
    private SyncVideoPlayer mediaPlayer;
    private ImageCache imageCache;
    private final DisplayTile tile;
    private BlockPos blockPos;
    private int currentVolume = 0;
    private final AtomicLong currentLastTime = new AtomicLong(Long.MIN_VALUE);
    private Mode displayMode = Mode.PICTURE;
    private boolean stream = false;
    private boolean synced = false;

    public TextureDisplay(DisplayTile tile) {
        this.imageCache = tile.imageCache;
        this.blockPos = tile.m_58899_();
        this.tile = tile;
        if (this.imageCache.isVideo()) {
            this.switchVideoMode();
        }
    }

    private void switchVideoMode() {
        if (!WFConfig.useMultimedia()) {
            this.imageCache = VLC_NOT_FOUND;
            this.displayMode = Mode.PICTURE;
            return;
        }
        this.displayMode = Mode.VIDEO;
        this.mediaPlayer = new SyncVideoPlayer((Executor)Minecraft.m_91087_());
        if (this.mediaPlayer.isBroken()) {
            this.imageCache = VLC_NOT_FOUND;
            this.displayMode = Mode.PICTURE;
            return;
        }
        this.currentVolume = TextureDisplay.limitVolume(this.blockPos.m_5484_(this.tile.getDirection(), (int)this.tile.data.audioOffset), this.tile.data.volume, this.tile.data.minVolumeDistance, this.tile.data.maxVolumeDistance);
        this.mediaPlayer.setVolume(this.currentVolume);
        this.mediaPlayer.setRepeatMode(this.tile.data.loop);
        this.mediaPlayer.setPauseMode(this.tile.data.paused);
        this.mediaPlayer.setMuteMode(this.tile.data.muted);
        this.mediaPlayer.start((CharSequence)this.tile.data.url);
        DisplayControl.add(this);
    }

    public int width() {
        return switch (this.displayMode) {
            default -> throw new IncompatibleClassChangeError();
            case Mode.PICTURE -> {
                if (this.imageCache.getRenderer() != null) {
                    yield this.imageCache.getRenderer().width;
                }
                yield 1;
            }
            case Mode.VIDEO -> this.mediaPlayer.getWidth();
            case Mode.AUDIO -> 0;
        };
    }

    public int height() {
        return switch (this.displayMode) {
            default -> throw new IncompatibleClassChangeError();
            case Mode.PICTURE -> {
                if (this.imageCache.getRenderer() != null) {
                    yield this.imageCache.getRenderer().height;
                }
                yield 1;
            }
            case Mode.VIDEO -> this.mediaPlayer.getHeight();
            case Mode.AUDIO -> 0;
        };
    }

    public int texture() {
        return switch (this.displayMode) {
            default -> throw new IncompatibleClassChangeError();
            case Mode.PICTURE -> this.imageCache.getRenderer().texture(this.tile.data.tick, !this.tile.data.paused ? MathAPI.tickToMs((float)WaterFrames.deltaFrames()) : 0L, this.tile.data.loop);
            case Mode.VIDEO -> this.mediaPlayer.getGlTexture();
            case Mode.AUDIO -> -1;
        };
    }

    public int durationInTicks() {
        return MathAPI.msToTick((long)this.duration());
    }

    public long duration() {
        return switch (this.displayMode) {
            default -> throw new IncompatibleClassChangeError();
            case Mode.PICTURE -> {
                if (this.imageCache.getRenderer() != null) {
                    yield this.imageCache.getRenderer().duration;
                }
                yield 0L;
            }
            case Mode.VIDEO -> this.mediaPlayer.getDuration();
            case Mode.AUDIO -> 0L;
        };
    }

    public boolean canTick() {
        return switch (this.displayMode) {
            default -> throw new IncompatibleClassChangeError();
            case Mode.PICTURE -> this.imageCache.getStatus().equals((Object)ImageCache.Status.READY);
            case Mode.VIDEO -> {
                if (this.mediaPlayer.isSafeUse() && this.mediaPlayer.isValid()) {
                    yield true;
                }
                yield false;
            }
            case Mode.AUDIO -> this.mediaPlayer.isSafeUse();
        };
    }

    public boolean canRender() {
        return switch (this.displayMode) {
            default -> throw new IncompatibleClassChangeError();
            case Mode.PICTURE -> {
                if (this.imageCache.getRenderer() != null && this.tile.data.active) {
                    yield true;
                }
                yield false;
            }
            case Mode.VIDEO -> {
                if (this.mediaPlayer.isValid() && this.tile.data.active) {
                    yield true;
                }
                yield false;
            }
            case Mode.AUDIO -> false;
        };
    }

    public void syncDuration() {
        if (this.tile.data.tickMax == -1L) {
            this.tile.data.tick = 0L;
        }
        this.tile.syncTime(true, this.tile.data.tick, this.durationInTicks());
    }

    public void tick(BlockPos pos) {
        this.blockPos = pos;
        if (!this.synced && this.canRender()) {
            this.syncDuration();
            this.synced = true;
        }
        switch (this.displayMode) {
            case PICTURE: {
                if (!this.imageCache.isVideo()) break;
                this.switchVideoMode();
                break;
            }
            case VIDEO: 
            case AUDIO: {
                boolean mayPause;
                int volume = TextureDisplay.limitVolume(this.blockPos.m_5484_(this.tile.getDirection(), (int)this.tile.data.audioOffset), this.tile.data.volume, this.tile.data.minVolumeDistance, this.tile.data.maxVolumeDistance);
                if (this.currentVolume != volume) {
                    this.currentVolume = volume;
                    this.mediaPlayer.setVolume(this.currentVolume);
                }
                if (!this.mediaPlayer.isSafeUse() || !this.mediaPlayer.isValid()) break;
                if (this.mediaPlayer.getRepeatMode() != this.tile.data.loop) {
                    this.mediaPlayer.setRepeatMode(this.tile.data.loop);
                }
                if (this.mediaPlayer.isMuted() != this.tile.data.muted) {
                    this.mediaPlayer.setMuteMode(this.tile.data.muted);
                }
                if (!this.stream && this.mediaPlayer.isLive()) {
                    this.stream = true;
                }
                boolean bl = mayPause = this.tile.data.paused || !this.tile.data.active || Minecraft.m_91087_().m_91104_();
                if (this.mediaPlayer.isPaused() != mayPause) {
                    this.mediaPlayer.setPauseMode(mayPause);
                }
                if (this.stream || !this.mediaPlayer.isSeekAble()) break;
                long time = MathAPI.tickToMs((long)this.tile.data.tick) + (!mayPause ? MathAPI.tickToMs((float)WaterFrames.deltaFrames()) : 0L);
                if (time > this.mediaPlayer.getTime() && this.tile.data.loop) {
                    long mediaDuration = this.mediaPlayer.getMediaInfoDuration();
                    long l = time = time == 0L || mediaDuration == 0L ? 0L : Math.floorMod(time, this.mediaPlayer.getMediaInfoDuration());
                }
                if (Math.abs(time - this.mediaPlayer.getTime()) <= 1000L || Math.abs(time - this.currentLastTime.get()) <= 1000L) break;
                this.currentLastTime.set(time);
                this.mediaPlayer.seekTo(time);
            }
        }
    }

    public State getPlayerStateIfExists() {
        return switch (this.displayMode) {
            default -> throw new IncompatibleClassChangeError();
            case Mode.PICTURE -> State.NOTHING_SPECIAL;
            case Mode.VIDEO, Mode.AUDIO -> this.mediaPlayer.getRawPlayerState();
        };
    }

    public boolean isBuffering() {
        return switch (this.displayMode) {
            default -> throw new IncompatibleClassChangeError();
            case Mode.PICTURE -> false;
            case Mode.VIDEO, Mode.AUDIO -> this.mediaPlayer.isBuffering() || this.mediaPlayer.getRawPlayerState() == State.OPENING;
        };
    }

    public boolean isBroken() {
        return switch (this.displayMode) {
            default -> throw new IncompatibleClassChangeError();
            case Mode.PICTURE -> false;
            case Mode.VIDEO, Mode.AUDIO -> this.mediaPlayer.isBroken();
        };
    }

    public boolean isLoading() {
        return this.imageCache.getStatus() == ImageCache.Status.LOADING;
    }

    public void setPauseMode(boolean pause) {
        switch (this.displayMode) {
            case PICTURE: {
                break;
            }
            case VIDEO: 
            case AUDIO: {
                this.mediaPlayer.seekTo(MathAPI.tickToMs((long)this.tile.data.tick));
                this.mediaPlayer.setPauseMode(pause);
                this.mediaPlayer.setMuteMode(this.tile.data.muted);
            }
        }
    }

    public void setMuteMode(boolean mute) {
        switch (this.displayMode) {
            case PICTURE: {
                break;
            }
            case VIDEO: 
            case AUDIO: {
                this.mediaPlayer.setMuteMode(mute);
            }
        }
    }

    public void release() {
        switch (this.displayMode) {
            case PICTURE: {
                if (this.imageCache == null) break;
                this.imageCache.deuse();
                break;
            }
            case VIDEO: 
            case AUDIO: {
                this.mediaPlayer.release();
                DisplayControl.remove(this);
            }
        }
    }

    public static int limitVolume(BlockPos pos, int volume, int min, int max) {
        assert (Minecraft.m_91087_().f_91074_ != null);
        Vec3 position = Minecraft.m_91087_().f_91074_.m_20318_(WaterFrames.deltaFrames());
        double distance = Math.sqrt(pos.m_203202_(position.m_7096_(), position.m_7098_(), position.m_7094_()));
        if (min > max) {
            int temp = max;
            max = min;
            min = temp;
        }
        if (distance > (double)min) {
            volume = distance > (double)(max + 1) ? 0 : (int)((double)volume * (1.0 - (distance - (double)min) / (double)(1 + max - min)));
        }
        return volume;
    }

    public static enum Mode {
        VIDEO,
        PICTURE,
        AUDIO;

    }
}

