/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.common.screens;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.srrapero720.waterframes.WFConfig;
import me.srrapero720.waterframes.common.block.data.DisplayData;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import me.srrapero720.waterframes.common.compat.videoplayer.VPCompat;
import me.srrapero720.waterframes.common.helpers.ScalableText;
import me.srrapero720.waterframes.common.network.DisplayNetwork;
import me.srrapero720.waterframes.common.network.packets.DataSyncPacket;
import me.srrapero720.waterframes.common.screens.styles.IconStyles;
import me.srrapero720.waterframes.common.screens.styles.ScreenStyles;
import me.srrapero720.waterframes.common.screens.widgets.WidgetClickableArea;
import me.srrapero720.waterframes.common.screens.widgets.WidgetPairTable;
import me.srrapero720.waterframes.common.screens.widgets.WidgetStatusIcon;
import me.srrapero720.waterframes.common.screens.widgets.WidgetURLTextField;
import me.srrapero720.watermedia.api.image.ImageAPI;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.controls.simple.GuiButton;
import team.creative.creativecore.common.gui.controls.simple.GuiButtonIcon;
import team.creative.creativecore.common.gui.controls.simple.GuiCheckBox;
import team.creative.creativecore.common.gui.controls.simple.GuiCheckButtonIcon;
import team.creative.creativecore.common.gui.controls.simple.GuiCounterDecimal;
import team.creative.creativecore.common.gui.controls.simple.GuiIcon;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.controls.simple.GuiSeekBar;
import team.creative.creativecore.common.gui.controls.simple.GuiSlider;
import team.creative.creativecore.common.gui.controls.simple.GuiStateButtonIcon;
import team.creative.creativecore.common.gui.controls.simple.GuiSteppedSlider;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.parser.DoubleValueParser;
import team.creative.creativecore.common.gui.parser.IntValueParser;
import team.creative.creativecore.common.gui.parser.LongValueParser;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.gui.style.Icon;
import team.creative.creativecore.common.gui.style.display.StyleDisplay;
import team.creative.creativecore.common.util.type.Color;

public class DisplayScreen
extends GuiLayer {
    protected static final float SCALE = 0.0625f;
    protected static final int WIDTH = 270;
    protected static final int HEIGHT = 245;
    public final DisplayTile tile;
    private final GuiLabel url_l = new GuiLabel("media_label").setTranslate("waterframes.gui.label.url");
    private final GuiLabel tex_l = new GuiLabel("tex_label").setTranslate("waterframes.gui.label.texture_settings");
    private final GuiLabel media_l = new GuiLabel("media_label").setTranslate("waterframes.gui.label.media_settings");
    private final GuiIcon rot_i = (GuiIcon)new GuiIcon("r_icon", IconStyles.ROTATION).setTooltip("waterframes.gui.icon.rotation");
    private final GuiIcon vis_i = (GuiIcon)new GuiIcon("t_icon", IconStyles.TRANSPARENCY).setTooltip("waterframes.gui.icon.alpha");
    private final GuiIcon bright_i = (GuiIcon)new GuiIcon("b_icon", IconStyles.BRIGHTNESS).setTooltip("waterframes.gui.icon.brightness");
    private final GuiIcon render_i = (GuiIcon)new GuiIcon("r_icon", IconStyles.DISTANCE).setTooltip("waterframes.gui.icon.render_distance");
    private final GuiIcon project_i = (GuiIcon)new GuiIcon("pd_icon", IconStyles.PROJECTION_DISTANCE).setTooltip("waterframes.gui.icon.projection_distance");
    private final GuiIcon vol_i = (GuiIcon)new GuiIcon("v_icon", IconStyles.VOLUME).setTooltip("waterframes.gui.icon.volume");
    private final GuiIcon vol_min_i = (GuiIcon)new GuiIcon("v_min_icon", IconStyles.VOLUME_RANGE_MIN).setTooltip("waterframes.gui.icon.volume_min");
    private final GuiIcon vol_max_i = (GuiIcon)new GuiIcon("v_max_icon", IconStyles.VOLUME_RANGE_MAX).setTooltip("waterframes.gui.icon.volume_max");
    public final GuiButton save;
    public final WidgetURLTextField url;
    public final GuiCounterDecimal widthField;
    public final GuiCounterDecimal heightField;
    public final GuiSlider rotation;
    public final GuiSteppedSlider alpha;
    public final GuiSteppedSlider brightness;
    public final GuiSteppedSlider render_distance;
    public final GuiSlider projection_distance;
    public final GuiCheckBox show_model;
    public final GuiCheckBox render_behind;
    public final GuiCheckButtonIcon loop;
    public final GuiCheckButtonIcon playback;
    public final GuiControl stop;
    public final GuiStateButtonIcon audioOffset;
    public final GuiButton reload_all;
    public final GuiButton reload;
    public GuiControl seekbar;
    public GuiButtonIcon videoplayer;
    public final GuiCheckBox flip_x;
    public final GuiCheckBox flip_y;
    public final GuiSteppedSlider volume;
    public final GuiSteppedSlider volume_min;
    public final GuiSteppedSlider volume_max;
    public final WidgetClickableArea pos_view;

    public DisplayScreen(DisplayTile tile) {
        super("display_screen", 270, 245);
        this.setAlign(Align.STRETCH);
        this.flow = GuiFlow.STACK_Y;
        this.tile = tile;
        this.save = new GuiButton("save", x -> DisplayNetwork.sendServer(new DataSyncPacket(tile.m_58899_(), DisplayData.build(this, tile))));
        this.save.setTranslate("waterframes.gui.save");
        this.url = new WidgetURLTextField(this.tile);
        this.widthField = new GuiCounterDecimal("width", (double)tile.data.getWidth(), 0.1, (double)WFConfig.maxWidth(), ControlFormatting.CLICKABLE_NO_PADDING);
        this.widthField.setSpacing(0).setStep(0.0625).setAlign(Align.STRETCH).setVAlign(VAlign.STRETCH);
        this.widthField.buttons.setVAlign(VAlign.STRETCH);
        this.widthField.get("value").setTooltip("waterframes.common.width");
        this.heightField = new GuiCounterDecimal("height", (double)tile.data.getHeight(), 0.1, (double)WFConfig.maxHeight(), ControlFormatting.CLICKABLE_NO_PADDING);
        this.heightField.setSpacing(0).setStep(0.0625).setAlign(Align.STRETCH).setVAlign(VAlign.STRETCH);
        this.heightField.buttons.setVAlign(VAlign.STRETCH);
        this.heightField.get("value").setTooltip("waterframes.common.height");
        GuiControl resize_y = new GuiButtonIcon("resize_y", IconStyles.EXPAND_Y, integer -> {
            if (tile.display != null) {
                this.heightField.setValue((double)((float)((double)tile.display.height() / ((double)tile.display.width() / this.widthField.getValue()))));
            }
        }).setTooltip("waterframes.gui.resize_y");
        GuiControl resize_x = new GuiButtonIcon("resize_x", IconStyles.EXPAND_X, integer -> {
            if (tile.display != null) {
                this.widthField.setValue((double)((float)((double)tile.display.width() / ((double)tile.display.height() / this.heightField.getValue()))));
            }
        }).setTooltip("waterframes.gui.resize_x");
        this.widthField.addControl(resize_y.setDim(16, 16));
        this.heightField.addControl(resize_x.setDim(16, 16));
        this.flip_x = new GuiCheckBox("flip_x", tile.data.flipX);
        this.flip_y = new GuiCheckBox("flip_y", tile.data.flipY);
        this.flip_x.setTranslate("waterframes.gui.flip_x");
        this.flip_y.setTranslate("waterframes.gui.flip_y");
        this.rotation = new GuiSlider("rotation", (double)tile.data.rotation, 0.0, 360.0, DoubleValueParser.ANGLE);
        this.alpha = new GuiSteppedSlider("alpha", tile.data.alpha, 0, 255, (v, max) -> Math.round((v != 0 && max != 0 ? (float)v / (float)max : 0.0f) * 100.0f) + "%");
        this.brightness = new GuiSteppedSlider("brightness", tile.data.brightness, 0, 255, (v, max) -> Math.round((v != 0 && max != 0 ? (float)v / (float)max : 0.0f) * 100.0f) + "%");
        this.render_distance = new GuiSteppedSlider("render_distance", tile.data.renderDistance, 4, WFConfig.maxRenDis(), IntValueParser.BLOCKS);
        this.projection_distance = new GuiSlider("projection_distance", (double)tile.data.projectionDistance, 4.0, (double)WFConfig.maxProjDis(), DoubleValueParser.BLOCKS);
        this.audioOffset = new GuiStateButtonIcon("audio_offset", new Icon[]{IconStyles.AUDIO_POS_BLOCK, IconStyles.AUDIO_POS_PICTURE, IconStyles.AUDIO_POS_CENTER}){

            public List<Component> getTooltip() {
                ArrayList<Component> tooltip = new ArrayList<Component>();
                tooltip.add((Component)1.translatable((String)"waterframes.gui.audio_pos.1"));
                tooltip.add((Component)1.translatable((String)"waterframes.gui.audio_pos.2", (Object[])new Object[]{ChatFormatting.AQUA + 1.translate((String)("waterframes.gui.audio_pos.states." + this.getState()))}));
                return tooltip;
            }
        }.setControlFormatting(ControlFormatting.CLICKABLE_NO_PADDING).setState(tile.data.getAudioPosition().ordinal());
        this.audioOffset.setShadow(Color.NONE);
        this.show_model = new GuiCheckBox("visible", false);
        this.render_behind = new GuiCheckBox("render_both", tile.data.renderBothSides);
        this.show_model.setTranslate("waterframes.gui.show_model");
        this.render_behind.setTranslate("waterframes.gui.render_behind");
        this.pos_view = new WidgetClickableArea("pos_area", tile.data.getPosX(), tile.data.getPosY());
        this.playback = new GuiCheckButtonIcon("playback", IconStyles.PLAY, IconStyles.PAUSE, tile.data.paused, button -> tile.setPause(true, !tile.data.paused));
        this.stop = new GuiButtonIcon("stop", IconStyles.STOP, button -> tile.setStop(true));
        this.loop = new GuiCheckButtonIcon("loop", IconStyles.REPEAT_ON, IconStyles.REPEAT_OFF, tile.data.loop, button -> tile.loop(true, !tile.data.loop)){

            public List<Component> getTooltip() {
                return Collections.singletonList(2.translatable((String)"waterframes.gui.loop", (Object[])new Object[]{(this.value ? ChatFormatting.GREEN : ChatFormatting.RED) + 2.translate((String)("waterframes.common." + this.value))}));
            }
        };
        this.volume = new GuiSteppedSlider("volume", tile.data.volume, 0, WFConfig.maxVol(), (v, max) -> v + "%");
        this.volume_min = new GuiSteppedSlider("volume_min_range", tile.data.minVolumeDistance, 0, Math.min(tile.data.maxVolumeDistance, WFConfig.maxVolDis()), IntValueParser.BLOCKS);
        this.volume_max = new GuiSteppedSlider("volume_max_range", tile.data.maxVolumeDistance, 0, WFConfig.maxVolDis(), IntValueParser.BLOCKS);
        this.volume_max.setMinSlider((GuiSlider)this.volume_min);
        this.reload_all = new GuiButton("reload_all", x -> ImageAPI.reloadCache());
        this.reload = new GuiButton("reload", x -> tile.imageCache.reload());
        this.reload_all.setTranslate("waterframes.gui.reload.all").setTooltip("waterframes.gui.reload.all.warning");
        this.reload.setTranslate("waterframes.gui.reload");
        if (VPCompat.installed()) {
            this.videoplayer = new GuiButtonIcon("", IconStyles.VIDEOPLAYER_PLAY, button -> {
                VPCompat.playVideo(tile.data.url, tile.data.volume, true);
                tile.setPause(true, true);
            });
            this.videoplayer.setTooltip("waterframes.gui.videoplayer");
        }
        this.seekbar = new GuiSeekBar("seek", () -> tile.data.tick, () -> tile.data.tickMax, LongValueParser.TIME_DURATION_TICK).setOnTimeUpdate(v -> {
            tile.data.tick = v;
        }).setOnLastTimeUpdate(v -> tile.syncTime(true, v, tile.data.tickMax));
        ((ScalableText)this.url_l).wf$setScale(0.75f);
        ((ScalableText)this.tex_l).wf$setScale(0.75f);
        ((ScalableText)this.media_l).wf$setScale(0.75f);
        ((ScalableText)this.rotation).wf$setScale(0.9f);
        ((ScalableText)this.alpha).wf$setScale(0.9f);
        ((ScalableText)this.brightness).wf$setScale(0.9f);
        ((ScalableText)this.render_distance).wf$setScale(0.9f);
        ((ScalableText)this.projection_distance).wf$setScale(0.9f);
        ((ScalableText)this.volume_min).wf$setScale(0.9f);
        ((ScalableText)this.volume_max).wf$setScale(0.9f);
        if (!tile.caps.resizes()) {
            this.setDim(270, 195);
        }
    }

    public void create() {
        if (!this.isClient()) {
            return;
        }
        WidgetPairTable table = new WidgetPairTable((GuiFlow)GuiFlow.STACK_Y, 4).addLeft(new GuiControl[]{this.url_l}).addLeft(this.url.setExpandableX()).addRight(new GuiControl[]{new WidgetStatusIcon("", IconStyles.STATUS_OK, this.tile).setDim(30, 30)});
        this.add((GuiControl)table);
        GuiParent sizeTable = new GuiParent("", (GuiFlow)GuiFlow.STACK_X, Align.STRETCH).setSpacing(4);
        if (this.tile.caps.resizes()) {
            sizeTable.add(this.widthField.setExpandableX()).add(this.heightField.setExpandableX()).add((GuiControl)new GuiParent((GuiFlow)GuiFlow.STACK_Y).add((GuiControl)this.flip_x).add((GuiControl)this.flip_y));
            this.add((GuiControl)sizeTable);
        }
        GuiParent basicOptions = new GuiParent("", (GuiFlow)GuiFlow.STACK_X, Align.STRETCH).setSpacing(1).add(this.tile.canHideModel(), () -> {
            this.show_model.set(this.tile.isVisible());
            return this.show_model;
        }).add(this.tile.caps.renderBehind(), () -> this.render_behind).add(!this.tile.caps.resizes(), () -> this.flip_x).add(!this.tile.caps.resizes(), () -> this.flip_y);
        this.add((GuiControl)this.tex_l);
        this.add(new WidgetPairTable((GuiFlow)GuiFlow.STACK_Y, 2).addLeft(this.tile.caps.resizes(), () -> new GuiParent((GuiFlow)GuiFlow.STACK_X).add((GuiControl)this.rot_i).add(this.rotation.setDim(130, 12)).setVAlign(VAlign.CENTER)).addLeft(new GuiControl[]{new GuiParent((GuiFlow)GuiFlow.STACK_X).add((GuiControl)this.vis_i).add(this.alpha.setDim(130, 12)).setVAlign(VAlign.CENTER)}).addLeft(new GuiControl[]{new GuiParent((GuiFlow)GuiFlow.STACK_X).add((GuiControl)this.bright_i).add(this.brightness.setDim(130, 12)).setVAlign(VAlign.CENTER)}).addLeft(new GuiControl[]{new GuiParent((GuiFlow)GuiFlow.STACK_X).add((GuiControl)this.render_i).add(this.render_distance.setDim(130, 12)).setVAlign(VAlign.CENTER)}).addLeft(this.tile.caps.projects(), () -> new GuiParent((GuiFlow)GuiFlow.STACK_X).add((GuiControl)this.project_i).add(this.projection_distance.setDim(100, 13)).add((GuiControl)this.audioOffset.setDim(26, 13)).setVAlign(VAlign.CENTER)).addLeft(!basicOptions.isEmpty(), () -> basicOptions).addRight(this.tile.caps.resizes(), () -> this.pos_view.setDim(80, 80)).setAlignRight(Align.CENTER).setExpandableY());
        this.add((GuiControl)this.media_l);
        WidgetPairTable mediaSettingsTable = new WidgetPairTable((GuiFlow)GuiFlow.STACK_X, 2).addRight(new GuiControl[]{this.vol_i.setIcon(IconStyles.getVolumeIcon(this.tile.data.volume, this.tile.data.muted)), this.volume.setDim(100, 15).setExpandableX()}).addLeft(VPCompat.installed(), () -> this.videoplayer.setDim(16, 12)).setAlignRight(Align.RIGHT).setVAlignRight(VAlign.CENTER).setLeftExpandableX().setRightExpandableX().createRow().addRight(new GuiControl[]{this.vol_min_i, this.volume_min.setDim(63, 10).setExpandableX(), this.vol_max_i, this.volume_max.setDim(63, 10).setExpandableX()}).setAlignRight(Align.RIGHT).setVAlignRight(VAlign.CENTER).setLeftExpandableX().setRightExpandableX();
        this.add((GuiControl)mediaSettingsTable);
        this.add((GuiControl)new GuiParent((GuiFlow)GuiFlow.STACK_X).add(new GuiControl[]{this.loop.setDim(14, 14), this.playback.setSquared(true).setDim(20, 14), this.stop.setDim(14, 14), this.seekbar.setDim(150, 18).setExpandableX()}));
        this.add((GuiControl)new WidgetPairTable((GuiFlow)GuiFlow.STACK_X, Align.RIGHT, 2).addLeft(this.reload_all.setAlign(Align.CENTER).setVAlign(VAlign.CENTER).setDim(90, 10)).addRight(this.save.setAlign(Align.CENTER).setVAlign(VAlign.CENTER).setDim(70, 10).setEnabled(WFConfig.canSave(this.getPlayer(), this.url.getText()))).addRight(this.reload.setAlign(Align.CENTER).setVAlign(VAlign.CENTER).setDim(70, 10)).setAlignRight(Align.RIGHT));
    }

    public void tick() {
        super.tick();
        if (!this.isClient()) {
            return;
        }
        this.vol_i.setIcon(IconStyles.getVolumeIcon((int)this.volume.getValue(), this.tile.data.muted));
        this.playback.setState(this.tile.data.paused);
        String text = this.url.getText();
        this.save.setEnabled(WFConfig.canSave(this.getPlayer(), text));
        this.reload.setEnabled(this.tile.imageCache != null && !text.isEmpty() && !this.tile.data.url.isEmpty() && text.equals(this.tile.data.url));
    }

    @OnlyIn(value=Dist.CLIENT)
    public StyleDisplay getBackground(GuiStyle style, StyleDisplay display) {
        return ScreenStyles.SCREEN_BACKGROUND;
    }

    @OnlyIn(value=Dist.CLIENT)
    public StyleDisplay getBorder(GuiStyle style, StyleDisplay display) {
        return ScreenStyles.SCREEN_BORDER;
    }
}

