/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.screen;

import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.com.unascribed.qdcss.QDCSS;
import dev.emi.emi.config.ConfigPresets;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.ConfigScreen;
import dev.emi.emi.screen.widget.config.EmiNameWidget;
import dev.emi.emi.screen.widget.config.ListWidget;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ConfigPresetScreen
extends Screen {
    private final ConfigScreen last;
    private ListWidget list;
    public Button resetButton;

    public ConfigPresetScreen(ConfigScreen last) {
        super((Component)EmiPort.translatable("screen.emi.presets"));
        this.last = last;
    }

    public void m_7856_() {
        super.m_7856_();
        this.m_169394_(new EmiNameWidget(this.f_96543_ / 2, 16));
        int w = Math.min(400, this.f_96543_ - 40);
        int x = (this.f_96543_ - w) / 2;
        this.resetButton = EmiPort.newButton(x + 2, this.f_96544_ - 30, w / 2 - 2, 20, (Component)EmiPort.translatable("gui.done"), button -> {
            EmiConfig.loadConfig(QDCSS.load("revert", this.last.originalConfig));
            Minecraft client = Minecraft.m_91087_();
            this.m_6575_(client, client.m_91268_().m_85445_(), client.m_91268_().m_85446_());
        });
        this.m_142416_((GuiEventListener)this.resetButton);
        this.m_142416_((GuiEventListener)EmiPort.newButton(x + w / 2 + 2, this.f_96544_ - 30, w / 2 - 2, 20, (Component)EmiPort.translatable("gui.done"), button -> this.m_7379_()));
        this.list = new ListWidget(this.f_96541_, this.f_96543_, this.f_96544_, 40, this.f_96544_ - 40);
        try {
            for (Field field : ConfigPresets.class.getFields()) {
                MutableComponent translation;
                Object object;
                EmiConfig.ConfigValue config = field.getDeclaredAnnotation(EmiConfig.ConfigValue.class);
                if (config == null || !((object = field.get(null)) instanceof Runnable)) continue;
                Runnable runnable = (Runnable)object;
                EmiConfig.ConfigGroup group = field.getDeclaredAnnotation(EmiConfig.ConfigGroup.class);
                if (group != null) {
                    translation = EmiPort.translatable("config.emi." + group.value().replace('-', '_'));
                    this.list.addEntry(new PresetGroupWidget((Component)translation));
                }
                translation = EmiPort.translatable("config.emi." + config.value().replace('-', '_'));
                this.list.addEntry(new PresetWidget(runnable, (Component)translation, ConfigScreen.getFieldTooltip(field)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_7787_((GuiEventListener)this.list);
        this.updateChanges();
    }

    public void m_88315_(GuiGraphics raw, int mouseX, int mouseY, float delta) {
        EmiDrawContext context = EmiDrawContext.wrap(raw);
        this.list.setScrollAmount(this.list.getScrollAmount());
        this.m_280039_(context.raw());
        this.list.m_88315_(context.raw(), mouseX, mouseY, delta);
        super.m_88315_(context.raw(), mouseX, mouseY, delta);
        ListWidget.Entry entry = this.list.getHoveredEntry();
        if (entry instanceof PresetWidget) {
            PresetWidget widget = (PresetWidget)entry;
            if (widget.button.m_274382_()) {
                EmiRenderHelper.drawTooltip(this, context, widget.tooltip, mouseX, mouseY);
            }
        }
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_((Screen)this.last);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.m_7379_();
            return true;
        }
        if (this.f_96541_.f_91066_.f_92092_.m_90832_(keyCode, scanCode)) {
            this.m_7379_();
            return true;
        }
        if (keyCode == 258) {
            return false;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void updateChanges() {
        String[] oLines = this.last.originalConfig.split("\n\n");
        String[] cLines = EmiConfig.getSavedConfig().split("\n\n");
        int different = 0;
        for (int i = 0; i < oLines.length && i < cLines.length; ++i) {
            if (oLines[i].equals(cLines[i])) continue;
            ++different;
        }
        this.resetButton.f_93623_ = different > 0;
        this.resetButton.m_93666_((Component)EmiPort.translatable("screen.emi.config.reset", different));
    }

    public class PresetGroupWidget
    extends ListWidget.Entry {
        private final Component text;

        public PresetGroupWidget(Component text) {
            this.text = text;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return List.of();
        }

        @Override
        public void render(GuiGraphics raw, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
            EmiDrawContext context = EmiDrawContext.wrap(raw);
            context.drawCenteredTextWithShadow(this.text, x + width / 2, y + 3, -1);
        }

        @Override
        public int getHeight() {
            return 20;
        }
    }

    public class PresetWidget
    extends ListWidget.Entry {
        private final Button button;
        private final List<ClientTooltipComponent> tooltip;

        public PresetWidget(Runnable runnable, Component name, List<ClientTooltipComponent> tooltip) {
            this.button = EmiPort.newButton(0, 0, 200, 20, name, t -> {
                runnable.run();
                ConfigPresetScreen.this.updateChanges();
            });
            this.tooltip = tooltip;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return List.of(this.button);
        }

        @Override
        public void render(GuiGraphics raw, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
            this.button.f_93621_ = y;
            this.button.f_93620_ = x + width / 2 - this.button.m_5711_() / 2;
            this.button.m_88315_(raw, mouseX, mouseY, delta);
        }

        @Override
        public int getHeight() {
            return 20;
        }
    }
}

