/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.screen.tooltip;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.tooltip.EmiTooltip;
import dev.emi.emi.screen.tooltip.EmiTooltipComponent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class RemainderTooltipComponent
implements EmiTooltipComponent {
    public List<Remainder> remainders = Lists.newArrayList();

    public RemainderTooltipComponent(EmiIngredient ingredient) {
        HashMap tools = Maps.newHashMap();
        block0: for (EmiStack emiStack : ingredient.getEmiStacks()) {
            int damage = this.getDamageDelta(emiStack, emiStack.getRemainder());
            if (damage != 0) {
                tools.computeIfAbsent(damage, i -> Lists.newArrayList()).add(emiStack);
                continue;
            }
            for (Remainder remainder : this.remainders) {
                if (!remainder.remainder.isEqual(emiStack.getRemainder())) continue;
                remainder.inputs.add(emiStack);
                continue block0;
            }
            if (emiStack.getRemainder().isEmpty()) continue;
            this.remainders.add(new Remainder(emiStack, emiStack.getRemainder()));
        }
        for (Map.Entry entry : tools.entrySet()) {
            this.remainders.add(new Remainder((List)entry.getValue(), (Integer)entry.getKey()));
        }
    }

    public int m_142103_() {
        return 18 * this.remainders.size();
    }

    public int m_142069_(Font var1) {
        return 54;
    }

    @Override
    public void drawTooltip(EmiDrawContext context, EmiTooltipComponent.TooltipRenderData render) {
        for (int i = 0; i < this.remainders.size(); ++i) {
            Remainder remainder = this.remainders.get(i);
            EmiIngredient input = EmiIngredient.of(remainder.inputs);
            context.drawStack(input, 0, 18 * i, -11);
            if (remainder.damage == 0) {
                context.drawStack(remainder.remainder, 36, 18 * i, -9);
                continue;
            }
            context.drawStack(input, 36, 18 * i, 3);
            ItemStack is = input.getEmiStacks().get(0).getItemStack().m_41777_();
            is.m_41721_(is.m_41773_() - remainder.damage);
            context.raw().m_280302_(render.text, is, 36, 18 * i, "");
            context.drawStack(input, 36, 18 * i, -12);
            MutableComponent t = remainder.damage > 0 ? EmiPort.literal("+" + remainder.damage, ChatFormatting.GREEN) : EmiPort.literal("" + remainder.damage, ChatFormatting.RED);
            int width = render.text.m_92852_((FormattedText)t);
            context.push();
            context.matrices().m_252880_(0.0f, 0.0f, 200.0f);
            context.drawText((Component)t, 42 - width, i * 18);
            context.pop();
        }
    }

    @Override
    public void drawTooltipText(EmiTooltipComponent.TextRenderData text) {
        for (int i = 0; i < this.remainders.size(); ++i) {
            Remainder remainder = this.remainders.get(i);
            boolean chanced = remainder.chance != 1.0f;
            text.draw((Component)EmiPort.literal("->"), 20, 5 + i * 18 - (chanced ? 4 : 0), 0xFFFFFF, true);
            if (!chanced) continue;
            MutableComponent t = EmiPort.literal(EmiTooltip.TEXT_FORMAT.format(remainder.chance * 100.0f) + "%");
            int tx = text.renderer.m_92852_((FormattedText)t);
            text.draw((Component)t, 27 - tx / 2, 9 + i * 18, (int)ChatFormatting.GOLD.m_126665_(), false);
        }
    }

    private int getDamageDelta(EmiStack stack, EmiStack remainder) {
        if (remainder.isEqual(stack)) {
            return stack.getItemStack().m_41773_() - remainder.getItemStack().m_41773_();
        }
        return 0;
    }

    private static class Remainder {
        public final List<EmiStack> inputs = Lists.newArrayList();
        public final EmiStack remainder;
        public int damage = 0;
        public float chance = 1.0f;

        public Remainder(EmiStack input, EmiStack remainder) {
            this.inputs.add(input);
            this.remainder = remainder;
            this.chance = remainder.getChance();
        }

        public Remainder(List<EmiStack> inputs, int damage) {
            this.inputs.addAll(inputs);
            this.remainder = EmiStack.EMPTY;
            this.damage = damage;
        }
    }
}

