/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config.ui;

import dev.architectury.registry.registries.RegistrarManager;
import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.FTBLibraryClientConfig;
import dev.ftb.mods.ftblibrary.config.ItemStackConfig;
import dev.ftb.mods.ftblibrary.config.ui.ResourceSearchMode;
import dev.ftb.mods.ftblibrary.config.ui.ResourceSelectorScreen;
import dev.ftb.mods.ftblibrary.config.ui.SearchModeIndex;
import dev.ftb.mods.ftblibrary.config.ui.SelectableResource;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.util.ModUtils;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class SelectItemStackScreen
extends ResourceSelectorScreen<ItemStack> {
    public static final SearchModeIndex<ResourceSearchMode<ItemStack>> KNOWN_MODES = new SearchModeIndex();

    public SelectItemStackScreen(ItemStackConfig config, ConfigCallback callback) {
        super(config, callback);
    }

    @Override
    protected SearchModeIndex<ResourceSearchMode<ItemStack>> getSearchModeIndex() {
        return KNOWN_MODES;
    }

    @Override
    protected ResourceSelectorScreen.ResourceButton makeResourceButton(Panel panel, SelectableResource<ItemStack> resource) {
        return new ItemStackButton(panel, Objects.requireNonNullElse(resource, SelectableResource.item(ItemStack.f_41583_)));
    }

    static {
        KNOWN_MODES.appendMode(ResourceSearchMode.ALL_ITEMS);
        KNOWN_MODES.appendMode(ResourceSearchMode.INVENTORY);
    }

    private class ItemStackButton
    extends ResourceSelectorScreen.ResourceButton {
        private ItemStackButton(Panel panel, SelectableResource<ItemStack> resource) {
            super(SelectItemStackScreen.this, panel, resource);
        }

        @Override
        public boolean shouldAdd(String search) {
            if ((search = search.toLowerCase()).isEmpty()) {
                return true;
            }
            if (search.startsWith("@")) {
                return RegistrarManager.getId((Object)((ItemStack)this.getStack()).m_41720_(), (ResourceKey)Registries.f_256913_).m_135827_().contains(search.substring(1));
            }
            if (search.startsWith("#") && ResourceLocation.m_135830_((String)search.substring(1))) {
                return ((ItemStack)this.getStack()).m_204117_(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(search.substring(1))));
            }
            return ((ItemStack)this.getStack()).m_41786_().getString().toLowerCase().contains(search);
        }

        @Override
        public void addMouseOverText(TooltipList list) {
            if (!((ItemStack)this.getStack()).m_41619_()) {
                TooltipFlag.Default flag = Minecraft.m_91087_().f_91066_.f_92125_ ? TooltipFlag.f_256730_ : TooltipFlag.f_256752_;
                ((ItemStack)this.getStack()).m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)flag).forEach(list::add);
                if (((Boolean)FTBLibraryClientConfig.ITEM_MODNAME.get()).booleanValue()) {
                    ModUtils.getModName(((ItemStack)this.getStack()).m_41720_()).ifPresent(name -> list.add((Component)Component.m_237113_((String)name).m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC})));
                }
            }
        }
    }
}

