/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.kiulian.downloader.model.videos.formats;

import me.lib720.alibaba.fastjson.JSONObject;
import me.lib720.kiulian.downloader.model.videos.formats.VideoFormat;
import me.lib720.kiulian.downloader.model.videos.quality.AudioQuality;

public class VideoWithAudioFormat
extends VideoFormat {
    private final Integer averageBitrate;
    private final Integer audioSampleRate;
    private final AudioQuality audioQuality;

    public VideoWithAudioFormat(JSONObject json, boolean isAdaptive, String clientVersion) {
        super(json, isAdaptive, clientVersion);
        this.audioSampleRate = json.getInteger("audioSampleRate");
        this.averageBitrate = json.getInteger("averageBitrate");
        AudioQuality audioQuality = null;
        if (json.containsKey("audioQuality")) {
            String[] split = json.getString("audioQuality").split("_");
            String quality = split[split.length - 1].toLowerCase();
            try {
                audioQuality = AudioQuality.valueOf(quality);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.audioQuality = audioQuality;
    }

    @Override
    public String type() {
        return "audio/video";
    }

    public Integer averageBitrate() {
        return this.averageBitrate;
    }

    public AudioQuality audioQuality() {
        return this.audioQuality != null ? this.audioQuality : this.itag.audioQuality();
    }

    public Integer audioSampleRate() {
        return this.audioSampleRate;
    }
}

