/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.tukaani.xz;

import java.io.InputStream;
import me.lib720.tukaani.xz.ArrayCache;
import me.lib720.tukaani.xz.FilterDecoder;
import me.lib720.tukaani.xz.LZMA2Coder;
import me.lib720.tukaani.xz.LZMA2InputStream;
import me.lib720.tukaani.xz.UnsupportedOptionsException;

class LZMA2Decoder
extends LZMA2Coder
implements FilterDecoder {
    private int dictSize;

    LZMA2Decoder(byte[] byArray) throws UnsupportedOptionsException {
        if (byArray.length != 1 || (byArray[0] & 0xFF) > 37) {
            throw new UnsupportedOptionsException("Unsupported LZMA2 properties");
        }
        this.dictSize = 2 | byArray[0] & 1;
        this.dictSize <<= (byArray[0] >>> 1) + 11;
    }

    @Override
    public int getMemoryUsage() {
        return LZMA2InputStream.getMemoryUsage(this.dictSize);
    }

    @Override
    public InputStream getInputStream(InputStream inputStream, ArrayCache arrayCache) {
        return new LZMA2InputStream(inputStream, this.dictSize, null, arrayCache);
    }
}

