/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.api.image;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import me.srrapero720.watermedia.WaterMedia;
import me.srrapero720.watermedia.api.image.ImageAPI;
import me.srrapero720.watermedia.api.image.ImageFetch;
import me.srrapero720.watermedia.api.image.ImageRenderer;

public class ImageCache {
    static final Map<String, ImageCache> CACHE = new HashMap<String, ImageCache>();
    static final ImageCache EMPTY_INSTANCE = new ImageCache(null);
    public final String url;
    private final ImageFetch fetch;
    private final Executor renderThreadEx;
    private volatile boolean video = false;
    private final AtomicInteger uses = new AtomicInteger(1);
    private volatile Status status = Status.WAITING;
    private volatile ImageRenderer renderer;
    private volatile Exception exception;

    @Deprecated
    public static ImageCache get(String originalURL, Executor renderThreadEx) {
        return ImageAPI.getCache(originalURL, renderThreadEx);
    }

    @Deprecated
    public static void reloadAll() {
        for (ImageCache imageCache : CACHE.values()) {
            imageCache.reload();
        }
    }

    @Deprecated
    public ImageCache(String url, Executor runnable) {
        this.url = url;
        this.renderThreadEx = runnable;
        this.fetch = new ImageFetch(url);
        CACHE.put(url, this);
    }

    @Deprecated
    public ImageCache(ImageRenderer renderer) {
        this.url = "";
        this.fetch = null;
        this.renderThreadEx = null;
        this.renderer = renderer;
    }

    public boolean isVideo() {
        return this.video;
    }

    public boolean isUsed() {
        return this.uses.get() > 0;
    }

    public ImageCache use() {
        this.uses.getAndIncrement();
        return this;
    }

    public ImageCache deuse() {
        if (this.uses.decrementAndGet() <= 0) {
            this.release();
        }
        return this;
    }

    public ImageCache flush() {
        if (this.uses.get() == 1 && this.renderer != null && !this.renderer.isFlushed()) {
            this.renderer.flush();
        }
        return this;
    }

    public ImageCache reset() {
        if (this.uses.get() == 1 && this.renderer != null && this.renderer.isFlushed()) {
            this.renderer.reset();
        }
        return this;
    }

    public Status getStatus() {
        return this.status;
    }

    public Exception getException() {
        return this.exception;
    }

    public ImageRenderer getRenderer() {
        return this.renderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        if (this.fetch == null) {
            return;
        }
        ImageFetch imageFetch = this.fetch;
        synchronized (imageFetch) {
            if (!this.status.equals((Object)Status.WAITING)) {
                return;
            }
            this.status = Status.LOADING;
            this.fetch.setOnSuccessCallback(imageRenderer -> {
                ImageFetch imageFetch = this.fetch;
                synchronized (imageFetch) {
                    if (!this.status.equals((Object)Status.LOADING)) {
                        this.renderThreadEx.execute(imageRenderer::release);
                        return;
                    }
                    this.renderer = imageRenderer;
                    this.video = false;
                    this.exception = null;
                    this.status = Status.READY;
                }
            }).setOnFailedCallback(exception -> {
                ImageFetch imageFetch = this.fetch;
                synchronized (imageFetch) {
                    this.renderer = null;
                    if (!this.status.equals((Object)Status.LOADING)) {
                        return;
                    }
                    if (exception instanceof ImageFetch.NoPictureException) {
                        this.video = true;
                        this.exception = null;
                        this.status = Status.READY;
                    } else {
                        this.exception = exception;
                        this.status = Status.FAILED;
                    }
                }
            }).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        if (this.fetch == null) {
            return;
        }
        ImageFetch imageFetch = this.fetch;
        synchronized (imageFetch) {
            if (!this.status.equals((Object)Status.READY) && !this.status.equals((Object)Status.FAILED)) {
                return;
            }
            this.status = Status.WAITING;
            this.video = false;
            this.exception = null;
            ImageRenderer imageRenderer = this.renderer;
            this.renderer = null;
            if (imageRenderer != null) {
                this.renderThreadEx.execute(imageRenderer::release);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (this.fetch == null) {
            return;
        }
        ImageFetch imageFetch = this.fetch;
        synchronized (imageFetch) {
            if (this.uses.get() > 0) {
                WaterMedia.LOGGER.warn(ImageAPI.IT, "Cache of '{}' released with {} usages remaining", (Object)this.url, (Object)this.uses.get());
            }
            this.status = Status.FORGOTTEN;
            this.video = false;
            this.exception = null;
            ImageRenderer imageRenderer = this.renderer;
            this.renderer = null;
            if (this.renderer != null) {
                this.renderThreadEx.execute(imageRenderer::release);
            }
            CACHE.remove(this.url);
        }
    }

    public static enum Status {
        WAITING,
        LOADING,
        READY,
        FORGOTTEN,
        FAILED;

    }
}

