/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.api.url.fixers;

import com.google.gson.Gson;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.URL;
import me.srrapero720.watermedia.api.network.twitter.TweetScrapper;
import me.srrapero720.watermedia.api.url.fixers.URLFixer;

public class TwitterFixer
extends URLFixer {
    private static final Gson gson = new Gson();

    @Override
    public String platform() {
        return "Twitter";
    }

    @Override
    public boolean isValid(URL url) {
        return (url.getHost().equals("www.x.com") || url.getHost().equals("x.com") || url.getHost().equals("www.twitter.com") || url.getHost().equals("twitter.com")) && url.getPath().matches("/[a-zA-Z0-9_]+/status/[0-9]+");
    }

    @Override
    public URLFixer.Result patch(URL url, URLFixer.Quality preferQuality) throws URLFixer.FixingURLException {
        super.patch(url, preferQuality);
        try {
            return new URLFixer.Result(new URL(new TweetScrapper(gson).extractVideo(String.valueOf(url)).get(0)), true, false);
        }
        catch (Exception e) {
            throw new URLFixer.FixingURLException(url.toString(), (Throwable)e);
        }
    }

    static {
        CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
    }
}

