/*
 * Decompiled with CFR 0.152.
 */
package net.shizotoaster.foglooksmodernnow.client;

import com.mojang.blaze3d.shaders.FogShape;
import net.minecraft.util.Mth;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.shizotoaster.foglooksmodernnow.client.FogManager;
import net.shizotoaster.foglooksmodernnow.util.MathUtils;

@Mod.EventBusSubscriber(modid="foglooksmodernnow", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onRenderFog(ViewportEvent.RenderFog event) {
        if (event.getCamera().m_167685_() == FogType.NONE) {
            FogManager densityManager = FogManager.getDensityManager();
            float renderDistance = event.getRenderer().m_109152_();
            float undergroundFogMultiplier = 1.0f;
            if (FogManager.shouldRenderCaveFog()) {
                undergroundFogMultiplier = (float)Mth.m_14139_((double)densityManager.getUndergroundFactor((float)event.getPartialTick()), (double)densityManager.caveFogMultiplier, (double)1.0);
                float darkness = densityManager.darkness.get((float)event.getPartialTick());
                undergroundFogMultiplier = Mth.m_14179_((float)darkness, (float)undergroundFogMultiplier, (float)1.0f);
            }
            event.setNearPlaneDistance(renderDistance * densityManager.fogStart.get((float)event.getPartialTick()));
            event.setFarPlaneDistance(renderDistance * densityManager.fogEnd.get((float)event.getPartialTick()) * undergroundFogMultiplier);
            event.setFogShape(FogShape.SPHERE);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRenderFogColors(ViewportEvent.ComputeFogColor event) {
        if (FogManager.shouldRenderCaveFog()) {
            FogManager densityManager = FogManager.getDensityManager();
            Vec3 fogColor = FogManager.getCaveFogColor();
            float undergroundFactor = 1.0f - densityManager.getUndergroundFactor((float)event.getPartialTick());
            event.setRed((float)MathUtils.lerp(undergroundFactor, event.getRed(), fogColor.f_82479_ * densityManager.unlitFogColor.m_7096_()));
            event.setGreen((float)MathUtils.lerp(undergroundFactor, event.getGreen(), fogColor.f_82480_ * densityManager.unlitFogColor.m_7098_()));
            event.setBlue((float)MathUtils.lerp(undergroundFactor, event.getBlue(), fogColor.f_82481_ * densityManager.unlitFogColor.m_7094_()));
        }
    }
}

