/*
 * Decompiled with CFR 0.152.
 */
package net.shizotoaster.foglooksmodernnow.client;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.CubicSampler;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import net.shizotoaster.foglooksmodernnow.FogLooksModernNow;
import net.shizotoaster.foglooksmodernnow.config.FogLooksGoodNowConfig;
import net.shizotoaster.foglooksmodernnow.util.MathUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class FogManager {
    @Nullable
    public static FogManager densityManager;
    private final Minecraft mc;
    public InterpolatedValue fogStart;
    public InterpolatedValue fogEnd;
    public InterpolatedValue currentSkyLight;
    public InterpolatedValue currentBlockLight;
    public InterpolatedValue currentLight;
    public InterpolatedValue undergroundness;
    public InterpolatedValue darkness;
    public InterpolatedValue[] caveFogColors;
    public Vec3 unlitFogColor = Vec3.f_82478_;
    private Map<String, BiomeFogDensity> configMap;
    public boolean useCaveFog = true;
    public double caveFogMultiplier = 1.0;

    public static FogManager getDensityManager() {
        return Objects.requireNonNull(densityManager, "Attempted to call getDensityManager before it finished loading!");
    }

    public static Optional<FogManager> getDensityManagerOptional() {
        return Optional.ofNullable(densityManager);
    }

    public FogManager() {
        this.mc = Minecraft.m_91087_();
        this.fogStart = new InterpolatedValue(0.0f);
        this.fogEnd = new InterpolatedValue(1.0f);
        this.currentSkyLight = new InterpolatedValue(16.0f);
        this.currentBlockLight = new InterpolatedValue(16.0f);
        this.currentLight = new InterpolatedValue(16.0f);
        this.undergroundness = new InterpolatedValue(0.0f, 0.02f);
        this.darkness = new InterpolatedValue(0.0f, 0.1f);
        this.caveFogColors = new InterpolatedValue[3];
        this.caveFogColors[0] = new InterpolatedValue(1.0f);
        this.caveFogColors[1] = new InterpolatedValue(1.0f);
        this.caveFogColors[2] = new InterpolatedValue(1.0f);
        this.configMap = new HashMap<String, BiomeFogDensity>();
        if (FogLooksGoodNowConfig.config.isLoaded()) {
            this.initializeConfig();
        }
    }

    public void initializeConfig() {
        FogLooksModernNow.LOGGER.info("Initialized Config Values");
        this.fogStart.setDefaultValue((Double)FogLooksGoodNowConfig.CLIENT_CONFIG.defaultFogStart.get());
        this.fogEnd.setDefaultValue((Double)FogLooksGoodNowConfig.CLIENT_CONFIG.defaultFogDensity.get());
        this.useCaveFog = (Boolean)FogLooksGoodNowConfig.CLIENT_CONFIG.useCaveFog.get();
        this.caveFogMultiplier = (Double)FogLooksGoodNowConfig.CLIENT_CONFIG.caveFogDensity.get();
        this.configMap = new HashMap<String, BiomeFogDensity>();
        Vec3 caveFogColor = Vec3.m_82501_((int)((Integer)FogLooksGoodNowConfig.CLIENT_CONFIG.caveFogColor.get()));
        this.caveFogColors[0].setDefaultValue(caveFogColor.f_82479_);
        this.caveFogColors[1].setDefaultValue(caveFogColor.f_82480_);
        this.caveFogColors[2].setDefaultValue(caveFogColor.f_82481_);
        List<Pair<String, BiomeFogDensity>> densityConfigs = FogLooksGoodNowConfig.getDensityConfigs();
        for (Pair<String, BiomeFogDensity> densityConfig : densityConfigs) {
            this.configMap.put((String)densityConfig.getLeft(), (BiomeFogDensity)densityConfig.getRight());
        }
    }

    public void tick() {
        boolean isAboveGround;
        float[] darknessAffectedFog;
        BlockPos pos = this.mc.f_91063_.m_109153_().m_90588_();
        Biome biome = (Biome)this.mc.f_91073_.m_204166_(pos).m_203334_();
        ResourceLocation key = this.mc.f_91073_.m_9598_().m_175515_(Registries.f_256952_).m_7981_((Object)biome);
        if (key == null) {
            return;
        }
        BiomeFogDensity currentDensity = this.configMap.get(key.toString());
        boolean isFogDense = this.mc.f_91073_.m_104583_().m_5781_(pos.m_123341_(), pos.m_123343_()) || this.mc.f_91065_.m_93090_().m_93715_();
        float density = isFogDense ? 0.9f : 1.0f;
        ClientLevel pLevel = Minecraft.m_91087_().f_91073_;
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        BiomeManager biomemanager = pLevel.m_7062_();
        Vec3 playerPos = camera.m_90583_().m_82492_(2.0, 2.0, 2.0).m_82490_(0.25);
        this.unlitFogColor = CubicSampler.m_130038_((Vec3)playerPos, (p_109033_, p_109034_, p_109035_) -> pLevel.m_104583_().m_5927_(Vec3.m_82501_((int)((Biome)biomemanager.m_204210_(p_109033_, p_109034_, p_109035_).m_203334_()).m_47539_()), 1.0f));
        if (currentDensity != null) {
            darknessAffectedFog = this.getDarknessEffectedFog(currentDensity.fogStart(), currentDensity.fogDensity() * density);
            Vec3 caveFogColor = Vec3.m_82501_((int)currentDensity.caveFogColor);
            this.caveFogColors[0].interpolate(caveFogColor.f_82479_);
            this.caveFogColors[1].interpolate(caveFogColor.f_82480_);
            this.caveFogColors[2].interpolate(caveFogColor.f_82481_);
        } else {
            darknessAffectedFog = this.getDarknessEffectedFog(this.fogStart.defaultValue, this.fogEnd.defaultValue * density);
            this.caveFogColors[0].interpolate();
            this.caveFogColors[1].interpolate();
            this.caveFogColors[2].interpolate();
        }
        this.darkness.interpolate(darknessAffectedFog[2]);
        this.fogStart.interpolate(darknessAffectedFog[0]);
        this.fogEnd.interpolate(darknessAffectedFog[1]);
        this.currentSkyLight.interpolate(Math.max(this.mc.f_91073_.m_45517_(LightLayer.SKY, pos), this.mc.f_91073_.m_45517_(LightLayer.SKY, pos.m_7494_())));
        this.currentBlockLight.interpolate(this.mc.f_91073_.m_45517_(LightLayer.BLOCK, pos));
        this.currentLight.interpolate(this.mc.f_91073_.m_45524_(pos, 0));
        boolean bl = isAboveGround = pos.m_123342_() > this.mc.f_91073_.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.m_123341_(), pos.m_123343_());
        if (isAboveGround) {
            this.undergroundness.interpolate(0.0f, 0.05f);
        } else {
            this.undergroundness.interpolate(1.0f);
        }
    }

    public float getUndergroundFactor(float partialTick) {
        float y = (float)this.mc.f_91075_.m_20186_();
        float yFactor = Mth.m_14036_((float)MathUtils.mapRange((float)this.mc.f_91073_.m_5736_() - 32.0f, (float)this.mc.f_91073_.m_5736_() + 32.0f, 1.0f, 0.0f, y), (float)0.0f, (float)1.0f);
        return Mth.m_14179_((float)yFactor, (float)(1.0f - this.undergroundness.get(partialTick)), (float)(this.currentSkyLight.get(partialTick) / 16.0f));
    }

    public static Vec3 getCaveFogColor() {
        Minecraft mc = Minecraft.m_91087_();
        InterpolatedValue[] cfc = FogManager.densityManager.caveFogColors;
        return new Vec3((double)cfc[0].get(mc.getPartialTick()), (double)cfc[1].get(mc.getPartialTick()), (double)cfc[2].get(mc.getPartialTick()));
    }

    public static boolean shouldRenderCaveFog() {
        return Minecraft.m_91087_().f_91073_.m_104583_().m_108883_() == DimensionSpecialEffects.SkyType.NORMAL && FogManager.densityManager.useCaveFog && Minecraft.m_91087_().f_91063_.m_109153_().m_167685_() == FogType.NONE;
    }

    public float[] getDarknessEffectedFog(float fs, float fd) {
        Minecraft mc = Minecraft.m_91087_();
        float renderDistance = mc.f_91063_.m_109152_() * 16.0f;
        Entity entity = mc.f_91075_;
        float fogStart = fs;
        float fogEnd = fd;
        float darknessValue = 0.0f;
        this.fogEnd.interpolationSpeed = 0.05f;
        this.fogStart.interpolationSpeed = 0.05f;
        if (entity instanceof LivingEntity) {
            MobEffectInstance effect;
            LivingEntity e = (LivingEntity)entity;
            if (e.m_21023_(MobEffects.f_19610_)) {
                fogStart = 64.0f / renderDistance;
                fogEnd = 128.0f / renderDistance;
                darknessValue = 1.0f;
            } else if (e.m_21023_(MobEffects.f_216964_) && !(effect = e.m_21124_(MobEffects.f_216964_)).m_216895_().isEmpty()) {
                float factor = ((Double)this.mc.f_91066_.m_231926_().m_231551_()).floatValue();
                float intensity = ((MobEffectInstance.FactorData)effect.m_216895_().get()).m_238413_(e, mc.getPartialTick()) * factor;
                float darkness = 1.0f - this.calculateDarknessScale(e, ((MobEffectInstance.FactorData)effect.m_216895_().get()).m_238413_(e, mc.getPartialTick()), mc.getPartialTick());
                FogLooksModernNow.LOGGER.info("" + intensity);
                fogStart = 128.0f / renderDistance * darkness;
                fogEnd = 240.0f / renderDistance;
                darknessValue = ((MobEffectInstance.FactorData)effect.m_216895_().get()).m_238413_(e, mc.getPartialTick());
            }
        }
        return new float[]{fogStart, fogEnd, darknessValue};
    }

    private float calculateDarknessScale(LivingEntity pEntity, float darknessFactor, float partialTicks) {
        float factor = ((Double)this.mc.f_91066_.m_231926_().m_231551_()).floatValue();
        float f = 0.45f * darknessFactor;
        return Math.max(0.0f, Mth.m_14089_((float)(((float)pEntity.f_19797_ - partialTicks) * (float)Math.PI * 0.025f)) * f) * factor;
    }

    public void close() {
    }

    public class InterpolatedValue {
        public float defaultValue;
        private float interpolationSpeed;
        private float previousValue;
        private float currentValue;

        public InterpolatedValue(float defaultValue, float interpolationSpeed) {
            this.defaultValue = defaultValue;
            this.currentValue = defaultValue;
            this.interpolationSpeed = interpolationSpeed;
        }

        public InterpolatedValue(float defaultValue) {
            this(defaultValue, 0.05f);
        }

        public void set(float value) {
            this.previousValue = this.currentValue;
            this.currentValue = value;
        }

        public void set(double value) {
            this.previousValue = this.currentValue;
            this.currentValue = (float)value;
        }

        public void setDefaultValue(float value) {
            this.defaultValue = value;
        }

        public void setDefaultValue(double value) {
            this.defaultValue = (float)value;
        }

        public void interpolate(float value, float interpolationSpeed) {
            this.set(Float.isNaN(value) ? Mth.m_14179_((float)interpolationSpeed, (float)this.currentValue, (float)this.defaultValue) : Mth.m_14179_((float)interpolationSpeed, (float)this.currentValue, (float)value));
        }

        public void interpolate(double value, float interpolationSpeed) {
            this.set(Double.isNaN(value) ? (double)Mth.m_14179_((float)interpolationSpeed, (float)this.currentValue, (float)this.defaultValue) : Mth.m_14139_((double)interpolationSpeed, (double)this.currentValue, (double)value));
        }

        public void interpolate(float value) {
            this.interpolate(value, this.interpolationSpeed);
        }

        public void interpolate(double value) {
            this.interpolate(value, this.interpolationSpeed);
        }

        public void interpolate() {
            this.set(Mth.m_14179_((float)this.interpolationSpeed, (float)this.currentValue, (float)this.defaultValue));
        }

        public float get(float partialTick) {
            return Mth.m_14179_((float)partialTick, (float)this.previousValue, (float)this.currentValue);
        }
    }

    public record BiomeFogDensity(float fogStart, float fogDensity, int caveFogColor) {
    }
}

