/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.api.model;

import com.github.exopandora.shouldersurfing.api.client.ShoulderSurfing;
import com.github.exopandora.shouldersurfing.api.model.Couple;
import com.github.exopandora.shouldersurfing.api.model.PickContext;
import net.minecraft.client.Camera;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.Vec3;

public final class DynamicPickContext
extends PickContext {
    public DynamicPickContext(Camera camera, ClipContext.Fluid fluidContext, Entity entity) {
        super(camera, fluidContext, entity);
    }

    @Override
    public ClipContext.Block blockContext() {
        return ShoulderSurfing.getInstance().isAiming() ? ClipContext.Block.COLLIDER : ClipContext.Block.OUTLINE;
    }

    @Override
    public Couple<Vec3> entityTrace(double interactionRange, float partialTick) {
        return this.calcRay(this.camera(), interactionRange, partialTick);
    }

    @Override
    public Couple<Vec3> blockTrace(double interactionRange, float partialTick) {
        return this.calcRay(this.camera(), interactionRange, partialTick);
    }

    private Couple<Vec3> calcRay(Camera camera, double interactionRange, float partialTick) {
        Vec3 startPos = this.entity().m_20299_(partialTick);
        Vec3 endPos = startPos.m_82549_(new Vec3(camera.m_253058_()).m_82490_(interactionRange));
        return new Couple<Vec3>(startPos, endPos);
    }
}

