/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.client;

import com.github.exopandora.shouldersurfing.api.client.ICrosshairRenderer;
import com.github.exopandora.shouldersurfing.api.model.PickContext;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingImpl;
import com.github.exopandora.shouldersurfing.config.Config;
import com.github.exopandora.shouldersurfing.math.Vec2f;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class CrosshairRenderer
implements ICrosshairRenderer {
    private final ShoulderSurfingImpl instance;
    private Vec2f offset;
    private Vec2f projected;

    public CrosshairRenderer(ShoulderSurfingImpl instance) {
        this.instance = instance;
        this.init();
    }

    private void init() {
        this.offset = Vec2f.ZERO;
        this.projected = null;
    }

    public void offsetCrosshair(PoseStack poseStack, Window window) {
        if (this.projected != null) {
            Vec2f screenSize = new Vec2f(window.m_85443_(), window.m_85444_());
            Vec2f center = screenSize.divide(2.0f);
            this.offset = this.projected.subtract(center).divide((float)window.m_85449_());
        }
        if (this.isCrosshairDynamic(Minecraft.m_91087_().m_91288_())) {
            poseStack.m_85836_();
            poseStack.m_85850_().m_252922_().translate(this.offset.x(), -this.offset.y(), 0.0f);
        }
    }

    public void clearCrosshairOffset(PoseStack poseStack) {
        if (this.isCrosshairDynamic(Minecraft.m_91087_().m_91288_())) {
            poseStack.m_85849_();
        }
    }

    public void updateDynamicRaytrace(Camera camera, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, float partialTick) {
        if (this.instance.isShoulderSurfing() && Minecraft.m_91087_().f_91074_ != null) {
            double interactionRangeOverride = Config.CLIENT.useCustomRaytraceDistance() ? Config.CLIENT.getCustomRaytraceDistance() : 0.0;
            MultiPlayerGameMode gameMode = Minecraft.m_91087_().f_91072_;
            PickContext pickContext = new PickContext.Builder(camera).dynamicTrace().build();
            HitResult hitResult = this.instance.getObjectPicker().pick(pickContext, interactionRangeOverride, partialTick, gameMode);
            Vec3 position = hitResult.m_82450_().m_82546_(camera.m_90583_());
            this.projected = CrosshairRenderer.project2D(position, modelViewMatrix, projectionMatrix);
        }
    }

    @Override
    public boolean isCrosshairDynamic(Entity entity) {
        return this.instance.isShoulderSurfing() && Config.CLIENT.getCrosshairType().isDynamic(entity, this.instance.isAiming());
    }

    public void resetState() {
        this.init();
    }

    @Nullable
    private static Vec2f project2D(Vec3 position, Matrix4f modelView, Matrix4f projection) {
        Window window = Minecraft.m_91087_().m_91268_();
        int screenWidth = window.m_85443_();
        int screenHeight = window.m_85444_();
        if (screenWidth == 0 || screenHeight == 0) {
            return null;
        }
        Vector4f vec = new Vector4f((float)position.m_7096_(), (float)position.m_7098_(), (float)position.m_7094_(), 1.0f);
        vec.mul((Matrix4fc)modelView);
        vec.mul((Matrix4fc)projection);
        if (vec.w() == 0.0f) {
            return null;
        }
        float w = 1.0f / vec.w() * 0.5f;
        float x = (vec.x() * w + 0.5f) * (float)screenWidth;
        float y = (vec.y() * w + 0.5f) * (float)screenHeight;
        float z = vec.z() * w + 0.5f;
        vec.set(x, y, z, w);
        if (Float.isInfinite(x) || Float.isInfinite(y) || Float.isNaN(x) || Float.isNaN(y)) {
            return null;
        }
        return new Vec2f(x, y);
    }
}

