/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.client;

import com.github.exopandora.shouldersurfing.api.model.Perspective;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingCamera;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingImpl;
import com.github.exopandora.shouldersurfing.config.Config;
import com.github.exopandora.shouldersurfing.math.Vec2f;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.CameraType;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class InputHandler {
    private static final String KEY_CATEGORY = "Shoulder Surfing";
    public static final KeyMapping CAMERA_LEFT = new KeyMapping("Camera left", 263, "Shoulder Surfing");
    public static final KeyMapping CAMERA_RIGHT = new KeyMapping("Camera right", 262, "Shoulder Surfing");
    public static final KeyMapping CAMERA_IN = new KeyMapping("Camera closer", 265, "Shoulder Surfing");
    public static final KeyMapping CAMERA_OUT = new KeyMapping("Camera farther", 264, "Shoulder Surfing");
    public static final KeyMapping CAMERA_UP = new KeyMapping("Camera up", 266, "Shoulder Surfing");
    public static final KeyMapping CAMERA_DOWN = new KeyMapping("Camera down", 267, "Shoulder Surfing");
    public static final KeyMapping SWAP_SHOULDER = new KeyMapping("Swap shoulder", 79, "Shoulder Surfing");
    public static final KeyMapping TOGGLE_SHOULDER_SURFING = new KeyMapping("Toggle perspective", InputConstants.f_84822_.m_84873_(), "Shoulder Surfing");
    public static final KeyMapping FREE_LOOK = new KeyMapping("Free look", 342, "Shoulder Surfing");
    private final ShoulderSurfingImpl instance;

    public InputHandler(ShoulderSurfingImpl instance) {
        this.instance = instance;
    }

    public void tick() {
        Options options = Minecraft.m_91087_().f_91066_;
        while (TOGGLE_SHOULDER_SURFING.m_90859_()) {
            if (this.instance.isShoulderSurfing()) {
                this.instance.changePerspective(Perspective.FIRST_PERSON);
                continue;
            }
            if (options.m_92176_() != CameraType.FIRST_PERSON) continue;
            this.instance.changePerspective(Perspective.SHOULDER_SURFING);
        }
        while (CAMERA_LEFT.m_90859_()) {
            if (!this.instance.isShoulderSurfing()) continue;
            Config.CLIENT.adjustCameraLeft();
        }
        while (CAMERA_RIGHT.m_90859_()) {
            if (!this.instance.isShoulderSurfing()) continue;
            Config.CLIENT.adjustCameraRight();
        }
        while (CAMERA_OUT.m_90859_()) {
            if (!this.instance.isShoulderSurfing()) continue;
            Config.CLIENT.adjustCameraOut();
        }
        while (CAMERA_IN.m_90859_()) {
            if (!this.instance.isShoulderSurfing()) continue;
            Config.CLIENT.adjustCameraIn();
        }
        while (CAMERA_UP.m_90859_()) {
            if (!this.instance.isShoulderSurfing()) continue;
            Config.CLIENT.adjustCameraUp();
        }
        while (CAMERA_DOWN.m_90859_()) {
            if (!this.instance.isShoulderSurfing()) continue;
            Config.CLIENT.adjustCameraDown();
        }
        while (SWAP_SHOULDER.m_90859_()) {
            if (!this.instance.isShoulderSurfing()) continue;
            Config.CLIENT.swapShoulder();
        }
        while (options.f_92103_.m_90859_()) {
            this.instance.togglePerspective();
        }
        while (FREE_LOOK.m_90859_()) {
        }
    }

    public void updateMovementInput(Input input) {
        Minecraft minecraft = Minecraft.m_91087_();
        Entity cameraEntity = minecraft.m_91288_();
        Vec2f moveVector = new Vec2f(input.f_108566_, input.f_108567_);
        if (this.instance.isShoulderSurfing() && this.instance.isFreeLooking()) {
            moveVector.rotateDegrees(Mth.m_14118_((float)cameraEntity.m_146908_(), (float)this.instance.getCamera().getFreeLookYRot()));
            input.f_108566_ = moveVector.x();
            input.f_108567_ = moveVector.y();
        } else if (this.instance.isShoulderSurfing() && minecraft.f_91074_ != null && cameraEntity == minecraft.f_91074_) {
            if (moveVector.lengthSquared() > 0.0) {
                ShoulderSurfingCamera camera = this.instance.getCamera();
                LocalPlayer player = minecraft.f_91074_;
                float yRot = player.m_146908_();
                if (this.instance.isEntityRotationDecoupled((LivingEntity)player, minecraft)) {
                    float cameraXRot = camera.getXRot();
                    float cameraYRot = camera.getYRot();
                    Vec2f rotated = moveVector.rotateDegrees(cameraYRot);
                    float xRot = cameraXRot * 0.5f;
                    float xRotO = player.m_146909_();
                    float yRotO = yRot;
                    yRot = (float)Mth.m_14175_((double)(Math.atan2(-rotated.x(), rotated.y()) * 57.2957763671875));
                    xRot = xRotO + Mth.m_14118_((float)xRotO, (float)xRot) * 0.25f;
                    yRot = yRotO + Mth.m_14118_((float)yRotO, (float)yRot) * 0.25f;
                    player.m_146926_(xRot);
                    player.m_146922_(yRot);
                }
                moveVector = moveVector.rotateDegrees(Mth.m_14118_((float)yRot, (float)camera.getYRot()));
            }
            input.f_108566_ = moveVector.x();
            input.f_108567_ = moveVector.y();
        }
    }
}

