/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.client;

import com.github.exopandora.shouldersurfing.api.client.IShoulderSurfing;
import com.github.exopandora.shouldersurfing.api.client.ShoulderSurfing;
import com.github.exopandora.shouldersurfing.api.model.Perspective;
import com.github.exopandora.shouldersurfing.api.model.PickContext;
import com.github.exopandora.shouldersurfing.client.CameraEntityRenderer;
import com.github.exopandora.shouldersurfing.client.CrosshairRenderer;
import com.github.exopandora.shouldersurfing.client.EntityHelper;
import com.github.exopandora.shouldersurfing.client.InputHandler;
import com.github.exopandora.shouldersurfing.client.ObjectPicker;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingCamera;
import com.github.exopandora.shouldersurfing.config.Config;
import com.github.exopandora.shouldersurfing.mixinducks.OptionsDuck;
import com.github.exopandora.shouldersurfing.plugin.ShoulderSurfingRegistrar;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.HitResult;

public class ShoulderSurfingImpl
implements IShoulderSurfing {
    private final ShoulderSurfingCamera camera = new ShoulderSurfingCamera(this);
    private final CameraEntityRenderer playerRenderer = new CameraEntityRenderer(this);
    private final CrosshairRenderer crosshairRenderer = new CrosshairRenderer(this);
    private final ObjectPicker objectPicker = new ObjectPicker();
    private final InputHandler inputHandler = new InputHandler(this);
    private boolean isShoulderSurfing;
    private boolean isTemporaryFirstPerson;
    private boolean isAiming;
    private boolean isFreeLooking;
    private int turningLockTime;
    private boolean updatePlayerRotations;
    private float playerXRotO;
    private float playerYRotO;

    public void init() {
        if (Config.CLIENT.doRememberLastPerspective()) {
            this.changePerspective(Config.CLIENT.getDefaultPerspective());
        }
    }

    public void tick() {
        boolean isFirstPerson;
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91080_ == null) {
            this.inputHandler.tick();
        }
        boolean bl = isFirstPerson = Perspective.FIRST_PERSON == Perspective.current();
        if (!isFirstPerson) {
            this.isTemporaryFirstPerson = false;
        }
        this.isAiming = ShoulderSurfingImpl.isHoldingAdaptiveItem(minecraft, minecraft.m_91288_());
        this.updatePlayerRotations = false;
        LocalPlayer player = minecraft.f_91074_;
        if (this.isShoulderSurfing && Config.CLIENT.getCrosshairType().doSwitchPerspective(this.isAiming)) {
            this.lookAtTarget(player, minecraft);
            this.changePerspective(Perspective.FIRST_PERSON);
            this.isTemporaryFirstPerson = true;
        } else if (this.isTemporaryFirstPerson && isFirstPerson && !Config.CLIENT.getCrosshairType().doSwitchPerspective(this.isAiming)) {
            this.changePerspective(Perspective.SHOULDER_SURFING);
        }
        if (this.isShoulderSurfing && player != null) {
            this.isFreeLooking = InputHandler.FREE_LOOK.m_90857_() && !this.isAiming;
            this.camera.tick();
            if (!this.isFreeLooking && minecraft.m_91288_() == player) {
                boolean shouldAimAtTarget = this.shouldEntityAimAtTargetInternal((LivingEntity)player, minecraft);
                if (shouldAimAtTarget || this.turningLockTime > 0) {
                    this.turningLockTime = shouldAimAtTarget ? Config.CLIENT.getTurningLockTime() : this.turningLockTime - 1;
                    this.lookAtTarget(player, minecraft);
                } else if (this.shouldEntityFollowCamera((LivingEntity)player)) {
                    player.m_146926_(this.camera.getXRot());
                    player.m_146922_(this.camera.getYRot());
                }
            }
        }
    }

    private void lookAtTarget(LocalPlayer player, Minecraft minecraft) {
        Camera camera = minecraft.f_91063_.m_109153_();
        double interactionRange = Config.CLIENT.getCrosshairType().isAimingDecoupled() ? 400.0 : Config.CLIENT.getCustomRaytraceDistance();
        PickContext pickContext = new PickContext.Builder(camera).build();
        HitResult hitResult = this.objectPicker.pick(pickContext, interactionRange, 1.0f, minecraft.f_91072_);
        this.playerXRotO = player.m_146909_();
        this.playerYRotO = player.m_146908_();
        this.updatePlayerRotations = true;
        EntityHelper.lookAtTarget(player, hitResult.m_82450_());
    }

    public void updatePlayerRotations() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (this.updatePlayerRotations && player != null) {
            player.f_19860_ = this.playerXRotO;
            player.f_19859_ = this.playerYRotO;
        }
    }

    private boolean shouldEntityAimAtTargetInternal(LivingEntity cameraEntity, Minecraft minecraft) {
        return this.isAiming && Config.CLIENT.getCrosshairType().isAimingDecoupled() || !this.isAiming && Config.CLIENT.isCameraDecoupled() && (ShoulderSurfingImpl.isUsingItem(cameraEntity, minecraft) || !cameraEntity.m_21255_() && (ShoulderSurfingImpl.isInteracting(cameraEntity, minecraft) || ShoulderSurfingImpl.isAttacking(minecraft) || ShoulderSurfingImpl.isPicking(minecraft)));
    }

    public boolean shouldEntityAimAtTarget(LivingEntity cameraEntity, Minecraft minecraft) {
        return this.turningLockTime > 0 || this.shouldEntityAimAtTargetInternal(cameraEntity, minecraft);
    }

    public boolean isEntityRotationDecoupled(LivingEntity cameraEntity, Minecraft minecraft) {
        return !this.shouldEntityAimAtTarget(cameraEntity, minecraft) && !this.shouldEntityFollowCamera(cameraEntity);
    }

    private static boolean isUsingItem(LivingEntity cameraEntity, Minecraft minecraft) {
        return cameraEntity.m_6117_() && Config.CLIENT.getTurningModeWhenUsingItem().shouldTurn(minecraft.f_91077_) && !cameraEntity.m_21211_().m_41614_();
    }

    private static boolean isInteracting(LivingEntity cameraEntity, Minecraft minecraft) {
        return minecraft.f_91066_.f_92095_.m_90857_() && !cameraEntity.m_6117_() && Config.CLIENT.getTurningModeWhenInteracting().shouldTurn(minecraft.f_91077_);
    }

    private static boolean isAttacking(Minecraft minecraft) {
        return minecraft.f_91066_.f_92096_.m_90857_() && Config.CLIENT.getTurningModeWhenAttacking().shouldTurn(minecraft.f_91077_);
    }

    private static boolean isPicking(Minecraft minecraft) {
        return minecraft.f_91066_.f_92097_.m_90857_() && Config.CLIENT.getTurningModeWhenPicking().shouldTurn(minecraft.f_91077_);
    }

    public boolean shouldEntityFollowCamera(LivingEntity cameraEntity) {
        return this.isAiming && !Config.CLIENT.getCrosshairType().isAimingDecoupled() || cameraEntity.m_21255_() || !Config.CLIENT.isCameraDecoupled();
    }

    private static boolean isHoldingAdaptiveItem(Minecraft minecraft, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return ShoulderSurfingRegistrar.getInstance().getAdaptiveItemCallbacks().stream().anyMatch(callback -> callback.isHoldingAdaptiveItem(minecraft, living));
        }
        return false;
    }

    @Override
    public void changePerspective(Perspective perspective) {
        ((OptionsDuck)Minecraft.m_91087_().f_91066_).shouldersurfing$setCameraTypeDirect(perspective.getCameraType());
        this.setShoulderSurfing(Perspective.SHOULDER_SURFING.equals((Object)perspective));
    }

    @Override
    public void togglePerspective() {
        Minecraft minecraft = Minecraft.m_91087_();
        Perspective perspective = Perspective.current();
        Perspective next = perspective.next(Config.CLIENT.replaceDefaultPerspective(), Config.CLIENT.skipThirdPersonFront());
        boolean isFirstPerson = next.getCameraType().m_90612_();
        this.changePerspective(next);
        minecraft.f_91060_.m_109826_();
        if (perspective.getCameraType().m_90612_() != isFirstPerson) {
            minecraft.f_91063_.m_109106_(isFirstPerson ? minecraft.m_91288_() : null);
        }
        if (Config.CLIENT.doRememberLastPerspective()) {
            Config.CLIENT.setDefaultPerspective(next);
        }
    }

    @Override
    public void swapShoulder() {
        Config.CLIENT.swapShoulder();
    }

    @Override
    public boolean isShoulderSurfing() {
        return this.isShoulderSurfing;
    }

    public void setShoulderSurfing(boolean isShoulderSurfing) {
        if (!this.isShoulderSurfing && isShoulderSurfing) {
            this.resetState();
        }
        this.isShoulderSurfing = isShoulderSurfing;
    }

    @Override
    public boolean isAiming() {
        return this.isAiming;
    }

    @Override
    public boolean isFreeLooking() {
        return this.isFreeLooking && this.isShoulderSurfing;
    }

    @Override
    public ShoulderSurfingCamera getCamera() {
        return this.camera;
    }

    @Override
    public CameraEntityRenderer getCameraEntityRenderer() {
        return this.playerRenderer;
    }

    @Override
    public CrosshairRenderer getCrosshairRenderer() {
        return this.crosshairRenderer;
    }

    @Override
    public ObjectPicker getObjectPicker() {
        return this.objectPicker;
    }

    public InputHandler getInputHandler() {
        return this.inputHandler;
    }

    @Override
    public void resetState() {
        this.camera.resetState();
        this.crosshairRenderer.resetState();
        this.turningLockTime = 0;
    }

    public static ShoulderSurfingImpl getInstance() {
        return (ShoulderSurfingImpl)ShoulderSurfing.getInstance();
    }
}

