/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.forge.compat;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraftforge.fml.loading.FMLLoader;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class ShoulderOculusCompatMixinPlugin
implements IMixinConfigPlugin {
    private final Map<String, Supplier<Predicate<ArtifactVersion>>> rules = new HashMap<String, Supplier<Predicate<ArtifactVersion>>>();

    public void onLoad(String mixinPackage) {
        this.rules.put(mixinPackage + ".MixinSheets", () -> arg_0 -> ((VersionRange)ShoulderOculusCompatMixinPlugin.parseVersionRangeSilent("[1.7.0-snapshot,)")).containsVersion(arg_0));
        this.rules.put(mixinPackage + ".MixinSheetsLegacy", () -> arg_0 -> ((VersionRange)ShoulderOculusCompatMixinPlugin.parseVersionRangeSilent("[1.6.15,1.7.0)")).containsVersion(arg_0));
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (this.rules.containsKey(mixinClassName)) {
            Predicate<ArtifactVersion> oculusVersion = this.rules.get(mixinClassName).get();
            return FMLLoader.getLoadingModList().getMods().stream().anyMatch(info -> info.getModId().equals("oculus") && oculusVersion.test(info.getVersion()));
        }
        return false;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    private static VersionRange parseVersionRangeSilent(String predicate) {
        try {
            return VersionRange.createFromVersionSpec((String)predicate);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

