/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spellchecker.util;

import com.mrbysco.spellchecker.mixin.ChatScreenAccessor;
import com.mrbysco.spellchecker.mixin.EditBoxAccessor;
import com.mrbysco.spellchecker.platform.Services;
import com.mrbysco.spellchecker.util.LocationData;
import com.mrbysco.spellchecker.util.SuggestionInfo;
import com.mrbysco.spellchecker.util.SuggestionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.network.chat.Component;

public class SuggestionRendering {
    public static void renderSuggestions(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, ChatScreen chat) {
        Font font = Minecraft.m_91087_().f_91062_;
        if (!SuggestionUtil.keptSuggestions.isEmpty()) {
            for (SuggestionInfo info : SuggestionUtil.keptSuggestions) {
                int posX = info.posX();
                int posY = info.posY();
                String word = info.word();
                List<String> suggestions = info.suggestions();
                SuggestionRendering.drawInfoTooltip(guiGraphics, font, suggestions, posX, posY);
            }
        }
        if (!(SuggestionUtil.wronglySpelledWords == null || SuggestionUtil.wronglySpelledWords.isEmpty() || SuggestionUtil.wordSuggestions == null || SuggestionUtil.wordSuggestions.isEmpty() || SuggestionUtil.wordPosition == null || SuggestionUtil.wordPosition.isEmpty())) {
            boolean showSuggestionsLive = Services.PLATFORM.showSuggestionsLive();
            for (int i = 0; i < SuggestionUtil.wronglySpelledWords.size(); ++i) {
                boolean isLastWord = i == SuggestionUtil.wronglySpelledWords.size() - 1;
                String word = SuggestionUtil.wronglySpelledWords.get(i);
                ArrayList<String> suggestions = SuggestionUtil.wordSuggestions.get(word);
                EditBox editBox = ((ChatScreenAccessor)chat).spellchecker_getEditbox();
                int lineScrollOffset = ((EditBoxAccessor)editBox).spellchecker_getDisplayPos();
                String chatText = editBox.m_94155_();
                if (chatText.length() <= lineScrollOffset) continue;
                String currentlyDisplayedText = chatText.substring(lineScrollOffset);
                for (LocationData data : SuggestionUtil.wordPosition) {
                    String firstWord;
                    String originalWord = data.word();
                    String wordUntilTypo = data.wordsUntil();
                    if (!originalWord.equals(word)) continue;
                    if (currentlyDisplayedText.contains(wordUntilTypo)) {
                        int width = font.m_92895_(wordUntilTypo);
                        StringBuilder wrongSquigly = new StringBuilder();
                        wrongSquigly.append("~".repeat(word.length()));
                        if (font.m_92895_(word) <= font.m_92895_(wrongSquigly.toString())) {
                            int left = font.m_92895_(wrongSquigly.toString()) - font.m_92895_(word);
                            int removeCount = (int)Math.floor((double)left / (double)font.m_92895_("~"));
                            wrongSquigly = new StringBuilder(wrongSquigly.substring(removeCount));
                        }
                        if (font.m_92895_(word) <= font.m_92895_(wrongSquigly.toString())) {
                            wrongSquigly = new StringBuilder(wrongSquigly.substring(1));
                        }
                        if (font.m_92895_(wrongSquigly.toString()) == 0 && font.m_92895_(word) > 0) {
                            wrongSquigly = new StringBuilder("~");
                        }
                        guiGraphics.m_280056_(font, wrongSquigly.toString(), width + 4, chat.f_96544_ - 4, 0xFF5555, false);
                        int n = chat.f_96544_ - 12;
                        int n2 = font.m_92895_(word);
                        Objects.requireNonNull(font);
                        boolean hoveredFlag = SuggestionUtil.hoverBoolean(mouseX, mouseY, 2 + width, n, n2, 9);
                        if (!hoveredFlag && (!showSuggestionsLive || !isLastWord)) continue;
                        SuggestionRendering.drawInfoTooltip(guiGraphics, font, suggestions, width - 6, chat.f_96544_ - (6 + suggestions.size() * 12));
                        continue;
                    }
                    String[] Words = currentlyDisplayedText.split(" ");
                    if (Words.length <= 0 || (firstWord = Words[0]).isEmpty() || !word.contains(firstWord)) continue;
                    int width = font.m_92895_(firstWord);
                    StringBuilder wrongSquigly = new StringBuilder();
                    wrongSquigly.append("~".repeat(firstWord.length()));
                    if (font.m_92895_(word) <= font.m_92895_(wrongSquigly.toString())) {
                        int left = font.m_92895_(wrongSquigly.toString()) - font.m_92895_(word);
                        int removeCount = (int)Math.floor((double)left / (double)font.m_92895_("~"));
                        wrongSquigly = new StringBuilder(wrongSquigly.substring(removeCount));
                    }
                    if (font.m_92895_(word) <= font.m_92895_(wrongSquigly.toString())) {
                        wrongSquigly = new StringBuilder(wrongSquigly.substring(1));
                    }
                    if (font.m_92895_(wrongSquigly.toString()) == 0 && font.m_92895_(word) > 0) {
                        wrongSquigly = new StringBuilder("~");
                    }
                    guiGraphics.m_280056_(font, wrongSquigly.toString(), width + 2, chat.f_96544_ - 4, 0xFF5555, false);
                    int n = chat.f_96544_ - 12;
                    int n3 = font.m_92895_(word);
                    Objects.requireNonNull(font);
                    boolean hoveredFlag = SuggestionUtil.hoverBoolean(mouseX, mouseY, 2 + width, n, n3, 9);
                    if (!hoveredFlag) continue;
                    SuggestionRendering.drawInfoTooltip(guiGraphics, font, suggestions, width - 6, chat.f_96544_ - (6 + suggestions.size() * 12));
                }
            }
        }
    }

    public static void drawInfoTooltip(GuiGraphics guiGraphics, Font font, List<String> textLines, int x, int y) {
        guiGraphics.m_280245_(font, textLines.stream().map(text -> Component.m_237113_((String)text).m_7532_()).collect(Collectors.toList()), x, y);
    }
}

