/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.blockEntities.instances;

import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.base.SingleRotatingInstance;
import com.simibubi.create.content.kinetics.base.flwdata.RotatingData;
import com.simibubi.create.foundation.render.AllMaterialSpecs;
import fr.iglee42.createcasing.blockEntities.GlassShaftBlockEntity;
import fr.iglee42.createcasing.blockEntities.renderers.GlassShaftRenderer;
import fr.iglee42.createcasing.registries.ModPartialModels;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;

public class GlassShaftInstance
extends SingleRotatingInstance<GlassShaftBlockEntity> {
    protected RotatingData additionalShaft;

    public GlassShaftInstance(MaterialManager materialManager, GlassShaftBlockEntity blockEntity) {
        super(materialManager, (KineticBlockEntity)blockEntity);
    }

    public void init() {
        super.init();
        float speed = ((GlassShaftBlockEntity)this.blockEntity).getSpeed();
        Direction.Axis axis = KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)((KineticBlockEntity)this.blockEntity));
        BlockPos pos = ((GlassShaftBlockEntity)this.blockEntity).m_58899_();
        float offset = GlassShaftRenderer.getShaftAngleOffset(axis, pos);
        Direction facing = Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        Instancer half = this.materialManager.cutout(RenderType.m_110457_()).material(AllMaterialSpecs.ROTATING).getModel(ModPartialModels.GLASS_SHAFT, this.blockState, facing, () -> this.rotateToAxis(axis));
        this.additionalShaft = this.setup((RotatingData)half.createInstance(), speed);
        this.additionalShaft.setRotationOffset(offset);
    }

    protected Instancer<RotatingData> getModel() {
        return super.getModel();
    }

    private PoseStack rotateToAxis(Direction.Axis axis) {
        Direction facing = Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        PoseStack poseStack = new PoseStack();
        ((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((PoseStack)poseStack).centre()).rotateToFace(facing)).multiply(Axis.f_252495_.m_252977_(-90.0f))).unCentre();
        return poseStack;
    }

    public void update() {
        super.update();
        if (this.additionalShaft != null) {
            this.updateRotation(this.additionalShaft);
            this.additionalShaft.setRotationOffset(GlassShaftRenderer.getShaftAngleOffset(this.axis, this.pos));
        }
    }

    public void updateLight() {
        super.updateLight();
        if (this.additionalShaft != null) {
            this.relight(this.pos, new FlatLit[]{this.additionalShaft});
        }
    }

    public void remove() {
        super.remove();
        if (this.additionalShaft != null) {
            this.additionalShaft.delete();
        }
    }
}

