/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.compat.kubejs.gearbox;

import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import dev.latvian.mods.kubejs.client.LangEventJS;
import dev.latvian.mods.kubejs.generator.AssetJsonGenerator;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.util.UtilsJS;
import fr.iglee42.createcasing.api.CreateCasingApi;
import fr.iglee42.createcasing.compat.kubejs.CreateCasingBuilderBaseJS;
import fr.iglee42.createcasing.compat.kubejs.KubeJSCompatPlugin;
import net.minecraft.resources.ResourceLocation;

public class GearboxBuilderJs
extends CreateCasingBuilderBaseJS {
    private boolean verticalItem = true;
    private CTSpriteShiftEntry connectedTexture;
    private String casingTexture = "kubejs:block/" + this.fullName;
    private String gearboxTexture;

    public GearboxBuilderJs(String name) {
        super(name, name + "_gearbox", "block");
        this.gearboxTexture = "kubejs:block/" + name + "_gearbox";
    }

    public GearboxBuilderJs casingTexture(String casingTexture) {
        this.casingTexture = casingTexture;
        return this;
    }

    public GearboxBuilderJs gearboxTexture(String gearboxTexture) {
        this.gearboxTexture = gearboxTexture;
        return this;
    }

    public GearboxBuilderJs noVerticalItem() {
        this.verticalItem = false;
        return this;
    }

    public GearboxBuilderJs connectedTexture(CTSpriteShiftEntry sprite) {
        this.connectedTexture = sprite;
        return this;
    }

    public GearboxBuilderJs displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public GearboxBuilderJs translationKey(String translationKey) {
        this.translationKey = translationKey;
        return this;
    }

    @Override
    public void generateAssetJsons(AssetJsonGenerator generator) {
        generator.blockState(new ResourceLocation("createcasing-kubejs", this.name + "_gearbox"), gen -> {
            gen.variant("axis=x", v -> v.model("createcasing-kubejs:block/" + this.name + "_gearbox").y(90).x(90).uvlock());
            gen.variant("axis=y", v -> v.model("createcasing-kubejs:block/" + this.name + "_gearbox").uvlock());
            gen.variant("axis=z", v -> v.model("createcasing-kubejs:block/" + this.name + "_gearbox").y(180).x(90).uvlock());
        });
        generator.blockModel(new ResourceLocation("createcasing-kubejs", this.name + "_gearbox"), mg -> {
            mg.parent("createcasing:block/api/base_gearbox");
            mg.texture("0", this.casingTexture);
            mg.texture("1", this.gearboxTexture);
        });
        generator.blockModel(new ResourceLocation("createcasing-kubejs", this.name + "_gearbox_item"), mg -> {
            mg.parent("createcasing:block/api/base_gearbox_item");
            mg.texture("0", this.casingTexture);
            mg.texture("1", this.gearboxTexture);
        });
        generator.itemModel(new ResourceLocation("createcasing-kubejs", this.name + "_gearbox"), mg -> mg.parent("createcasing-kubejs:block/" + this.name + "_gearbox_item"));
        if (this.verticalItem) {
            generator.blockModel(new ResourceLocation("createcasing-kubejs", this.name + "_gearbox_item_vertical"), mg -> {
                mg.parent("createcasing:block/api/base_gearbox_item_vertical");
                mg.texture("gearbox_top", this.casingTexture);
                mg.texture("gearbox", this.gearboxTexture);
            });
            generator.itemModel(new ResourceLocation("createcasing-kubejs", "vertical_" + this.name + "_gearbox"), mg -> mg.parent("createcasing-kubejs:block/" + this.name + "_gearbox_item_vertical"));
        }
    }

    @Override
    public void generateLang(LangEventJS lang) {
        super.generateLang(lang);
        lang.add("createcasing-kubejs", "item.createcasing-kubejs.vertical_" + this.fullName, UtilsJS.snakeCaseToTitleCase((String)("item.createcasing-kubejs.vertical_" + this.fullName)));
    }

    @Info(value="Create the gearbox in the code")
    public void build() {
        CreateCasingApi.createGearbox(KubeJSCompatPlugin.REGISTRATE, this.name, this.connectedTexture, this.verticalItem);
    }
}

