/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import de.teamlapen.vampirism.api.entity.convertible.IConvertingHandler;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.data.reloadlistener.ConvertiblesReloadListener;
import de.teamlapen.vampirism.entity.converted.ConvertedCreatureEntity;
import de.teamlapen.vampirism.entity.converted.VampirismEntityRegistry;
import de.teamlapen.vampirism.util.Helper;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultConvertingHandler<T extends PathfinderMob>
implements IConvertingHandler<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    @NotNull
    protected final IConvertingHandler.IDefaultHelper helper;
    @Nullable
    protected final ResourceLocation overlayTexture;

    public DefaultConvertingHandler(@Nullable IConvertingHandler.IDefaultHelper helper, @Nullable ResourceLocation overlayTexture) {
        this.helper = Objects.requireNonNullElse(helper, new VampirismEntityRegistry.DatapackHelper(ConvertiblesReloadListener.EntityEntry.ConvertingAttributeModifier.DEFAULT));
        this.overlayTexture = overlayTexture;
    }

    @Override
    @Nullable
    public IConvertedCreature<T> createFrom(@NotNull T entity) {
        return Helper.createEntity((EntityType)ModEntities.CONVERTED_CREATURE.get(), entity.m_20193_()).map(convertedCreature -> {
            this.copyImportantStuff((ConvertedCreatureEntity<T>)convertedCreature, entity);
            convertedCreature.m_20084_(Mth.m_216261_((RandomSource)convertedCreature.m_217043_()));
            convertedCreature.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 200, 2));
            convertedCreature.getSourceEntityDataParamOpt().ifPresent(s -> convertedCreature.getRepresentingEntity().m_20088_().m_135381_(s, (Object)ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()).toString()));
            return convertedCreature;
        }).orElse(null);
    }

    @NotNull
    public IConvertingHandler.IDefaultHelper getHelper() {
        return this.helper;
    }

    protected void copyImportantStuff(@NotNull ConvertedCreatureEntity<T> converted, @NotNull T entity) {
        converted.m_20359_((Entity)entity);
        converted.setEntityCreature(entity);
        this.updateEntityAttributes(converted);
        converted.m_21153_(converted.m_21233_() / 3.0f * 2.0f);
        converted.f_20883_ = ((PathfinderMob)entity).f_20883_;
        converted.f_20885_ = ((PathfinderMob)entity).f_20885_;
    }

    @Override
    public void updateEntityAttributes(PathfinderMob creature) {
        try {
            creature.m_21051_(Attributes.f_22281_).m_22100_(this.helper.getConvertedDMG((EntityType<? extends PathfinderMob>)creature.m_6095_()));
            creature.m_21051_(Attributes.f_22276_).m_22100_(this.helper.getConvertedMaxHealth((EntityType<? extends PathfinderMob>)creature.m_6095_()));
            creature.m_21051_(Attributes.f_22278_).m_22100_(this.helper.getConvertedKnockbackResistance((EntityType<? extends PathfinderMob>)creature.m_6095_()));
            creature.m_21051_(Attributes.f_22279_).m_22100_(this.helper.getConvertedSpeed((EntityType<? extends PathfinderMob>)creature.m_6095_()));
            this.helper.getAttributeModifier().forEach((attribute, valueProvider) -> {
                AttributeSupplier supplier = DefaultAttributes.m_22297_((EntityType)creature.m_6095_());
                double baseValue = (Double)valueProvider.getSecond();
                if (supplier.m_22258_(attribute)) {
                    baseValue = supplier.m_22253_(attribute);
                }
                creature.m_21051_(attribute).m_22100_(baseValue * (double)((FloatProvider)valueProvider.getFirst()).m_214084_(creature.m_217043_()));
            });
        }
        catch (NullPointerException ex) {
            LOGGER.error("Failed to update entity attributes for {} {}", (Object)creature, (Object)ex);
        }
    }
}

