/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory;

import com.mojang.datafixers.util.Pair;
import de.teamlapen.lib.lib.inventory.InventoryContainerMenu;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.minion.IMinionInventory;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.api.entity.player.ILordPlayer;
import de.teamlapen.vampirism.core.ModContainer;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionTasks;
import de.teamlapen.vampirism.network.ServerboundSelectMinionTaskPacket;
import de.teamlapen.vampirism.network.ServerboundToggleMinionTaskLock;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.IContainerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinionContainer
extends InventoryContainerMenu {
    private static final Logger LOGGER = LogManager.getLogger();
    @NotNull
    private final MinionEntity<?> minionEntity;
    @NotNull
    private final @NotNull IMinionTask<?, ?> @NotNull [] availableTasks;
    @Nullable
    private final IMinionTask<?, ?> previousTask;
    private final boolean previousTaskLocked;
    private final int extraSlots;
    @Nullable
    private IMinionTask<?, ?> taskToActivate;
    private boolean taskLocked;

    @Nullable
    public static MinionContainer create(int id, @NotNull Inventory playerInventory, @NotNull MinionEntity<?> minionEntity, @NotNull ILordPlayer lord) {
        Optional<IMinionInventory> minionInv = minionEntity.getInventory();
        return minionInv.map(inv -> new MinionContainer(id, playerInventory, lord, minionEntity, (Container)inv, inv.getAvailableSize(), MinionContainer.createSelectors(minionEntity, inv.getAvailableSize()))).orElse(null);
    }

    private static InventoryContainerMenu.SelectorInfo @NotNull [] createSelectors(@NotNull MinionEntity<?> minionEntity, int extraSlots) {
        InventoryContainerMenu.SelectorInfo[] slots = new InventoryContainerMenu.SelectorInfo[6 + extraSlots];
        slots[0] = new InventoryContainerMenu.SelectorInfo(minionEntity.getEquipmentPredicate(EquipmentSlot.MAINHAND).and(stack -> stack.canEquip(EquipmentSlot.MAINHAND, (Entity)minionEntity)), 7, 60, false, 1, null);
        slots[1] = new InventoryContainerMenu.SelectorInfo(minionEntity.getEquipmentPredicate(EquipmentSlot.OFFHAND).and(stack -> stack.canEquip(EquipmentSlot.OFFHAND, (Entity)minionEntity) || stack.m_41780_() == UseAnim.DRINK || stack.m_41780_() == UseAnim.EAT), 7, 78, false, 5, null);
        slots[2] = new InventoryContainerMenu.SelectorInfo(minionEntity.getEquipmentPredicate(EquipmentSlot.FEET).and(stack -> stack.canEquip(EquipmentSlot.FEET, (Entity)minionEntity)), 81, 22, false, 1, (Pair<ResourceLocation, ResourceLocation>)Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39696_));
        slots[3] = new InventoryContainerMenu.SelectorInfo(minionEntity.getEquipmentPredicate(EquipmentSlot.LEGS).and(stack -> stack.canEquip(EquipmentSlot.LEGS, (Entity)minionEntity)), 63, 22, false, 1, (Pair<ResourceLocation, ResourceLocation>)Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39695_));
        slots[4] = new InventoryContainerMenu.SelectorInfo(minionEntity.getEquipmentPredicate(EquipmentSlot.CHEST).and(stack -> stack.canEquip(EquipmentSlot.CHEST, (Entity)minionEntity)), 45, 22, false, 1, (Pair<ResourceLocation, ResourceLocation>)Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39694_));
        slots[5] = new InventoryContainerMenu.SelectorInfo(minionEntity.getEquipmentPredicate(EquipmentSlot.HEAD).and(stack -> stack.canEquip(EquipmentSlot.HEAD, (Entity)minionEntity)), 27, 22, false, 1, (Pair<ResourceLocation, ResourceLocation>)Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39693_));
        assert (extraSlots == 9 || extraSlots == 12 || extraSlots == 15) : "Minion inventory has unexpected size";
        for (int i = 0; i < extraSlots; ++i) {
            slots[6 + i] = new InventoryContainerMenu.SelectorInfo(itemStack -> true, 27 + 18 * (i / 3), 42 + 18 * (i % 3));
        }
        return slots;
    }

    public MinionContainer(int id, @NotNull Inventory playerInventory, @NotNull ILordPlayer lord, @NotNull MinionEntity<?> minionEntity, @NotNull Container inventory, int extraSlots, InventoryContainerMenu.SelectorInfo ... selectorInfos) {
        super((MenuType<? extends InventoryContainerMenu>)((MenuType)ModContainer.MINION.get()), id, playerInventory, ContainerLevelAccess.m_39289_((Level)minionEntity.m_9236_(), (BlockPos)minionEntity.m_20183_()), inventory, selectorInfos);
        this.minionEntity = minionEntity;
        this.extraSlots = extraSlots;
        this.availableTasks = (IMinionTask[])this.minionEntity.getAvailableTasks().stream().filter(task -> task.isAvailable(lord.getLordFaction(), lord)).toArray(IMinionTask[]::new);
        this.minionEntity.setInteractingPlayer(playerInventory.f_35978_);
        this.addPlayerSlots(playerInventory, 27, 103);
        this.previousTask = this.minionEntity.getCurrentTask().map(IMinionTask.IMinionTaskDesc::getTask).orElse(null);
        this.previousTaskLocked = this.taskLocked = this.minionEntity.isTaskLocked();
    }

    @Override
    public void m_6877_(@NotNull Player playerIn) {
        super.m_6877_(playerIn);
        if (this.minionEntity.m_9236_().m_5776_()) {
            this.sendChanges();
        }
        this.minionEntity.setInteractingPlayer(null);
    }

    @NotNull
    public IMinionTask<?, ?>[] getAvailableTasks() {
        return this.availableTasks;
    }

    public int getExtraSlots() {
        return this.extraSlots;
    }

    @NotNull
    public Optional<IMinionTask<?, ?>> getPreviousTask() {
        return Optional.ofNullable(this.previousTask);
    }

    @NotNull
    public IMinionTask<?, ?> getSelectedTask() {
        return this.taskToActivate != null ? this.taskToActivate : (this.previousTask != null ? this.previousTask : (IMinionTask<Object, Object>)MinionTasks.STAY.get());
    }

    public boolean isTaskLocked() {
        return this.taskLocked;
    }

    public void setTaskLocked(boolean taskLocked) {
        this.taskLocked = taskLocked;
    }

    @Override
    public boolean m_6875_(@NotNull Player playerIn) {
        return this.minionEntity.m_6084_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openConfigurationScreen() {
        this.minionEntity.openAppearanceScreen();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openStatsScreen() {
        this.minionEntity.openStatsScreen();
    }

    public void setTaskToActivate(int id) {
        assert (id >= 0 && id < this.availableTasks.length);
        if (id >= 0 && id < this.availableTasks.length) {
            this.taskToActivate = this.availableTasks[id];
        }
    }

    private void sendChanges() {
        if (this.taskToActivate != null && this.taskToActivate != this.previousTask) {
            this.minionEntity.getMinionId().ifPresent(id -> VampirismMod.dispatcher.sendToServer(new ServerboundSelectMinionTaskPacket((int)id, RegUtil.id(this.taskToActivate))));
        }
        if (this.previousTaskLocked != this.taskLocked) {
            this.minionEntity.getMinionId().ifPresent(id -> VampirismMod.dispatcher.sendToServer(new ServerboundToggleMinionTaskLock((int)id)));
        }
    }

    public static class Factory
    implements IContainerFactory<MinionContainer> {
        @Nullable
        public MinionContainer create(int windowId, @NotNull Inventory inv, @Nullable FriendlyByteBuf data) {
            Entity e;
            if (data == null) {
                return null;
            }
            int entityId = data.m_130242_();
            Entity entity = e = inv.f_35978_.m_9236_() == null ? null : inv.f_35978_.m_9236_().m_6815_(entityId);
            if (!(e instanceof MinionEntity)) {
                LOGGER.error("Cannot find related minion entity {}", (Object)entityId);
                return null;
            }
            ILordPlayer player = (ILordPlayer)FactionPlayerHandler.getOpt(inv.f_35978_).orElse(null);
            return MinionContainer.create(windowId, inv, (MinionEntity)e, player);
        }
    }
}

