/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.mixin;

import de.teamlapen.vampirism.effects.VampirismPotion;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PotionBrewing.class})
public class MixinPotionBrewing {
    @Inject(method={"hasContainerMix"}, at={@At(value="HEAD")}, cancellable=true)
    private static void handleItemConversionHunterPotion(@NotNull ItemStack input, ItemStack reagent, @NotNull CallbackInfoReturnable<Boolean> cir) {
        if (MixinPotionBrewing.shouldBlockBrewing_vampirism(input, reagent)) {
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }

    @Inject(method={"mix"}, at={@At(value="HEAD")}, cancellable=true)
    private static void handleDoReactionHunterPotion(ItemStack reagent, @NotNull ItemStack potionIn, @NotNull CallbackInfoReturnable<ItemStack> cir) {
        if (MixinPotionBrewing.shouldBlockBrewing_vampirism(potionIn, reagent)) {
            cir.setReturnValue((Object)potionIn);
            cir.cancel();
        }
    }

    private static boolean shouldBlockBrewing_vampirism(@NotNull ItemStack input, ItemStack reagent) {
        return VampirismPotion.isHunterPotion(input, true).map(Potion::m_43488_).flatMap(effects -> effects.stream().map(MobEffectInstance::m_19544_).filter(MobEffect::m_19486_).findAny()).isPresent();
    }
}

