/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import commoble.morered.client.ExtraRenderTypes;
import commoble.morered.wire_post.SlackInterpolator;
import commoble.morered.wire_post.WirePostBlockEntity;
import commoble.morered.wire_post.WireSpoolItem;
import java.util.Set;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class BundledCablePostRenderer
implements BlockEntityRenderer<WirePostBlockEntity> {
    public static final RenderType CABLE_RENDER_TYPE = ExtraRenderTypes.CABLE_RENDER_TYPE;
    public static final Material MATERIAL = new Material(TextureAtlas.f_118259_, new ResourceLocation("morered:block/bundled_network_cable"));
    public static final float[] REDS = new float[]{0.71f, 0.31f, 0.19f};
    public static final float[] GREENS = new float[]{0.19f, 0.48f, 0.29f};
    public static final float[] BLUES = new float[]{0.12f, 0.16f, 0.66f};

    public BundledCablePostRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(WirePostBlockEntity post, float partialTicks, PoseStack matrices, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        TextureAtlasSprite sprite = MATERIAL.m_119204_();
        float totalMinU = sprite.m_118409_();
        float totalMinV = sprite.m_118411_();
        float totalMaxU = sprite.m_118410_();
        float totalMaxV = sprite.m_118412_();
        float texWidth = totalMaxU - totalMinU;
        float texHeight = totalMaxV - totalMinV;
        float quadStartU = 0.6875f * texWidth + totalMinU;
        float quadEndU = 0.8125f * texWidth + totalMinU;
        float quadStartV = 0.375f * texHeight + totalMinV;
        float quadEndV = 0.75f * texHeight + totalMinV;
        BlockPos postPos = post.m_58899_();
        Vec3 postVector = WirePostBlockEntity.getConnectionVector(postPos);
        Set<BlockPos> connections = post.getRemoteConnections();
        Level world = post.m_58904_();
        VertexConsumer vertexBuilder = buffer.m_6299_(ExtraRenderTypes.CABLE_RENDER_TYPE);
        for (BlockPos connectionPos : connections) {
            int endY;
            int startY = postPos.m_123342_();
            if (startY >= (endY = connectionPos.m_123342_()) && (startY != endY || postPos.hashCode() >= connectionPos.hashCode())) continue;
            this.renderConnection(post, world, partialTicks, matrices, vertexBuilder, postVector, WirePostBlockEntity.getConnectionVector(connectionPos), postPos, connectionPos, quadStartU, quadEndU, quadStartV, quadEndV);
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        for (InteractionHand hand : InteractionHand.values()) {
            float eyeHeight;
            double handZ;
            double handY;
            double handX;
            CompoundTag nbt;
            ItemStack stack = player.m_21120_(hand);
            if (!(stack.m_41720_() instanceof WireSpoolItem) || (nbt = stack.m_41737_("last_post_pos")) == null) continue;
            EntityRenderDispatcher renderManager = Minecraft.m_91087_().m_91290_();
            BlockPos positionOfCurrentPostOfPlayer = NbtUtils.m_129239_((CompoundTag)nbt);
            if (!positionOfCurrentPostOfPlayer.equals((Object)postPos)) continue;
            Vec3 vectorOfCurrentPostOfPlayer = Vec3.m_82512_((Vec3i)positionOfCurrentPostOfPlayer);
            int handSideID = -(hand == InteractionHand.MAIN_HAND ? -1 : 1) * (player.m_5737_() == HumanoidArm.RIGHT ? 1 : -1);
            float swingProgress = player.m_21324_(partialTicks);
            float swingZ = Mth.m_14031_((float)(Mth.m_14116_((float)swingProgress) * (float)Math.PI));
            float playerAngle = Mth.m_14179_((float)partialTicks, (float)player.f_20884_, (float)player.f_20883_) * ((float)Math.PI / 180);
            double playerAngleX = Mth.m_14031_((float)playerAngle);
            double playerAngleZ = Mth.m_14089_((float)playerAngle);
            double handOffset = (double)handSideID * 0.35;
            if (renderManager.f_114360_ == null || renderManager.f_114360_.m_92176_() == CameraType.FIRST_PERSON) {
                double fov = ((Integer)renderManager.f_114360_.m_231837_().m_231551_()).intValue();
                Vec3 handVector = new Vec3(-0.14 + (double)handSideID * -0.36 * (fov /= 100.0), -0.12 + -0.045 * fov, 0.4);
                handVector = handVector.m_82496_(-Mth.m_14179_((float)partialTicks, (float)player.f_19860_, (float)player.m_146909_()) * ((float)Math.PI / 180));
                handVector = handVector.m_82524_(-Mth.m_14179_((float)partialTicks, (float)player.f_19859_, (float)player.m_146908_()) * ((float)Math.PI / 180));
                handVector = handVector.m_82524_(swingZ * 0.5f);
                handVector = handVector.m_82496_(-swingZ * 0.7f);
                handX = Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()) + handVector.f_82479_;
                handY = Mth.m_14139_((double)partialTicks, (double)player.f_19855_, (double)player.m_20186_()) + handVector.f_82480_;
                handZ = Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()) + handVector.f_82481_;
                eyeHeight = player.m_20192_();
            } else {
                handX = Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()) - playerAngleZ * handOffset - playerAngleX * 0.8;
                handY = -0.2 + player.f_19855_ + (double)player.m_20192_() + (player.m_20186_() - player.f_19855_) * (double)partialTicks - 0.45;
                handZ = Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()) - playerAngleX * handOffset + playerAngleZ * 0.8;
                eyeHeight = player.m_6047_() ? -0.1875f : 0.0f;
            }
            Vec3 renderPlayerVec = new Vec3(handX, handY + (double)eyeHeight, handZ);
            this.renderConnection(post, world, partialTicks, matrices, vertexBuilder, vectorOfCurrentPostOfPlayer, renderPlayerVec, postPos, player.m_20183_(), quadStartU, quadEndU, quadStartV, quadEndV);
        }
    }

    private void renderConnection(WirePostBlockEntity post, Level level, float partialTicks, PoseStack matrices, VertexConsumer vertexBuilder, Vec3 startVec, Vec3 endVec, BlockPos startPos, BlockPos endPos, float minU, float maxU, float minV, float maxV) {
        matrices.m_85836_();
        boolean translateSwap = false;
        if (startVec.m_7098_() > endVec.m_7098_()) {
            Vec3 swap = startVec;
            startVec = endVec;
            endVec = swap;
            float swapF = minU;
            minU = maxU;
            maxU = swapF;
            swapF = minV;
            minV = maxV;
            maxV = swapF;
            translateSwap = true;
        }
        matrices.m_85837_(0.5, 0.5, 0.5);
        double startX = startVec.m_7096_();
        double startY = startVec.m_7098_();
        double startZ = startVec.m_7094_();
        double endX = endVec.m_7096_();
        double endY = endVec.m_7098_();
        double endZ = endVec.m_7094_();
        float dx = (float)(endX - startX);
        float dy = (float)(endY - startY);
        float dz = (float)(endZ - startZ);
        if (translateSwap) {
            matrices.m_252880_(-dx, -dy, -dz);
        }
        if (startY <= endY) {
            Vec3[] pointList = SlackInterpolator.getInterpolatedDifferences(endVec.m_82546_(startVec));
            int points = pointList.length;
            int lines = points - 1;
            float cableWidth = 0.1f;
            Matrix4f lastMatrix = matrices.m_85850_().m_252922_();
            float offsetScale = 0.5f * cableWidth * (float)Mth.m_14193_((double)(dx * dx + dz * dz));
            float xOffset = dz * offsetScale;
            float zOffset = dx * offsetScale;
            int startBlockLight = level.m_45517_(LightLayer.BLOCK, startPos);
            int endBlockLight = level.m_45517_(LightLayer.BLOCK, endPos);
            int startSkyLight = level.m_45517_(LightLayer.SKY, startPos);
            int endSkyLight = level.m_45517_(LightLayer.SKY, endPos);
            float maxLerpFactor = (float)lines - 1.0f;
            for (int segmentIndex = 0; segmentIndex < lines; ++segmentIndex) {
                Vec3 firstPoint = pointList[segmentIndex];
                Vec3 secondPoint = pointList[segmentIndex + 1];
                float lerpFactor = (float)segmentIndex / maxLerpFactor;
                int lerpedBlockLight = (int)Mth.m_14179_((float)lerpFactor, (float)startBlockLight, (float)endBlockLight);
                int lerpedSkyLight = (int)Mth.m_14179_((float)lerpFactor, (float)startSkyLight, (float)endSkyLight);
                int packedLight = LightTexture.m_109885_((int)lerpedBlockLight, (int)lerpedSkyLight);
                float x0 = (float)firstPoint.f_82479_;
                float y0 = (float)firstPoint.f_82480_;
                float z0 = (float)firstPoint.f_82481_;
                float x1 = (float)secondPoint.f_82479_;
                float y1 = (float)secondPoint.f_82480_;
                float z1 = (float)secondPoint.f_82481_;
                int secondSegmentIndex = segmentIndex + 1;
                if (xOffset == 0.0f && zOffset == 0.0f) {
                    float width = cableWidth * 0.5f;
                    BundledCablePostRenderer.addVertexPair(vertexBuilder, lastMatrix, packedLight, x0, y0, z0, cableWidth, cableWidth, segmentIndex, false, width, width, minU, maxU, minV, maxV);
                    BundledCablePostRenderer.addVertexPair(vertexBuilder, lastMatrix, packedLight, x1, y1, z1, cableWidth, cableWidth, secondSegmentIndex, true, width, width, minU, maxU, minV, maxV);
                    BundledCablePostRenderer.addVertexPair(vertexBuilder, lastMatrix, packedLight, x0, y0, z0, cableWidth, 0.0f, segmentIndex, false, -width, width, minU, maxU, minV, maxV);
                    BundledCablePostRenderer.addVertexPair(vertexBuilder, lastMatrix, packedLight, x1, y1, z1, cableWidth, 0.0f, secondSegmentIndex, true, -width, width, minU, maxU, minV, maxV);
                    continue;
                }
                BundledCablePostRenderer.addVertexPair(vertexBuilder, lastMatrix, packedLight, x0, y0, z0, cableWidth, cableWidth, segmentIndex, false, xOffset, zOffset, minU, maxU, minV, maxV);
                BundledCablePostRenderer.addVertexPair(vertexBuilder, lastMatrix, packedLight, x1, y1, z1, cableWidth, cableWidth, secondSegmentIndex, true, xOffset, zOffset, minU, maxU, minV, maxV);
                BundledCablePostRenderer.addVertexPair(vertexBuilder, lastMatrix, packedLight, x0, y0, z0, cableWidth, 0.0f, segmentIndex, false, xOffset, zOffset, minU, maxU, minV, maxV);
                BundledCablePostRenderer.addVertexPair(vertexBuilder, lastMatrix, packedLight, x1, y1, z1, cableWidth, 0.0f, secondSegmentIndex, true, xOffset, zOffset, minU, maxU, minV, maxV);
            }
        }
        matrices.m_85849_();
    }

    public boolean shouldRenderOffScreen(WirePostBlockEntity te) {
        return true;
    }

    public static void addVertexPair(VertexConsumer vertexBuilder, Matrix4f lastMatrix, int packedLight, float x, float y, float z, float cableWidth, float cableWidthOrZero, int segmentIndex, boolean secondVertexPairForQuad, float xOffset, float zOffset, float minU, float maxU, float minV, float maxV) {
        if (!secondVertexPairForQuad) {
            vertexBuilder.m_252986_(lastMatrix, x + xOffset, y + cableWidth - cableWidthOrZero, z - zOffset).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU, minV).m_85969_(packedLight).m_5752_();
            vertexBuilder.m_252986_(lastMatrix, x - xOffset, y + cableWidthOrZero, z + zOffset).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU, maxV).m_85969_(packedLight).m_5752_();
        } else {
            vertexBuilder.m_252986_(lastMatrix, x - xOffset, y + cableWidthOrZero, z + zOffset).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(maxU, maxV).m_85969_(packedLight).m_5752_();
            vertexBuilder.m_252986_(lastMatrix, x + xOffset, y + cableWidth - cableWidthOrZero, z - zOffset).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(maxU, minV).m_85969_(packedLight).m_5752_();
        }
    }
}

