/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.soldering;

import commoble.morered.soldering.SolderingMenu;
import commoble.morered.soldering.SolderingRecipe;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;

public class SolderingResultSlot
extends Slot {
    private final SolderingMenu container;

    public SolderingResultSlot(SolderingMenu container, Container resultInventory, int index, int xPosition, int yPosition) {
        super(resultInventory, index, xPosition, yPosition);
        this.container = container;
    }

    public boolean m_5857_(ItemStack stack) {
        return false;
    }

    public void m_142406_(Player player, ItemStack stack) {
        super.m_142406_(player, stack);
        this.container.currentRecipe.ifPresent(recipe -> this.removeIngredients(player.m_150109_(), (Recipe<CraftingContainer>)recipe));
        this.verifyRecipeAfterCrafting(player.m_150109_(), this.container.currentRecipe);
    }

    public boolean m_8010_(Player player) {
        return this.container.currentRecipe.map(recipe -> SolderingRecipe.doesPlayerHaveIngredients(player.m_150109_(), (Recipe<CraftingContainer>)recipe)).orElse(false);
    }

    public void removeIngredients(Inventory playerInventory, Recipe<CraftingContainer> recipe) {
        NonNullList ingredients = recipe.m_7527_();
        for (Ingredient ingredient : ingredients) {
            int remainingItemsToRemove = ingredient.m_43908_()[0].m_41613_();
            int playerSlots = playerInventory.m_6643_();
            for (int playerSlot = 0; playerSlot < playerSlots && remainingItemsToRemove > 0; ++playerSlot) {
                ItemStack stackInSlot = playerInventory.m_8020_(playerSlot);
                if (!ingredient.test(stackInSlot)) continue;
                int decrementAmount = Math.min(remainingItemsToRemove, stackInSlot.m_41613_());
                remainingItemsToRemove -= decrementAmount;
                playerInventory.m_7407_(playerSlot, decrementAmount);
            }
        }
    }

    public void verifyRecipeAfterCrafting(Inventory playerInventory, Optional<Recipe<CraftingContainer>> recipeHolder) {
        Optional<Recipe> remainingRecipe = recipeHolder.filter(recipe -> SolderingRecipe.doesPlayerHaveIngredients(playerInventory, (Recipe<CraftingContainer>)recipe));
        this.m_5852_(remainingRecipe.map(recipe -> recipe.m_8043_(playerInventory.f_35978_.m_9236_().m_9598_()).m_41777_()).orElse(ItemStack.f_41583_));
        this.container.currentRecipe = remainingRecipe;
    }
}

