/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.wires;

import com.google.common.cache.LoadingCache;
import commoble.morered.MoreRed;
import commoble.morered.api.ExpandedPowerSupplier;
import commoble.morered.api.MoreRedAPI;
import commoble.morered.api.WireConnector;
import commoble.morered.util.BlockStateUtil;
import commoble.morered.util.DirectionHelper;
import commoble.morered.wires.AbstractWireBlock;
import commoble.morered.wires.WireBlockEntity;
import java.util.EnumSet;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class PoweredWireBlock
extends AbstractWireBlock
implements EntityBlock {
    public PoweredWireBlock(BlockBehaviour.Properties properties, VoxelShape[] shapesByStateIndex, VoxelShape[] raytraceBackboards, LoadingCache<Long, VoxelShape> voxelCache, boolean useIndirectPower) {
        super(properties, shapesByStateIndex, raytraceBackboards, voxelCache, useIndirectPower);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)MoreRed.get().wireBeType.get()).m_155264_(pos, state);
    }

    public boolean m_7899_(BlockState state) {
        return !this.isEmptyWireBlock(state);
    }

    public int m_6378_(BlockState state, BlockGetter world, BlockPos pos, Direction directionFromNeighbor) {
        return this.getPower(state, world, pos, directionFromNeighbor, false);
    }

    public int m_6376_(BlockState state, BlockGetter world, BlockPos pos, Direction directionFromNeighbor) {
        return this.useIndirectPower ? this.getPower(state, world, pos, directionFromNeighbor, false) : 0;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction directionFromNeighbor) {
        if (directionFromNeighbor == null) {
            return false;
        }
        Direction directionToNeighbor = directionFromNeighbor.m_122424_();
        int side = directionToNeighbor.ordinal();
        if (((Boolean)state.m_61143_((Property)INTERIOR_FACES[side])).booleanValue()) {
            return true;
        }
        for (int subSide = 0; subSide < 4; ++subSide) {
            int orthagonalSide = DirectionHelper.uncompressSecondSide(side, subSide);
            if (!((Boolean)state.m_61143_((Property)INTERIOR_FACES[orthagonalSide])).booleanValue()) continue;
            return true;
        }
        return false;
    }

    protected int getPower(BlockState state, BlockGetter world, BlockPos pos, Direction directionFromNeighbor, boolean expand) {
        BlockEntity te = world.m_7702_(pos);
        if (!(te instanceof WireBlockEntity)) {
            return 0;
        }
        WireBlockEntity wire = (WireBlockEntity)te;
        Direction directionToNeighbor = directionFromNeighbor.m_122424_();
        int side = directionToNeighbor.ordinal();
        if (((Boolean)state.m_61143_((Property)INTERIOR_FACES[side])).booleanValue()) {
            int power = wire.getPower(side);
            return expand ? power : power / 2;
        }
        BlockPos neighborPos = pos.m_121945_(directionToNeighbor);
        BlockState neighborState = world.m_8055_(neighborPos);
        WireConnector connector = MoreRedAPI.getWireConnectabilityRegistry().getOrDefault(neighborState.m_60734_(), MoreRedAPI.getDefaultWireConnector());
        int output = 0;
        for (int i = 0; i < 4; ++i) {
            int attachmentSide = DirectionHelper.uncompressSecondSide(side, i);
            Direction attachmentDirection = Direction.m_122376_((int)attachmentSide);
            if (!((Boolean)state.m_61143_((Property)INTERIOR_FACES[attachmentSide])).booleanValue() || !connector.canConnectToAdjacentWire(world, neighborPos, neighborState, pos, state, attachmentDirection, directionFromNeighbor)) continue;
            output = Math.max(output, wire.getPower(attachmentSide));
        }
        return expand ? output : output / 2;
    }

    public int getExpandedPower(Level world, BlockPos thisPos, BlockState thisState, BlockPos wirePos, BlockState wireState, Direction wireFace, Direction directionFromWire) {
        BlockEntity te = world.m_7702_(thisPos);
        if (!(te instanceof WireBlockEntity)) {
            return 0;
        }
        WireBlockEntity wire = (WireBlockEntity)te;
        return (Boolean)thisState.m_61143_((Property)INTERIOR_FACES[wireFace.ordinal()]) != false ? wire.getPower(wireFace) : 0;
    }

    @Override
    protected void updatePowerAfterBlockUpdate(Level world, BlockPos wirePos, BlockState wireState) {
        BlockEntity te = world.m_7702_(wirePos);
        if (!(te instanceof WireBlockEntity)) {
            return;
        }
        WireBlockEntity wire = (WireBlockEntity)te;
        Map<Block, WireConnector> connectors = MoreRedAPI.getWireConnectabilityRegistry();
        Map<Block, ExpandedPowerSupplier> expandedPowerSuppliers = MoreRedAPI.getExpandedPowerRegistry();
        WireConnector defaultConnector = MoreRedAPI.getDefaultWireConnector();
        ExpandedPowerSupplier defaultPowerSupplier = MoreRedAPI.getDefaultExpandedPowerSupplier();
        BlockPos.MutableBlockPos mutaPos = wirePos.m_122032_();
        BlockState[] neighborStates = new BlockState[6];
        boolean anyPowerUpdated = false;
        EnumSet<Direction> facesNeedingUpdates = EnumSet.noneOf(Direction.class);
        boolean[] attachedFaceStates = new boolean[6];
        for (int attachmentSide = 0; attachmentSide < 6; ++attachmentSide) {
            if (((Boolean)wireState.m_61143_((Property)INTERIOR_FACES[attachmentSide])).booleanValue()) {
                attachedFaceStates[attachmentSide] = true;
                facesNeedingUpdates.add(Direction.m_122376_((int)attachmentSide));
                continue;
            }
            if (!wire.setPower(attachmentSide, 0)) continue;
            anyPowerUpdated = true;
        }
        int iteration = 0;
        while (!facesNeedingUpdates.isEmpty()) {
            BlockState attachedNeighborState;
            int attachmentSide;
            Direction attachmentDirection;
            if (!facesNeedingUpdates.remove(attachmentDirection = Direction.m_122376_((int)(attachmentSide = iteration++ % 6)))) continue;
            int power = 0;
            mutaPos.m_122159_((Vec3i)wirePos, attachmentDirection);
            BlockState attachedNeighborStateCheck = neighborStates[attachmentSide];
            if (attachedNeighborStateCheck == null) {
                neighborStates[attachmentSide] = attachedNeighborState = world.m_8055_((BlockPos)mutaPos);
            } else {
                attachedNeighborState = attachedNeighborStateCheck;
            }
            int weakNeighborPower = attachedNeighborState.m_60746_((BlockGetter)world, (BlockPos)mutaPos, attachmentDirection);
            int neighborPower = this.useIndirectPower && attachedNeighborState.shouldCheckWeakPower((SignalGetter)world, (BlockPos)mutaPos, attachmentDirection) ? Math.max(weakNeighborPower, world.m_277173_((BlockPos)mutaPos)) : weakNeighborPower;
            power = Math.max(power, neighborPower * 2 - 1);
            for (int orthagonal = 0; orthagonal < 4; ++orthagonal) {
                BlockEntity diagonalTe;
                BlockState neighborState;
                int neighborSide = DirectionHelper.uncompressSecondSide(attachmentSide, orthagonal);
                Direction directionToNeighbor = Direction.m_122376_((int)neighborSide);
                Direction directionToWire = directionToNeighbor.m_122424_();
                BlockState neighborStateCheck = neighborStates[neighborSide];
                mutaPos.m_122159_((Vec3i)wirePos, directionToNeighbor);
                if (neighborStateCheck == null) {
                    neighborStates[neighborSide] = neighborState = world.m_8055_((BlockPos)mutaPos);
                } else {
                    neighborState = neighborStateCheck;
                }
                Block neighborBlock = neighborState.m_60734_();
                WireConnector connector = connectors.getOrDefault(neighborBlock, defaultConnector);
                if (connector.canConnectToAdjacentWire((BlockGetter)world, (BlockPos)mutaPos, neighborState, wirePos, wireState, attachmentDirection, directionToWire)) {
                    ExpandedPowerSupplier expandedPowerSupplier = expandedPowerSuppliers.getOrDefault(neighborBlock, defaultPowerSupplier);
                    int expandedWeakNeighborPower = expandedPowerSupplier.getExpandedPower(world, (BlockPos)mutaPos, neighborState, wirePos, wireState, attachmentDirection, directionToNeighbor);
                    int expandedNeighborPower = this.useIndirectPower && neighborState.shouldCheckWeakPower((SignalGetter)world, (BlockPos)mutaPos, directionToNeighbor) ? Math.max(expandedWeakNeighborPower, world.m_277173_((BlockPos)mutaPos) * 2) : expandedWeakNeighborPower;
                    power = Math.max(power, expandedNeighborPower - 1);
                }
                if (directionToNeighbor != attachmentDirection) {
                    power = Math.max(power, wire.getPower(neighborSide) - 1);
                }
                if (attachedFaceStates[neighborSide] || neighborBlock != this || ((Boolean)neighborState.m_61143_((Property)INTERIOR_FACES[attachmentSide])).booleanValue()) continue;
                BlockPos.MutableBlockPos diagonalPos = mutaPos.m_122173_(attachmentDirection);
                BlockState diagonalState = world.m_8055_((BlockPos)mutaPos);
                int directionToWireSide = directionToWire.ordinal();
                if (diagonalState.m_60734_() != this || !((Boolean)diagonalState.m_61143_((Property)INTERIOR_FACES[directionToWireSide])).booleanValue() || !((diagonalTe = world.m_7702_((BlockPos)diagonalPos)) instanceof WireBlockEntity)) continue;
                power = Math.max(power, ((WireBlockEntity)diagonalTe).getPower(directionToWireSide) - 1);
            }
            if (!wire.setPower(attachmentSide, power)) continue;
            anyPowerUpdated = true;
            Direction[] nextUpdateDirs = BlockStateUtil.OUTPUT_TABLE[attachmentSide];
            for (int i = 0; i < 4; ++i) {
                Direction nextUpdateDir = nextUpdateDirs[i];
                if (!attachedFaceStates[nextUpdateDir.ordinal()]) continue;
                facesNeedingUpdates.add(nextUpdateDir);
            }
        }
        if (anyPowerUpdated && !world.f_46443_) {
            this.notifyNeighbors(world, wirePos, wireState, EnumSet.allOf(Direction.class), true);
        }
    }

    @Override
    protected void notifyNeighbors(Level world, BlockPos wirePos, BlockState newState, EnumSet<Direction> updateDirections, boolean doConductedPowerUpdates) {
        Block newBlock = newState.m_60734_();
        if (!ForgeEventFactory.onNeighborNotify((Level)world, (BlockPos)wirePos, (BlockState)newState, updateDirections, (boolean)false).isCanceled()) {
            for (Direction dir : updateDirections) {
                BlockPos neighborPos = wirePos.m_121945_(dir);
                boolean doSecondaryNeighborUpdates = doConductedPowerUpdates && world.m_8055_(neighborPos).shouldCheckWeakPower((SignalGetter)world, neighborPos, dir);
                world.m_46586_(neighborPos, newBlock, wirePos);
                if (!doSecondaryNeighborUpdates) continue;
                world.m_46672_(neighborPos, newBlock);
            }
        }
    }
}

