/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.common.network.packets;

import com.direwolf20.buildinggadgets2.common.items.BaseGadget;
import com.direwolf20.buildinggadgets2.common.items.GadgetCopyPaste;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.VectorHelper;
import com.direwolf20.buildinggadgets2.util.context.ItemActionContext;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkEvent;

public class PacketCopyCoords {
    BlockPos startPos;
    BlockPos endPos;

    public PacketCopyCoords(BlockPos startPos, BlockPos endPos) {
        this.startPos = startPos;
        this.endPos = endPos;
    }

    public static PacketCopyCoords decode(FriendlyByteBuf buf) {
        return new PacketCopyCoords(buf.m_130135_(), buf.m_130135_());
    }

    public static void encode(PacketCopyCoords message, FriendlyByteBuf buf) {
        buf.m_130064_(message.startPos);
        buf.m_130064_(message.endPos);
    }

    public static void handle(PacketCopyCoords message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Item patt1703$temp;
            ServerPlayer sender = ((NetworkEvent.Context)context.get()).getSender();
            if (sender == null) {
                return;
            }
            ItemStack gadget = BaseGadget.getGadget((Player)sender);
            if (gadget.m_41619_() || !((patt1703$temp = gadget.m_41720_()) instanceof BaseGadget)) {
                return;
            }
            BaseGadget actualGadget = (BaseGadget)patt1703$temp;
            GadgetNBT.setCopyStartPos(gadget, message.startPos);
            GadgetNBT.setCopyEndPos(gadget, message.endPos);
            BlockHitResult lookingAt = VectorHelper.getLookingAt((Player)sender, gadget);
            ItemActionContext itemContext = new ItemActionContext(lookingAt.m_82425_(), lookingAt, (Player)sender, sender.m_9236_(), InteractionHand.MAIN_HAND, gadget);
            Item patt2192$temp = gadget.m_41720_();
            if (patt2192$temp instanceof GadgetCopyPaste) {
                GadgetCopyPaste gadgetCopyPaste = (GadgetCopyPaste)patt2192$temp;
                gadgetCopyPaste.buildAndStore(itemContext, gadget);
            }
        });
        context.get().setPacketHandled(true);
    }
}

