/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.entity.ai.brain.task.rascal;

import com.faboslav.friendsandfoes.FriendsAndFoes;
import com.faboslav.friendsandfoes.entity.RascalEntity;
import com.faboslav.friendsandfoes.entity.ai.brain.RascalBrain;
import com.faboslav.friendsandfoes.entity.pose.RascalEntityPose;
import com.faboslav.friendsandfoes.init.FriendsAndFoesCriteria;
import com.faboslav.friendsandfoes.init.FriendsAndFoesMemoryModuleTypes;
import com.faboslav.friendsandfoes.mixin.BundleItemAccessor;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.StructureTags;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public final class RascalWaitForPlayerTask
extends Behavior<RascalEntity> {
    private static final int NOD_DURATION = 90;
    public static final float NOD_RANGE = 4.0f;
    private int nodTicks;
    private LivingEntity nearestTarget;

    public RascalWaitForPlayerTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_148206_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26374_, (Object)MemoryStatus.VALUE_PRESENT, FriendsAndFoesMemoryModuleTypes.RASCAL_NOD_COOLDOWN.get(), (Object)MemoryStatus.VALUE_ABSENT), 90);
    }

    protected boolean shouldRun(ServerLevel world, RascalEntity rascal) {
        if (rascal.m_8077_()) {
            return false;
        }
        LivingEntity nearestTarget = rascal.m_6274_().m_21952_(MemoryModuleType.f_148206_).orElse(null);
        if (nearestTarget == null) {
            nearestTarget = rascal.m_6274_().m_21952_(MemoryModuleType.f_26374_).orElse(null);
        }
        if (nearestTarget == null || rascal.m_20270_((Entity)nearestTarget) > 4.0f || !nearestTarget.m_6084_() || nearestTarget instanceof Player && (nearestTarget.m_5833_() || ((Player)nearestTarget).m_7500_())) {
            return false;
        }
        this.nearestTarget = nearestTarget;
        return true;
    }

    protected void run(ServerLevel world, RascalEntity rascal, long time) {
        rascal.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        rascal.m_21573_().m_26517_(0.0);
        rascal.m_21573_().m_26573_();
        rascal.m_21573_().m_7638_();
        rascal.m_21566_().m_8126_();
        rascal.m_7910_(0.0f);
        rascal.f_19867_ = 0.0f;
        rascal.f_19787_ = 0.0f;
        rascal.f_20900_ = 0.0f;
        rascal.f_20901_ = 0.0f;
        BehaviorUtils.m_22595_((LivingEntity)rascal, (LivingEntity)this.nearestTarget);
        rascal.m_21563_().m_148051_((Entity)this.nearestTarget);
        rascal.m_21563_().m_8128_();
        this.nodTicks = 0;
        rascal.addToCaughtCount();
        rascal.disableAmbientSounds();
    }

    protected boolean shouldKeepRunning(ServerLevel world, RascalEntity rascal, long time) {
        return this.nodTicks <= 90;
    }

    protected void keepRunning(ServerLevel world, RascalEntity rascal, long time) {
        if (this.nodTicks == 20) {
            rascal.startNodAnimation();
            rascal.m_21563_().m_148051_((Entity)this.nearestTarget);
        }
        if (this.nodTicks == 40 && rascal.shouldGiveReward()) {
            rascal.startGiveRewardAnimation();
        }
        if (this.nodTicks == 62 && rascal.shouldGiveReward()) {
            Vec3 targetPos = this.nearestTarget.m_20182_().m_82520_(0.0, 1.0, 0.0);
            LootDataManager lootManager = world.m_7654_().m_278653_();
            if (lootManager != null) {
                LootTable rascalGoodItemsLootTable = lootManager.m_278676_(FriendsAndFoes.makeID("rewards/rascal_good_reward"));
                LootParams lootContextParameterSet = new LootParams.Builder(world).m_287286_(LootContextParams.f_81460_, (Object)targetPos).m_287286_(LootContextParams.f_81455_, (Object)this.nearestTarget).m_287235_(LootContextParamSets.f_81416_);
                ObjectArrayList rascalGoodRewards = rascalGoodItemsLootTable.m_287195_(lootContextParameterSet);
                for (ItemStack rascalReward : rascalGoodRewards) {
                    ItemStack bundleItemStack = Items.f_151058_.m_7968_();
                    BundleItemAccessor.callAddToBundle(bundleItemStack, rascalReward);
                    BehaviorUtils.m_22613_((LivingEntity)rascal, (ItemStack)bundleItemStack, (Vec3)this.nearestTarget.m_20182_().m_82520_(0.0, 1.0, 0.0));
                }
            }
            FriendsAndFoesCriteria.COMPLETE_HIDE_AND_SEEK_GAME.trigger((ServerPlayer)this.nearestTarget, rascal);
        }
        ++this.nodTicks;
    }

    protected void finishRunning(ServerLevel world, RascalEntity rascal, long time) {
        if (rascal.m_8077_()) {
            RascalBrain.setNodCooldown(rascal);
            return;
        }
        rascal.spawnCloudParticles();
        rascal.playDisappearSound();
        if (rascal.shouldGiveReward()) {
            rascal.m_146870_();
            return;
        }
        rascal.setPose(RascalEntityPose.IDLE);
        rascal.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 200));
        this.tryToTeleport(world, rascal);
        RascalBrain.setNodCooldown(rascal);
        rascal.enableAmbientSounds();
    }

    private void tryToTeleport(ServerLevel world, RascalEntity rascal) {
        StructureManager structureAccessor = world.m_215010_();
        for (int i = 0; i < 64; ++i) {
            boolean teleportResult;
            double z;
            double y;
            double x = rascal.m_20185_() + (rascal.m_217043_().m_188500_() - 0.5) * 16.0;
            if (!structureAccessor.m_220491_(new BlockPos((int)x, (int)(y = Mth.m_14008_((double)(rascal.m_20186_() + (double)(rascal.m_217043_().m_188503_(8) - 4)), (double)world.m_141937_(), (double)(world.m_141937_() + world.m_143344_() - 1))), (int)(z = rascal.m_20189_() + (rascal.m_217043_().m_188500_() - 0.5) * 16.0)), StructureTags.f_215890_).m_73603_()) continue;
            if (rascal.m_20159_()) {
                rascal.m_8127_();
            }
            if (!(teleportResult = rascal.m_20984_(x, y, z, false)) || !((double)rascal.m_20270_((Entity)this.nearestTarget) > 10.0)) continue;
            return;
        }
    }
}

