/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.entity.ai.brain.task.wildfire;

import com.faboslav.friendsandfoes.entity.WildfireEntity;
import com.faboslav.friendsandfoes.entity.WildfireShieldDebrisEntity;
import com.faboslav.friendsandfoes.entity.ai.brain.WildfireBrain;
import com.faboslav.friendsandfoes.init.FriendsAndFoesMemoryModuleTypes;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public final class WildfireBarrageAttackTask
extends Behavior<WildfireEntity> {
    private int shieldDebrisFired;
    private int shieldDebrisCooldown;
    private boolean canDoMeeleAttack;
    private LivingEntity attackTarget;
    private int attackTargetIsNotVisibleTicks;
    private static final int BARRAGE_ATTACK_DURATION = 180;
    private static final int MAX_FIREBALLS_TO_BE_FIRED = 30;

    public WildfireBarrageAttackTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT, FriendsAndFoesMemoryModuleTypes.WILDFIRE_BARRAGE_ATTACK_COOLDOWN.get(), (Object)MemoryStatus.VALUE_ABSENT), 180);
    }

    protected boolean shouldRun(ServerLevel world, WildfireEntity wildfire) {
        LivingEntity attackTarget = wildfire.m_6274_().m_21952_(MemoryModuleType.f_26372_).orElse(null);
        if (attackTarget == null || !attackTarget.m_6084_() || attackTarget instanceof Player && (attackTarget.m_5833_() || ((Player)attackTarget).m_7500_())) {
            return false;
        }
        this.attackTarget = attackTarget;
        return true;
    }

    protected void run(ServerLevel world, WildfireEntity wildfire, long time) {
        wildfire.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        wildfire.m_21573_().m_26573_();
        BehaviorUtils.m_22595_((LivingEntity)wildfire, (LivingEntity)this.attackTarget);
        wildfire.m_21563_().m_148051_((Entity)this.attackTarget);
        WildfireBrain.setAttackTarget(wildfire, this.attackTarget);
        this.shieldDebrisFired = 0;
        this.attackTargetIsNotVisibleTicks = 0;
        this.canDoMeeleAttack = true;
    }

    protected boolean shouldKeepRunning(ServerLevel world, WildfireEntity wildfire, long time) {
        if (!this.attackTarget.m_6084_()) {
            this.attackTarget = wildfire.m_6274_().m_21952_(MemoryModuleType.f_148206_).orElse(null);
        }
        if (this.attackTarget == null || !this.attackTarget.m_6084_() || !this.attackTarget.m_6084_() || this.attackTarget instanceof Player && (this.attackTarget.m_5833_() || ((Player)this.attackTarget).m_7500_()) || this.shieldDebrisFired > 30) {
            return false;
        }
        Player nearestVisibleTargetablePlayer = wildfire.m_6274_().m_21952_(MemoryModuleType.f_148206_).orElse(null);
        return nearestVisibleTargetablePlayer == null || !nearestVisibleTargetablePlayer.m_6084_() || !(wildfire.m_20270_((Entity)nearestVisibleTargetablePlayer) <= 6.0f) || !wildfire.m_6274_().m_21876_(FriendsAndFoesMemoryModuleTypes.WILDFIRE_SHOCKWAVE_ATTACK_COOLDOWN.get(), MemoryStatus.VALUE_ABSENT);
    }

    protected void keepRunning(ServerLevel world, WildfireEntity wildfire, long time) {
        wildfire.m_21563_().m_148051_((Entity)this.attackTarget);
        boolean isAttackTargetVisible = wildfire.m_21574_().m_148306_((Entity)this.attackTarget);
        this.attackTargetIsNotVisibleTicks = isAttackTargetVisible ? 0 : ++this.attackTargetIsNotVisibleTicks;
        double targetX = this.attackTarget.m_20185_() - wildfire.m_20185_();
        double targetY = this.attackTarget.m_20227_(0.5) - wildfire.m_20227_(0.5);
        double targetZ = this.attackTarget.m_20189_() - wildfire.m_20189_();
        if (this.shieldDebrisCooldown > 0) {
            --this.shieldDebrisCooldown;
            return;
        }
        if (this.canDoMeeleAttack && wildfire.m_20270_((Entity)this.attackTarget) < 3.0f) {
            wildfire.m_7327_((Entity)this.attackTarget);
            this.canDoMeeleAttack = false;
        } else {
            this.canDoMeeleAttack = true;
        }
        if (this.attackTargetIsNotVisibleTicks > 5) {
            wildfire.m_21566_().m_6849_(this.attackTarget.m_20185_(), this.attackTarget.m_20186_(), this.attackTarget.m_20189_(), (double)wildfire.m_6113_());
        }
        double distanceToAttackTarget = wildfire.m_20280_((Entity)this.attackTarget);
        double h = Math.sqrt(Math.sqrt(distanceToAttackTarget)) * 0.5;
        if (!wildfire.m_20067_()) {
            wildfire.playShootSound();
            wildfire.m_9236_().m_5898_(null, 1018, wildfire.m_20183_(), 0);
        }
        RandomSource random = wildfire.m_217043_();
        for (int i = 0; i < 8; ++i) {
            WildfireShieldDebrisEntity shieldDebris = new WildfireShieldDebrisEntity((Level)world, (LivingEntity)wildfire, random.m_216328_(targetX, 2.297 * h), targetY, random.m_216328_(targetZ, 2.297 * h));
            shieldDebris.m_6034_(shieldDebris.m_20185_(), wildfire.m_20227_(0.5) + 0.5, shieldDebris.m_20189_());
            wildfire.m_9236_().m_7967_((Entity)shieldDebris);
            ++this.shieldDebrisFired;
        }
        this.shieldDebrisCooldown = 10;
    }

    protected void finishRunning(ServerLevel world, WildfireEntity wildfire, long time) {
        WildfireBrain.setBarrageAttackCooldown(wildfire);
    }
}

