/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.forge;

import com.faboslav.friendsandfoes.FriendsAndFoes;
import com.faboslav.friendsandfoes.FriendsAndFoesClient;
import com.faboslav.friendsandfoes.events.lifecycle.DatapackSyncEvent;
import com.faboslav.friendsandfoes.events.lifecycle.RegisterReloadListenerEvent;
import com.faboslav.friendsandfoes.events.lifecycle.SetupEvent;
import com.faboslav.friendsandfoes.forge.init.FriendsAndFoesBiomeModifiers;
import com.faboslav.friendsandfoes.init.FriendsAndFoesEntityTypes;
import com.faboslav.friendsandfoes.init.FriendsAndFoesStructurePoolElements;
import com.faboslav.friendsandfoes.platform.forge.RegistryHelperImpl;
import com.faboslav.friendsandfoes.util.CustomRaidMember;
import com.faboslav.friendsandfoes.util.ServerWorldSpawnersUtil;
import com.faboslav.friendsandfoes.util.UpdateChecker;
import com.faboslav.friendsandfoes.world.spawner.IceologerSpawner;
import com.faboslav.friendsandfoes.world.spawner.IllusionerSpawner;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.SharedConstants;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;

@Mod(value="friendsandfoes")
public final class FriendsAndFoesForge {
    public FriendsAndFoesForge() {
        UpdateChecker.checkForNewUpdates();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        modEventBus.addListener(FriendsAndFoesForge::onSetup);
        FriendsAndFoes.init();
        FriendsAndFoesBiomeModifiers.BIOME_MODIFIERS.register(modEventBus);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            FriendsAndFoesClient.init();
        }
        RegistryHelperImpl.ACTIVITIES.register(modEventBus);
        RegistryHelperImpl.BLOCKS.register(modEventBus);
        FriendsAndFoesEntityTypes.previousUseChoiceTypeRegistrations = SharedConstants.f_136182_;
        SharedConstants.f_136182_ = false;
        RegistryHelperImpl.ENTITY_TYPES.register(modEventBus);
        SharedConstants.f_136182_ = FriendsAndFoesEntityTypes.previousUseChoiceTypeRegistrations;
        RegistryHelperImpl.ITEMS.register(modEventBus);
        RegistryHelperImpl.MEMORY_MODULE_TYPES.register(modEventBus);
        RegistryHelperImpl.SENSOR_TYPES.register(modEventBus);
        RegistryHelperImpl.PARTICLE_TYPES.register(modEventBus);
        RegistryHelperImpl.POINT_OF_INTEREST_TYPES.register(modEventBus);
        RegistryHelperImpl.SOUND_EVENTS.register(modEventBus);
        RegistryHelperImpl.STRUCTURE_TYPES.register(modEventBus);
        RegistryHelperImpl.STRUCTURE_PROCESSOR_TYPES.register(modEventBus);
        RegistryHelperImpl.VILLAGER_PROFESSIONS.register(modEventBus);
        modEventBus.addListener(FriendsAndFoesForge::registerEntityAttributes);
        modEventBus.addListener(FriendsAndFoesForge::addItemsToTabs);
        eventBus.addListener(FriendsAndFoesForge::initSpawners);
        eventBus.addListener(FriendsAndFoesForge::onServerAboutToStartEvent);
        eventBus.addListener(FriendsAndFoesForge::onAddReloadListeners);
        eventBus.addListener(FriendsAndFoesForge::onDatapackSync);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private static void registerEntityAttributes(EntityAttributeCreationEvent event) {
        for (Map.Entry<Supplier<? extends EntityType<? extends LivingEntity>>, Supplier<AttributeSupplier.Builder>> entry : RegistryHelperImpl.ENTITY_ATTRIBUTES.entrySet()) {
            event.put(entry.getKey().get(), entry.getValue().get().m_22265_());
        }
    }

    private static void onAddReloadListeners(AddReloadListenerEvent event) {
        RegisterReloadListenerEvent.EVENT.invoke(new RegisterReloadListenerEvent((id, listener) -> event.addListener(listener)));
    }

    private static void onSetup(FMLCommonSetupEvent event) {
        SetupEvent.EVENT.invoke(new SetupEvent(arg_0 -> ((FMLCommonSetupEvent)event).enqueueWork(arg_0)));
        FriendsAndFoes.postInit();
        event.enqueueWork(() -> {
            if (FriendsAndFoes.getConfig().enableIceologer && FriendsAndFoes.getConfig().enableIceologerInRaids) {
                Raid.RaiderType.create((String)"ICEOLOGER", FriendsAndFoesEntityTypes.ICEOLOGER.get(), (int[])CustomRaidMember.ICEOLOGER_COUNT_IN_WAVE);
            }
            if (FriendsAndFoes.getConfig().enableIllusioner && FriendsAndFoes.getConfig().enableIllusionerInRaids) {
                Raid.RaiderType.create((String)"ILLUSIONER", (EntityType)EntityType.f_20459_, (int[])CustomRaidMember.ILLUSIONER_COUNT_IN_WAVE);
            }
        });
    }

    private static void addItemsToTabs(BuildCreativeModeTabContentsEvent event) {
        RegistryHelperImpl.ITEMS_TO_ADD_BEFORE.forEach((itemGroup, itemPairs) -> {
            if (event.getTabKey() == itemGroup) {
                itemPairs.forEach((item, before) -> event.getEntries().putBefore((Object)before.m_7968_(), (Object)item.m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS));
            }
        });
        RegistryHelperImpl.ITEMS_TO_ADD_AFTER.forEach((itemGroup, itemPairs) -> {
            if (event.getTabKey() == itemGroup) {
                itemPairs.forEach((item, after) -> event.getEntries().putAfter((Object)after.m_7968_(), (Object)item.m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS));
            }
        });
    }

    private static void onDatapackSync(OnDatapackSyncEvent event) {
        if (FMLEnvironment.dist.isDedicatedServer()) {
            if (event.getPlayer() != null) {
                DatapackSyncEvent.EVENT.invoke(new DatapackSyncEvent(event.getPlayer()));
            } else {
                event.getPlayerList().m_11314_().forEach(player -> DatapackSyncEvent.EVENT.invoke(new DatapackSyncEvent((ServerPlayer)player)));
            }
        }
    }

    private static void initSpawners(LevelEvent.Load event) {
        if (event.getLevel().m_5776_() || ((ServerLevel)event.getLevel()).m_220362_() != BuiltinDimensionTypes.f_223538_) {
            return;
        }
        MinecraftServer server = event.getLevel().m_7654_();
        if (server == null) {
            return;
        }
        ServerLevel world = server.m_129783_();
        if (world == null) {
            return;
        }
        ServerWorldSpawnersUtil.register(world, new IceologerSpawner());
        ServerWorldSpawnersUtil.register(world, new IllusionerSpawner());
    }

    public static void onServerAboutToStartEvent(ServerAboutToStartEvent event) {
        FriendsAndFoesStructurePoolElements.init(event.getServer());
    }
}

