/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.mixin;

import com.faboslav.friendsandfoes.block.Oxidizable;
import com.faboslav.friendsandfoes.util.WaxableBlocksMap;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={AxeItem.class})
public abstract class AxeItemMixin {
    @ModifyVariable(method={"useOnBlock"}, ordinal=0, at=@At(value="STORE"))
    private Optional<BlockState> friendsandfoes_modifyOxidizedBlock(Optional<BlockState> originalBlockState, UseOnContext context) {
        if (originalBlockState.isPresent()) {
            return originalBlockState;
        }
        Level world = context.m_43725_();
        BlockPos blockPos = context.m_8083_();
        Player playerEntity = context.m_43723_();
        BlockState state = world.m_8055_(blockPos);
        return this.friendsandfoes_tryStrip(world, blockPos, playerEntity, state);
    }

    private Optional<BlockState> friendsandfoes_tryStrip(Level world, BlockPos pos, @Nullable Player player, BlockState state) {
        Optional<BlockState> decreasedOxidationState = Oxidizable.getDecreasedOxidationState(state);
        if (decreasedOxidationState.isPresent()) {
            world.m_5594_(player, pos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.m_5898_(player, 3005, pos, 0);
            return decreasedOxidationState;
        }
        Optional<BlockState> unwaxedState = Optional.ofNullable((Block)WaxableBlocksMap.WAXED_TO_UNWAXED_BLOCKS.get().get((Object)state.m_60734_())).map(block -> block.m_152465_(state));
        if (unwaxedState.isPresent()) {
            world.m_5594_(player, pos, SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.m_5898_(player, 3004, pos, 0);
            return unwaxedState;
        }
        return Optional.empty();
    }
}

