/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.mixin;

import com.faboslav.friendsandfoes.FriendsAndFoes;
import com.faboslav.friendsandfoes.entity.TuffGolemEntity;
import com.faboslav.friendsandfoes.init.FriendsAndFoesEntityTypes;
import com.faboslav.friendsandfoes.util.CopperGolemBuildPatternPredicates;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CarvedPumpkinBlock.class})
public abstract class CarvedPumpkinBlockMixin
extends HorizontalDirectionalBlock {
    @Nullable
    private BlockPattern friendsandfoes_copperGolemDispenserPattern;
    @Nullable
    private BlockPattern friendsandfoes_tuffGolemDispenserPattern;
    @Nullable
    private BlockPattern friendsandfoes_tuffGolemPattern;
    private static final Predicate<BlockState> IS_TUFF_GOLEM_HEAD_PREDICATE = state -> state != null && (state.m_60713_(Blocks.f_50143_) || state.m_60713_(Blocks.f_50144_));
    private static final Predicate<BlockState> IS_TUFF_GOLEM_WOOL_PREDICATE = state -> state != null && state.m_204336_(BlockTags.f_13089_);

    protected CarvedPumpkinBlockMixin(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Inject(method={"canDispense"}, at={@At(value="HEAD")}, cancellable=true)
    public void friendsandfoes_canDispense(LevelReader world, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        if (this.getTuffGolemDispenserPattern().m_61184_(world, pos) != null || this.getCopperGolemDispenserPattern().m_61184_(world, pos) != null) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"onBlockAdded"}, at={@At(value="HEAD")})
    private void friendsandfoes_customOnBlockAdded(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify, CallbackInfo ci) {
        if (!oldState.m_60713_(state.m_60734_())) {
            this.friendsandfoes_tryToSpawnTuffGolem(world, pos);
        }
    }

    private void friendsandfoes_tryToSpawnTuffGolem(Level world, BlockPos pos) {
        if (!FriendsAndFoes.getConfig().enableTuffGolem) {
            return;
        }
        BlockPattern.BlockPatternMatch patternSearchResult = this.friendsandfoes_getTuffGolemPattern().m_61184_((LevelReader)world, pos);
        if (patternSearchResult == null) {
            return;
        }
        BlockState headBlockState = patternSearchResult.m_61229_(0, 0, 0).m_61168_();
        BlockState woolBlockState = patternSearchResult.m_61229_(0, 1, 0).m_61168_();
        for (int i = 0; i < this.friendsandfoes_getTuffGolemPattern().m_61202_(); ++i) {
            BlockInWorld cachedBlockPosition = patternSearchResult.m_61229_(0, i, 0);
            world.m_7731_(cachedBlockPosition.m_61176_(), Blocks.f_50016_.m_49966_(), 2);
            world.m_46796_(2001, cachedBlockPosition.m_61176_(), Block.m_49956_((BlockState)cachedBlockPosition.m_61168_()));
        }
        BlockPos cachedBlockPosition = patternSearchResult.m_61229_(0, 2, 0).m_61176_();
        float tuffGolemYaw = ((Direction)headBlockState.m_61143_((Property)CarvedPumpkinBlock.f_51367_)).m_122435_();
        TuffGolemEntity tuffGolem = (TuffGolemEntity)FriendsAndFoesEntityTypes.TUFF_GOLEM.get().m_20615_(world);
        tuffGolem.m_6034_((double)cachedBlockPosition.m_123341_() + 0.5, (double)cachedBlockPosition.m_123342_() + 0.05, (double)cachedBlockPosition.m_123343_() + 0.5);
        tuffGolem.setSpawnYaw(tuffGolemYaw);
        tuffGolem.setColor(TuffGolemEntity.Color.fromWool(woolBlockState.m_60734_()));
        tuffGolem.m_6518_((ServerLevelAccessor)world, world.m_6436_(cachedBlockPosition), MobSpawnType.TRIGGERED, null, null);
        world.m_7967_((Entity)tuffGolem);
        for (ServerPlayer serverPlayerEntity : world.m_45976_(ServerPlayer.class, tuffGolem.m_20191_().m_82400_(5.0))) {
            CriteriaTriggers.f_10580_.m_68256_(serverPlayerEntity, (Entity)tuffGolem);
        }
        for (int j = 0; j < this.friendsandfoes_getTuffGolemPattern().m_61202_(); ++j) {
            BlockInWorld cachedBlockPosition2 = patternSearchResult.m_61229_(0, j, 0);
            world.m_6289_(cachedBlockPosition2.m_61176_(), Blocks.f_50016_);
        }
    }

    private BlockPattern getCopperGolemDispenserPattern() {
        if (this.friendsandfoes_copperGolemDispenserPattern == null) {
            this.friendsandfoes_copperGolemDispenserPattern = BlockPatternBuilder.m_61243_().m_61247_(new String[]{"|", " ", "#"}).m_61244_('|', BlockInWorld.m_61169_(CopperGolemBuildPatternPredicates.IS_COPPER_GOLEM_LIGHTNING_ROD_PREDICATE)).m_61244_('#', BlockInWorld.m_61169_(CopperGolemBuildPatternPredicates.IS_COPPER_GOLEM_BODY_PREDICATE)).m_61249_();
        }
        return this.friendsandfoes_copperGolemDispenserPattern;
    }

    private BlockPattern getTuffGolemDispenserPattern() {
        if (this.friendsandfoes_tuffGolemDispenserPattern == null) {
            this.friendsandfoes_tuffGolemDispenserPattern = BlockPatternBuilder.m_61243_().m_61247_(new String[]{" ", "|", "#"}).m_61244_('|', BlockInWorld.m_61169_(IS_TUFF_GOLEM_WOOL_PREDICATE)).m_61244_('#', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)Blocks.f_152496_))).m_61249_();
        }
        return this.friendsandfoes_tuffGolemDispenserPattern;
    }

    private BlockPattern friendsandfoes_getTuffGolemPattern() {
        if (this.friendsandfoes_tuffGolemPattern == null) {
            this.friendsandfoes_tuffGolemPattern = BlockPatternBuilder.m_61243_().m_61247_(new String[]{"^", "|", "#"}).m_61244_('^', BlockInWorld.m_61169_(IS_TUFF_GOLEM_HEAD_PREDICATE)).m_61244_('|', BlockInWorld.m_61169_(IS_TUFF_GOLEM_WOOL_PREDICATE)).m_61244_('#', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)Blocks.f_152496_))).m_61249_();
        }
        return this.friendsandfoes_tuffGolemPattern;
    }
}

