/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.mixin;

import com.faboslav.friendsandfoes.FriendsAndFoes;
import com.faboslav.friendsandfoes.entity.TuffGolemEntity;
import com.faboslav.friendsandfoes.entity.pose.TuffGolemEntityPose;
import com.faboslav.friendsandfoes.init.FriendsAndFoesEntityTypes;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.structures.StrongholdPieces;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={StrongholdPieces.Library.class})
public abstract class StrongholdGeneratorMixin
extends StructurePiece {
    private boolean isTuffGolemGenerated = false;

    protected StrongholdGeneratorMixin(StructurePieceType type, int length, BoundingBox boundingBox) {
        super(type, length, boundingBox);
    }

    @Inject(at={@At(value="TAIL")}, method={"generate"})
    private void friendsandfoes_generate(WorldGenLevel world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox chunkBox, ChunkPos chunkPos, BlockPos pivot, CallbackInfo ci) {
        if (!FriendsAndFoes.getConfig().generateTuffGolemInStronghold || this.isTuffGolemGenerated || random.m_188501_() > 0.75f) {
            return;
        }
        ServerLevel serverWorld = world.m_6018_();
        TuffGolemEntity tuffGolem = (TuffGolemEntity)FriendsAndFoesEntityTypes.TUFF_GOLEM.get().m_20615_((Level)serverWorld);
        if (tuffGolem == null) {
            return;
        }
        ArrayList<Tuple> possibleSpawnPositions = new ArrayList<Tuple>();
        for (int x = 5; x < 8; x += 3) {
            for (int y = 4; y < 12; y += 2) {
                possibleSpawnPositions.add(new Tuple((Object)x, (Object)y));
            }
        }
        Tuple pickedXYPair = (Tuple)possibleSpawnPositions.get(random.m_216332_(0, possibleSpawnPositions.size() - 1));
        BlockPos.MutableBlockPos tuffGolemPos = this.m_163582_((Integer)pickedXYPair.m_14418_(), 1, (Integer)pickedXYPair.m_14419_());
        tuffGolem.m_6034_((float)tuffGolemPos.m_123341_() + 0.5f, tuffGolemPos.m_123342_(), (float)tuffGolemPos.m_123343_() + 0.5f);
        float randomSpawnYaw = 90.0f * (float)random.m_216332_(0, 3);
        tuffGolem.setSpawnYaw(randomSpawnYaw);
        ItemStack itemStack = Items.f_42517_.m_7968_();
        itemStack.m_41764_(1);
        ItemStack enchantedItemStack = EnchantmentHelper.m_220292_((RandomSource)random, (ItemStack)itemStack, (int)random.m_216332_(1, 30), (boolean)true);
        tuffGolem.m_8061_(EquipmentSlot.MAINHAND, enchantedItemStack);
        tuffGolem.setPrevPose(TuffGolemEntityPose.STANDING_WITH_ITEM.get());
        tuffGolem.setPoseWithoutPrevPose(TuffGolemEntityPose.SLEEPING_WITH_ITEM.get());
        boolean isTuffGolemSpawned = world.m_7967_((Entity)tuffGolem);
        if (isTuffGolemSpawned) {
            this.isTuffGolemGenerated = true;
        }
    }
}

