/*
 * Decompiled with CFR 0.152.
 */
package net.im_maker.paintable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;
import net.im_maker.paintable.common.block.ModBlocks;
import net.im_maker.paintable.common.block.entity.ModBlockEntities;
import net.im_maker.paintable.common.entity.ModEntities;
import net.im_maker.paintable.common.entity.client.ModBoatRenderer;
import net.im_maker.paintable.common.entity.client.ModModelLayers;
import net.im_maker.paintable.common.item.ModItems;
import net.im_maker.paintable.common.sound.ModSounds;
import net.im_maker.paintable.common.util.ModWoodTypes;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.MissingMappingsEvent;

@Mod(value="paintable")
@Mod.EventBusSubscriber(modid="paintable", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Paintable {
    public static final String MOD_ID = "paintable";
    private static final Function<ItemLike, ItemStack> FUNCTION = ItemStack::new;

    public Paintable() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModBlocks.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModItems.register(modEventBus);
        ModSounds.register(modEventBus);
        ModEntities.register(modEventBus);
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::addCreative);
    }

    @SubscribeEvent
    public void onMissing(MissingMappingsEvent event) {
        for (DyeColor color : DyeColor.values()) {
            ResourceLocation newId;
            ResourceLocation oldId;
            for (MissingMappingsEvent.Mapping mapping : event.getMappings(ForgeRegistries.Keys.BLOCKS, MOD_ID)) {
                oldId = mapping.getKey();
                if (oldId.toString().equals("paintable:" + color + "_painted_planks_stairs")) {
                    newId = new ResourceLocation(MOD_ID, color + "_painted_stairs");
                    mapping.remap(ForgeRegistries.BLOCKS.getValue(newId));
                }
                if (!oldId.toString().equals("paintable:" + color + "_painted_planks_slab")) continue;
                newId = new ResourceLocation(MOD_ID, color + "_painted_slab");
                mapping.remap(ForgeRegistries.BLOCKS.getValue(newId));
            }
            for (MissingMappingsEvent.Mapping mapping : event.getMappings(ForgeRegistries.Keys.ITEMS, MOD_ID)) {
                oldId = mapping.getKey();
                if (oldId.toString().equals("paintable:" + color + "_painted_planks_stairs")) {
                    newId = new ResourceLocation(MOD_ID, color + "_painted_stairs");
                    mapping.remap(ForgeRegistries.ITEMS.getValue(newId));
                }
                if (!oldId.toString().equals("paintable:" + color + "_painted_planks_slab")) continue;
                newId = new ResourceLocation(MOD_ID, color + "_painted_slab");
                mapping.remap(ForgeRegistries.ITEMS.getValue(newId));
            }
        }
    }

    private void clientSetup(FMLClientSetupEvent event) {
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntities.SIGN_BLOCK_ENTITIES.get()), SignRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntities.HANGING_SIGN_BLOCK_ENTITIES.get()), HangingSignRenderer::new);
    }

    private static void addAfter(MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> map, ItemLike after, ItemLike ... blocks) {
        for (int i = blocks.length - 1; i >= 0; --i) {
            ItemLike block = blocks[i];
            map.putAfter((Object)FUNCTION.apply(after), (Object)FUNCTION.apply(block), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    private static void addBefore(MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> map, ItemLike before, ItemLike ... blocks) {
        for (ItemLike block : blocks) {
            map.putBefore((Object)FUNCTION.apply(before), (Object)FUNCTION.apply(block), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        Item item;
        ResourceLocation itemLocation;
        ResourceLocation blockLocation;
        Block block;
        String colorName;
        String formattedBlockType;
        int n;
        MutableHashedLinkedMap entries = event.getEntries();
        ArrayList<DyeColor> customColorOrder = new ArrayList<DyeColor>(Arrays.asList(DyeColor.WHITE, DyeColor.LIGHT_GRAY, DyeColor.GRAY, DyeColor.BLACK, DyeColor.BROWN, DyeColor.RED, DyeColor.ORANGE, DyeColor.YELLOW, DyeColor.LIME, DyeColor.GREEN, DyeColor.CYAN, DyeColor.LIGHT_BLUE, DyeColor.BLUE, DyeColor.PURPLE, DyeColor.MAGENTA, DyeColor.PINK));
        ArrayList<DyeColor> customColorOrderR = new ArrayList<DyeColor>(Arrays.asList(DyeColor.PINK, DyeColor.MAGENTA, DyeColor.PURPLE, DyeColor.BLUE, DyeColor.LIGHT_BLUE, DyeColor.CYAN, DyeColor.GREEN, DyeColor.LIME, DyeColor.YELLOW, DyeColor.ORANGE, DyeColor.RED, DyeColor.BROWN, DyeColor.BLACK, DyeColor.GRAY, DyeColor.LIGHT_GRAY, DyeColor.WHITE));
        String[] woodBlockTypes = new String[]{"%s_painted_button", "%s_painted_pressure_plate", "%s_painted_trapdoor", "%s_painted_door", "%s_painted_fence_gate", "%s_painted_fence", "%s_painted_slab", "%s_painted_stairs", "%s_painted_planks", "stripped_%s_painted_wood", "stripped_%s_painted_log", "%s_painted_wood", "%s_painted_log"};
        String[] brickBlockTypes = new String[]{"painted_bricks", "painted_brick_stairs", "painted_brick_slab", "painted_brick_wall"};
        String[] brickBlockTypesR = new String[]{"painted_brick_wall", "painted_brick_slab", "painted_brick_stairs", "painted_bricks"};
        String[] brickMudBlockTypes = new String[]{"painted_mud_bricks", "painted_mud_brick_stairs", "painted_mud_brick_slab", "painted_mud_brick_wall"};
        String[] brickMudBlockTypesR = new String[]{"painted_mud_brick_wall", "painted_mud_brick_slab", "painted_mud_brick_stairs", "painted_mud_bricks"};
        if (event.getTabKey() == CreativeModeTabs.f_256725_) {
            String blockType;
            int n2;
            for (DyeColor dyeColor : customColorOrderR) {
                String colorName2 = dyeColor.m_41065_();
                String[] stringArray = woodBlockTypes;
                n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    blockType = stringArray[n];
                    formattedBlockType = String.format(blockType, colorName2);
                    ResourceLocation blockLocation3 = new ResourceLocation("paintable:" + formattedBlockType);
                    Block block2 = (Block)ForgeRegistries.BLOCKS.getValue(blockLocation3);
                    Paintable.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.f_50532_, new ItemLike[]{block2});
                }
            }
            for (DyeColor dyeColor : customColorOrder) {
                colorName = dyeColor.m_41065_();
                String[] stringArray = brickBlockTypes;
                n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    blockType = stringArray[n];
                    ResourceLocation blockLocation2 = new ResourceLocation("paintable:" + colorName + "_" + blockType);
                    block = (Block)ForgeRegistries.BLOCKS.getValue(blockLocation2);
                    Paintable.addBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.f_50058_, new ItemLike[]{block});
                }
            }
            for (DyeColor dyeColor : customColorOrder) {
                colorName = dyeColor.m_41065_();
                String[] stringArray = brickMudBlockTypes;
                n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    blockType = stringArray[n];
                    blockLocation = new ResourceLocation("paintable:" + colorName + "_" + blockType);
                    block = (Block)ForgeRegistries.BLOCKS.getValue(blockLocation);
                    Paintable.addBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.f_50058_, new ItemLike[]{block});
                }
            }
            Paintable.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.f_50463_, (ItemLike)ModBlocks.PAINT_BUCKET.get());
            for (DyeColor dyeColor : customColorOrderR) {
                colorName = dyeColor.m_41065_();
                ResourceLocation resourceLocation = new ResourceLocation("paintable:" + colorName + "_paint_bucket");
                Block block3 = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation);
                Paintable.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)ModBlocks.PAINT_BUCKET.get(), new ItemLike[]{block3});
            }
        }
        if (event.getTabKey() == CreativeModeTabs.f_256869_) {
            Paintable.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_271356_, (ItemLike)ModItems.PAINT_BRUSH.get());
            for (DyeColor dyeColor : customColorOrderR) {
                colorName = dyeColor.m_41065_();
                ResourceLocation resourceLocation = new ResourceLocation("paintable:" + colorName + "_paint_brush");
                Item item2 = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
                Paintable.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)ModItems.PAINT_BRUSH.get(), new ItemLike[]{item2});
            }
            String[] boatTypes = new String[]{"painted_chest_boat", "painted_boat"};
            for (DyeColor color : customColorOrderR) {
                String string = color.m_41065_();
                String[] item2 = boatTypes;
                n = item2.length;
                for (int blockType = 0; blockType < n; ++blockType) {
                    String boatType = item2[blockType];
                    itemLocation = new ResourceLocation("paintable:" + string + "_" + boatType);
                    item = (Item)ForgeRegistries.ITEMS.getValue(itemLocation);
                    Paintable.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_244260_, new ItemLike[]{item});
                }
            }
        }
        if (event.getTabKey() == CreativeModeTabs.f_256788_) {
            for (DyeColor dyeColor : customColorOrderR) {
                colorName = dyeColor.m_41065_();
                String[] stringArray = woodBlockTypes;
                int item2 = stringArray.length;
                for (n = 0; n < item2; ++n) {
                    String blockType = stringArray[n];
                    formattedBlockType = String.format(blockType, colorName);
                    ResourceLocation blockLocation2 = new ResourceLocation("paintable:" + formattedBlockType);
                    Block block2 = (Block)ForgeRegistries.BLOCKS.getValue(blockLocation2);
                    Paintable.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.f_50670_, new ItemLike[]{block2});
                }
            }
            for (DyeColor dyeColor : customColorOrderR) {
                colorName = dyeColor.m_41065_();
                String[] stringArray = brickBlockTypesR;
                int item2 = stringArray.length;
                for (n = 0; n < item2; ++n) {
                    String blockType = stringArray[n];
                    blockLocation = new ResourceLocation("paintable:" + colorName + "_" + blockType);
                    block = (Block)ForgeRegistries.BLOCKS.getValue(blockLocation);
                    Paintable.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.f_50604_, new ItemLike[]{block});
                }
            }
            for (DyeColor dyeColor : customColorOrderR) {
                colorName = dyeColor.m_41065_();
                for (String blockType : brickMudBlockTypesR) {
                    blockLocation = new ResourceLocation("paintable:" + colorName + "_" + blockType);
                    block = (Block)ForgeRegistries.BLOCKS.getValue(blockLocation);
                    Paintable.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.f_220854_, new ItemLike[]{block});
                }
            }
        }
        if (event.getTabKey() == CreativeModeTabs.f_256791_) {
            Paintable.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.f_50463_, (ItemLike)ModBlocks.PAINT_BUCKET.get());
            for (DyeColor dyeColor : customColorOrderR) {
                colorName = dyeColor.m_41065_();
                ResourceLocation resourceLocation = new ResourceLocation("paintable:" + colorName + "_paint_bucket");
                Block block4 = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation);
                Paintable.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)ModBlocks.PAINT_BUCKET.get(), new ItemLike[]{block4});
            }
            String[] blockTypes = new String[]{"painted_hanging_sign", "painted_sign"};
            for (DyeColor color : customColorOrderR) {
                String string = color.m_41065_();
                for (String blockType : blockTypes) {
                    itemLocation = new ResourceLocation("paintable:" + string + "_" + blockType);
                    item = (Item)ForgeRegistries.ITEMS.getValue(itemLocation);
                    Paintable.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_244637_, new ItemLike[]{item});
                }
            }
        }
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    public static Block getBlockFromString(String block) {
        return Paintable.getBlockFromString(MOD_ID, block);
    }

    public static Block getBlockFromString(String nameSpace, String block) {
        ResourceLocation blockLocation = new ResourceLocation(nameSpace, block);
        return (Block)ForgeRegistries.BLOCKS.getValue(blockLocation);
    }

    public static Item getItemFromString(String item) {
        return Paintable.getItemFromString(MOD_ID, item);
    }

    public static Item getItemFromString(String nameSpace, String item) {
        ResourceLocation itemLocation = new ResourceLocation(nameSpace, item);
        return (Item)ForgeRegistries.ITEMS.getValue(itemLocation);
    }

    public static ResourceLocation location(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    @Mod.EventBusSubscriber(modid="paintable", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
            for (DyeColor color : DyeColor.values()) {
                if (color.m_41060_() >= 16) continue;
                event.registerLayerDefinition(ModModelLayers.PAINTED_BOATS_LAYERS.get(color.m_41060_()), BoatModel::m_246613_);
                event.registerLayerDefinition(ModModelLayers.PAINTED_CHEST_BOATS_LAYERS.get(color.m_41060_()), ChestBoatModel::m_247175_);
            }
        }

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.BOAT.get()), pContext -> new ModBoatRenderer(pContext, false));
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.CHEST_BOAT.get()), pContext -> new ModBoatRenderer(pContext, true));
            for (DyeColor color : DyeColor.values()) {
                Sheets.addWoodType((WoodType)ModWoodTypes.PAINTED_WOOD_TYPES[color.m_41060_()]);
            }
        }
    }
}

