/*
 * Decompiled with CFR 0.152.
 */
package net.im_maker.paintable.common.block;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.im_maker.paintable.common.block.custom.FilledPaintBucketBlock;
import net.im_maker.paintable.common.block.custom.ModHangingSignBlock;
import net.im_maker.paintable.common.block.custom.ModStandingSignBlock;
import net.im_maker.paintable.common.block.custom.ModWallHangingSignBlock;
import net.im_maker.paintable.common.block.custom.ModWallSignBlock;
import net.im_maker.paintable.common.block.custom.PaintBucketBlock;
import net.im_maker.paintable.common.block.custom.StrippableRotatedPillarBlock;
import net.im_maker.paintable.common.item.ModItems;
import net.im_maker.paintable.common.util.ModWoodTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"paintable");
    public static final RegistryObject<Block> PAINT_BUCKET = ModBlocks.registryBlock("paint_bucket", () -> new PaintBucketBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(0.1f, 3.0f).m_60918_(SoundType.f_56762_)));
    public static final List<RegistryObject<Block>> FILLED_PAINT_BUCKET = ModBlocks.registerColoredBucketBlocks("paint_bucket");
    public static final List<RegistryObject<Block>> PAINTED_LOGS = ModBlocks.registerStrippableColoredLogs("painted_log");
    public static final List<RegistryObject<Block>> PAINTED_WOODS = ModBlocks.registerStrippableColoredLogs("painted_wood");
    public static final List<RegistryObject<Block>> PAINTED_STRIPPED_LOGS = ModBlocks.registerColoredLogs("painted_log");
    public static final List<RegistryObject<Block>> PAINTED_STRIPPED_WOODS = ModBlocks.registerColoredLogs("painted_wood");
    public static final List<RegistryObject<Block>> PAINTED_PLANKS = ModBlocks.registerColoredBlocks("painted_planks");
    public static final List<RegistryObject<Block>> PAINTED_STAIRS = ModBlocks.registerColoredStairs("painted_stairs");
    public static final List<RegistryObject<Block>> PAINTED_SLABS = ModBlocks.registerColoredSlabs("painted_slab");
    public static final List<RegistryObject<Block>> PAINTED_FENCES = ModBlocks.registerColoredFences("painted_fence");
    public static final List<RegistryObject<Block>> PAINTED_FENCE_GATES = ModBlocks.registerColoredFenceGates("painted_fence_gate");
    public static final List<RegistryObject<Block>> PAINTED_BUTTONS = ModBlocks.registerColoredButton("painted_button");
    public static final List<RegistryObject<Block>> PAINTED_PRESSURE_PLATES = ModBlocks.registerColoredPressurePlates("painted_pressure_plate");
    public static final List<RegistryObject<Block>> PAINTED_DOORS = ModBlocks.registerColoredDoors("painted_door");
    public static final List<RegistryObject<Block>> PAINTED_TRAPDOORS = ModBlocks.registerColoredTrapdoors("painted_trapdoor");
    public static final List<RegistryObject<Block>> PAINTED_SIGN = ModBlocks.registerColoredSigns("painted_sign");
    public static final List<RegistryObject<Block>> PAINTED_WALL_SIGN = ModBlocks.registerColoredWallSigns("painted_wall_sign");
    public static final List<RegistryObject<Block>> PAINTED_HANGING_SIGN = ModBlocks.registerColoredHangingSigns("painted_hanging_sign");
    public static final List<RegistryObject<Block>> PAINTED_WALL_HANGING_SIGN = ModBlocks.registerColoredWallHangingSigns("painted_wall_hanging_sign");
    public static final List<RegistryObject<Block>> PAINTED_BRICKS = ModBlocks.registerColoredBricks("painted_bricks", 2.0f, 6.0f, SoundType.f_56742_);
    public static final List<RegistryObject<Block>> PAINTED_BRICK_STAIRS = ModBlocks.registerColoredBrickStairs("painted_brick_stairs", 2.0f, 6.0f, SoundType.f_56742_);
    public static final List<RegistryObject<Block>> PAINTED_BRICK_SLABS = ModBlocks.registerColoredBrickSlabs("painted_brick_slab", 2.0f, 6.0f, SoundType.f_56742_);
    public static final List<RegistryObject<Block>> PAINTED_BRICK_WALL = ModBlocks.registerColoredBrickWalls("painted_brick_wall", PAINTED_BRICKS);
    public static final List<RegistryObject<Block>> PAINTED_MUD_BRICKS = ModBlocks.registerColoredBricks("painted_mud_bricks", 1.0f, 3.0f, SoundType.f_222470_);
    public static final List<RegistryObject<Block>> PAINTED_MUD_BRICK_STAIRS = ModBlocks.registerColoredBrickStairs("painted_mud_brick_stairs", 1.0f, 3.0f, SoundType.f_222470_);
    public static final List<RegistryObject<Block>> PAINTED_MUD_BRICK_SLABS = ModBlocks.registerColoredBrickSlabs("painted_mud_brick_slab", 1.0f, 3.0f, SoundType.f_222470_);
    public static final List<RegistryObject<Block>> PAINTED_MUD_BRICK_WALL = ModBlocks.registerColoredBrickWalls("painted_mud_brick_wall", PAINTED_MUD_BRICKS);

    private static <T extends Block> List<RegistryObject<T>> registerColoredBucketBlocks(String blockName) {
        ArrayList<RegistryObject<T>> coloredBlocks = new ArrayList<RegistryObject<T>>();
        for (DyeColor color : DyeColor.values()) {
            String blockId = color.m_41065_() + "_" + blockName;
            RegistryObject block = BLOCKS.register(blockId, () -> new FilledPaintBucketBlock(BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60913_(0.1f, 4.0f).m_60918_(SoundType.f_56762_)));
            ModBlocks.registerBlockItem(blockId, block);
            coloredBlocks.add(block);
        }
        return coloredBlocks;
    }

    private static <T extends Block> List<RegistryObject<T>> registerColoredBlocks(String blockName) {
        ArrayList<RegistryObject<T>> coloredBlocks = new ArrayList<RegistryObject<T>>();
        for (DyeColor color : DyeColor.values()) {
            String blockId = color.m_41065_() + "_" + blockName;
            RegistryObject block = BLOCKS.register(blockId, () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)));
            ModBlocks.registerBlockItem(blockId, block);
            coloredBlocks.add(block);
        }
        return coloredBlocks;
    }

    private static <T extends Block> List<RegistryObject<T>> registerColoredStairs(String blockName) {
        ArrayList<RegistryObject<T>> coloredBlocks = new ArrayList<RegistryObject<T>>();
        for (DyeColor color : DyeColor.values()) {
            String blockId = color.m_41065_() + "_" + blockName;
            ResourceLocation paintedPlanksLocation = new ResourceLocation("paintable:" + color + "_painted_planks");
            Block paintedPlanks = (Block)ForgeRegistries.BLOCKS.getValue(paintedPlanksLocation);
            RegistryObject block = BLOCKS.register(blockId, () -> new StairBlock(() -> paintedPlanks.m_49966_(), BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)));
            ModBlocks.registerBlockItem(blockId, block);
            coloredBlocks.add(block);
        }
        return coloredBlocks;
    }

    private static <T extends Block> List<RegistryObject<T>> registerColoredSlabs(String blockName) {
        ArrayList<RegistryObject<T>> coloredBlocks = new ArrayList<RegistryObject<T>>();
        for (DyeColor color : DyeColor.values()) {
            String blockId = color.m_41065_() + "_" + blockName;
            RegistryObject block = BLOCKS.register(blockId, () -> new SlabBlock(BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)));
            ModBlocks.registerBlockItem(blockId, block);
            coloredBlocks.add(block);
        }
        return coloredBlocks;
    }

    private static <T extends Block> List<RegistryObject<T>> registerColoredFences(String blockName) {
        ArrayList<RegistryObject<T>> coloredBlocks = new ArrayList<RegistryObject<T>>();
        for (DyeColor color : DyeColor.values()) {
            String blockId = color.m_41065_() + "_" + blockName;
            RegistryObject block = BLOCKS.register(blockId, () -> new FenceBlock(BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)));
            ModBlocks.registerBlockItem(blockId, block);
            coloredBlocks.add(block);
        }
        return coloredBlocks;
    }

    private static <T extends Block> List<RegistryObject<T>> registerColoredFenceGates(String blockName) {
        ArrayList<RegistryObject<T>> coloredBlocks = new ArrayList<RegistryObject<T>>();
        for (DyeColor color : DyeColor.values()) {
            String blockId = color.m_41065_() + "_" + blockName;
            RegistryObject block = BLOCKS.register(blockId, () -> new FenceGateBlock(BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_280606_().m_280658_(NoteBlockInstrument.BASS).m_60913_(2.0f, 3.0f).m_278183_(), ModWoodTypes.PAINTED_WOOD_TYPES[color.m_41060_()]));
            ModBlocks.registerBlockItem(blockId, block);
            coloredBlocks.add(block);
        }
        return coloredBlocks;
    }

    private static <T extends Block> List<RegistryObject<T>> registerColoredButton(String blockName) {
        ArrayList<RegistryObject<T>> coloredBlocks = new ArrayList<RegistryObject<T>>();
        for (DyeColor color : DyeColor.values()) {
            String blockId = color.m_41065_() + "_" + blockName;
            RegistryObject block = BLOCKS.register(blockId, () -> new ButtonBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50251_).m_60918_(SoundType.f_56736_), ModWoodTypes.PAINTED_WOOD_TYPES[color.m_41060_()].f_271340_(), 10, true));
            ModBlocks.registerBlockItem(blockId, block);
            coloredBlocks.add(block);
        }
        return coloredBlocks;
    }

    private static <T extends Block> List<RegistryObject<T>> registerColoredPressurePlates(String blockName) {
        ArrayList<RegistryObject<T>> coloredBlocks = new ArrayList<RegistryObject<T>>();
        for (DyeColor color : DyeColor.values()) {
            String blockId = color.m_41065_() + "_" + blockName;
            RegistryObject block = BLOCKS.register(blockId, () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_280606_().m_280658_(NoteBlockInstrument.BASS).m_60910_().m_60978_(0.5f).m_278183_().m_278166_(PushReaction.DESTROY), ModWoodTypes.PAINTED_WOOD_TYPES[color.m_41060_()].f_271340_()));
            ModBlocks.registerBlockItem(blockId, block);
            coloredBlocks.add(block);
        }
        return coloredBlocks;
    }

    private static <T extends Block> List<RegistryObject<T>> registerColoredDoors(String blockName) {
        ArrayList<RegistryObject<T>> coloredBlocks = new ArrayList<RegistryObject<T>>();
        for (DyeColor color : DyeColor.values()) {
            String blockId = color.m_41065_() + "_" + blockName;
            RegistryObject block = BLOCKS.register(blockId, () -> new DoorBlock(BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_280658_(NoteBlockInstrument.BASS).m_60978_(3.0f).m_60955_().m_278183_().m_278166_(PushReaction.DESTROY), ModWoodTypes.PAINTED_WOOD_TYPES[color.m_41060_()].f_271340_()));
            ModBlocks.registerBlockItem(blockId, block);
            coloredBlocks.add(block);
        }
        return coloredBlocks;
    }

    private static <T extends Block> List<RegistryObject<T>> registerColoredTrapdoors(String blockName) {
        ArrayList<RegistryObject<T>> coloredBlocks = new ArrayList<RegistryObject<T>>();
        for (DyeColor color : DyeColor.values()) {
            String blockId = color.m_41065_() + "_" + blockName;
            RegistryObject block = BLOCKS.register(blockId, () -> new TrapDoorBlock(BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_280658_(NoteBlockInstrument.BASS).m_60978_(3.0f).m_60955_().m_60922_(ModBlocks::never).m_278183_(), ModWoodTypes.PAINTED_WOOD_TYPES[color.m_41060_()].f_271340_()));
            ModBlocks.registerBlockItem(blockId, block);
            coloredBlocks.add(block);
        }
        return coloredBlocks;
    }

    private static <T extends Block> List<RegistryObject<T>> registerColoredBricks(String blockName, float DT, float ET, SoundType soundType) {
        ArrayList<RegistryObject<T>> coloredBlocks = new ArrayList<RegistryObject<T>>();
        for (DyeColor color : DyeColor.values()) {
            String blockId = color.m_41065_() + "_" + blockName;
            RegistryObject block = BLOCKS.register(blockId, () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_280658_(NoteBlockInstrument.BASEDRUM).m_60913_(DT, ET).m_60918_(soundType).m_60999_()));
            ModBlocks.registerBlockItem(blockId, block);
            coloredBlocks.add(block);
        }
        return coloredBlocks;
    }

    private static <T extends Block> List<RegistryObject<T>> registerColoredBrickStairs(String blockName, float DT, float ET, SoundType soundType) {
        ArrayList<RegistryObject<T>> coloredBlocks = new ArrayList<RegistryObject<T>>();
        for (DyeColor color : DyeColor.values()) {
            String blockId = color.m_41065_() + "_" + blockName;
            ResourceLocation paintedBricksLocation = new ResourceLocation("paintable:" + color + "_painted_bricks");
            Block paintedBricks = (Block)ForgeRegistries.BLOCKS.getValue(paintedBricksLocation);
            RegistryObject block = BLOCKS.register(blockId, () -> new StairBlock(() -> paintedBricks.m_49966_(), BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_280658_(NoteBlockInstrument.BASEDRUM).m_60913_(DT, ET).m_60918_(soundType).m_60999_()));
            ModBlocks.registerBlockItem(blockId, block);
            coloredBlocks.add(block);
        }
        return coloredBlocks;
    }

    private static <T extends Block> List<RegistryObject<T>> registerColoredBrickSlabs(String blockName, float DT, float ET, SoundType soundType) {
        ArrayList<RegistryObject<T>> coloredBlocks = new ArrayList<RegistryObject<T>>();
        for (DyeColor color : DyeColor.values()) {
            String blockId = color.m_41065_() + "_" + blockName;
            RegistryObject block = BLOCKS.register(blockId, () -> new SlabBlock(BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_280658_(NoteBlockInstrument.BASEDRUM).m_60913_(DT, ET).m_60918_(soundType).m_60999_()));
            ModBlocks.registerBlockItem(blockId, block);
            coloredBlocks.add(block);
        }
        return coloredBlocks;
    }

    private static <T extends Block> List<RegistryObject<T>> registerColoredBrickWalls(String blockName, List<RegistryObject<Block>> copyBlock) {
        ArrayList<RegistryObject<T>> coloredBlocks = new ArrayList<RegistryObject<T>>();
        for (DyeColor color : DyeColor.values()) {
            String blockId = color.m_41065_() + "_" + blockName;
            RegistryObject block = BLOCKS.register(blockId, () -> new WallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)((RegistryObject)copyBlock.get(color.m_41060_())).get())).m_280606_()));
            ModBlocks.registerBlockItem(blockId, block);
            coloredBlocks.add(block);
        }
        return coloredBlocks;
    }

    private static <T extends Block> List<RegistryObject<T>> registerStrippableColoredLogs(String blockName) {
        ArrayList<RegistryObject<T>> coloredBlocks = new ArrayList<RegistryObject<T>>();
        for (DyeColor color : DyeColor.values()) {
            String blockId = color.m_41065_() + "_" + blockName;
            RegistryObject block = BLOCKS.register(blockId, () -> new StrippableRotatedPillarBlock(color, BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60913_(2.0f, 2.0f).m_60918_(SoundType.f_56736_)));
            ModBlocks.registerBlockItem(blockId, block);
            coloredBlocks.add(block);
        }
        return coloredBlocks;
    }

    private static <T extends Block> List<RegistryObject<T>> registerColoredLogs(String blockName) {
        ArrayList<RegistryObject<T>> coloredBlocks = new ArrayList<RegistryObject<T>>();
        for (DyeColor color : DyeColor.values()) {
            String blockId = "stripped_" + color.m_41065_() + "_" + blockName;
            RegistryObject block = BLOCKS.register(blockId, () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60913_(2.0f, 2.0f).m_60918_(SoundType.f_56736_)));
            ModBlocks.registerBlockItem(blockId, block);
            coloredBlocks.add(block);
        }
        return coloredBlocks;
    }

    private static <T extends Block> List<RegistryObject<T>> registerColoredSigns(String blockName) {
        ArrayList<RegistryObject<T>> coloredBlocks = new ArrayList<RegistryObject<T>>();
        for (DyeColor color : DyeColor.values()) {
            String blockId = color.m_41065_() + "_" + blockName;
            RegistryObject block = BLOCKS.register(blockId, () -> new ModStandingSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50095_), ModWoodTypes.PAINTED_WOOD_TYPES[color.m_41060_()]));
            coloredBlocks.add(block);
        }
        return coloredBlocks;
    }

    private static <T extends Block> List<RegistryObject<T>> registerColoredWallSigns(String blockName) {
        ArrayList<RegistryObject<T>> coloredBlocks = new ArrayList<RegistryObject<T>>();
        for (DyeColor color : DyeColor.values()) {
            String blockId = color.m_41065_() + "_" + blockName;
            RegistryObject block = BLOCKS.register(blockId, () -> new ModWallSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50158_), ModWoodTypes.PAINTED_WOOD_TYPES[color.m_41060_()]));
            coloredBlocks.add(block);
        }
        return coloredBlocks;
    }

    private static <T extends Block> List<RegistryObject<T>> registerColoredHangingSigns(String blockName) {
        ArrayList<RegistryObject<T>> coloredBlocks = new ArrayList<RegistryObject<T>>();
        for (DyeColor color : DyeColor.values()) {
            String blockId = color.m_41065_() + "_" + blockName;
            RegistryObject block = BLOCKS.register(blockId, () -> new ModHangingSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_244319_), ModWoodTypes.PAINTED_WOOD_TYPES[color.m_41060_()]));
            coloredBlocks.add(block);
        }
        return coloredBlocks;
    }

    private static <T extends Block> List<RegistryObject<T>> registerColoredWallHangingSigns(String blockName) {
        ArrayList<RegistryObject<T>> coloredBlocks = new ArrayList<RegistryObject<T>>();
        for (DyeColor color : DyeColor.values()) {
            String blockId = color.m_41065_() + "_" + blockName;
            RegistryObject block = BLOCKS.register(blockId, () -> new ModWallHangingSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_244093_), ModWoodTypes.PAINTED_WOOD_TYPES[color.m_41060_()]));
            coloredBlocks.add(block);
        }
        return coloredBlocks;
    }

    private static <T extends Block> RegistryObject<T> registryBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    private static ButtonBlock woodenButton(BlockSetType pSetType, FeatureFlag ... pRequiredFeatures) {
        BlockBehaviour.Properties blockbehaviour$properties = BlockBehaviour.Properties.m_284310_().m_60910_().m_60978_(0.5f).m_278166_(PushReaction.DESTROY);
        if (pRequiredFeatures.length > 0) {
            blockbehaviour$properties = blockbehaviour$properties.m_246843_(pRequiredFeatures);
        }
        return new ButtonBlock(blockbehaviour$properties, pSetType, 30, true);
    }

    private static Boolean never(BlockState p_50779_, BlockGetter p_50780_, BlockPos p_50781_, EntityType<?> p_50782_) {
        return false;
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

