/*
 * Decompiled with CFR 0.152.
 */
package net.im_maker.paintable.common.block.entity;

import net.im_maker.paintable.common.block.entity.custom.ModHangingSignBlockEntity;
import net.im_maker.paintable.common.block.entity.custom.ModSignBlockEntity;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlockEntities {
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"paintable");
    public static final RegistryObject<BlockEntityType<ModSignBlockEntity>> SIGN_BLOCK_ENTITIES = BLOCK_ENTITIES.register("sign_block_entity", () -> BlockEntityType.Builder.m_155273_(ModSignBlockEntity::new, (Block[])ModBlockEntities.getAllSignBlocks()).m_58966_(null));
    public static final RegistryObject<BlockEntityType<ModHangingSignBlockEntity>> HANGING_SIGN_BLOCK_ENTITIES = BLOCK_ENTITIES.register("hanging_sign_block_entity", () -> BlockEntityType.Builder.m_155273_(ModHangingSignBlockEntity::new, (Block[])ModBlockEntities.getAllHangingSignBlocks()).m_58966_(null));

    private static Block[] getAllSignBlocks() {
        Block[] signBlocks = new Block[DyeColor.values().length * 2];
        int index = 0;
        for (DyeColor color : DyeColor.values()) {
            String colorName = color.m_41065_();
            ResourceLocation paintedSignLocation = new ResourceLocation("paintable:" + colorName + "_painted_sign");
            ResourceLocation paintedWallSignLocation = new ResourceLocation("paintable:" + colorName + "_painted_wall_sign");
            Block paintedSign = (Block)ForgeRegistries.BLOCKS.getValue(paintedSignLocation);
            Block paintedWallSign = (Block)ForgeRegistries.BLOCKS.getValue(paintedWallSignLocation);
            signBlocks[index++] = paintedSign;
            signBlocks[index++] = paintedWallSign;
        }
        return signBlocks;
    }

    private static Block[] getAllHangingSignBlocks() {
        Block[] signBlocks = new Block[DyeColor.values().length * 2];
        int index = 0;
        for (DyeColor color : DyeColor.values()) {
            String colorName = color.m_41065_();
            ResourceLocation paintedSignLocation = new ResourceLocation("paintable:" + colorName + "_painted_hanging_sign");
            ResourceLocation paintedWallSignLocation = new ResourceLocation("paintable:" + colorName + "_painted_wall_hanging_sign");
            Block paintedSign = (Block)ForgeRegistries.BLOCKS.getValue(paintedSignLocation);
            Block paintedWallSign = (Block)ForgeRegistries.BLOCKS.getValue(paintedWallSignLocation);
            signBlocks[index++] = paintedSign;
            signBlocks[index++] = paintedWallSign;
        }
        return signBlocks;
    }

    public static void register(IEventBus eventBus) {
        BLOCK_ENTITIES.register(eventBus);
    }
}

