/*
 * Decompiled with CFR 0.152.
 */
package net.im_maker.paintable.common.item;

import java.util.ArrayList;
import java.util.List;
import net.im_maker.paintable.common.block.ModBlocks;
import net.im_maker.paintable.common.entity.custom.ModBoatEntity;
import net.im_maker.paintable.common.item.custom.DippedPaintBrushItem;
import net.im_maker.paintable.common.item.custom.ModBoatItem;
import net.im_maker.paintable.common.item.custom.PaintBrushItem;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"paintable");
    public static final RegistryObject<Item> PAINT_BRUSH = ITEMS.register("paint_brush", () -> new PaintBrushItem(new Item.Properties().m_41487_(1)));
    public static final List<RegistryObject<Item>> DIPPED_PAINT_BRUSH = ModItems.registerColoredPaintBrushes();
    public static final List<RegistryObject<Item>> PAINTED_SIGNS = ModItems.registerColoredSigns();
    public static final List<RegistryObject<Item>> PAINTED_HANGING_SIGNS = ModItems.registerColoredHangingSigns();
    public static final List<RegistryObject<Item>> PAINTED_BOATS = ModItems.registerColoredBoat();
    public static final List<RegistryObject<Item>> PAINTED_CHEST_BOATS = ModItems.registerColoredChestBoat();

    private static <T extends Item> List<RegistryObject<T>> registerColoredPaintBrushes() {
        ArrayList<RegistryObject<T>> coloredItems = new ArrayList<RegistryObject<T>>();
        for (DyeColor color : DyeColor.values()) {
            String itemID = color.m_41065_() + "_paint_brush";
            RegistryObject item = ITEMS.register(itemID, () -> new DippedPaintBrushItem(color, new Item.Properties().m_41487_(1).m_41503_(16)));
            coloredItems.add(item);
        }
        return coloredItems;
    }

    private static <T extends Item> List<RegistryObject<T>> registerColoredSigns() {
        ArrayList<RegistryObject<T>> coloredItems = new ArrayList<RegistryObject<T>>();
        for (DyeColor color : DyeColor.values()) {
            String itemID = color.m_41065_() + "_painted_sign";
            ResourceLocation paintedSignLocation = new ResourceLocation("paintable", color.m_41065_() + "_painted_sign");
            Block paintedSign = (Block)ForgeRegistries.BLOCKS.getValue(paintedSignLocation);
            ResourceLocation paintedWallSignLocation = new ResourceLocation("paintable", color.m_41065_() + "_painted_wall_sign");
            Block paintedWallSign = (Block)ForgeRegistries.BLOCKS.getValue(paintedWallSignLocation);
            RegistryObject item = ITEMS.register(itemID, () -> new SignItem(new Item.Properties().m_41487_(16), (Block)ModBlocks.PAINTED_SIGN.get(color.m_41060_()).get(), (Block)ModBlocks.PAINTED_WALL_SIGN.get(color.m_41060_()).get()));
            coloredItems.add(item);
        }
        return coloredItems;
    }

    private static <T extends Item> List<RegistryObject<T>> registerColoredHangingSigns() {
        ArrayList<RegistryObject<T>> coloredItems = new ArrayList<RegistryObject<T>>();
        for (DyeColor color : DyeColor.values()) {
            String itemID = color.m_41065_() + "_painted_hanging_sign";
            ResourceLocation paintedHangingSignLocation = new ResourceLocation("paintable", color.m_41065_() + "_painted_hanging_sign");
            Block paintedHangingSign = (Block)ForgeRegistries.BLOCKS.getValue(paintedHangingSignLocation);
            ResourceLocation paintedWallHangingSignLocation = new ResourceLocation("paintable", color.m_41065_() + "_painted_wall_hanging_sign");
            Block paintedWallHangingSign = (Block)ForgeRegistries.BLOCKS.getValue(paintedWallHangingSignLocation);
            RegistryObject item = ITEMS.register(itemID, () -> new HangingSignItem((Block)ModBlocks.PAINTED_HANGING_SIGN.get(color.m_41060_()).get(), (Block)ModBlocks.PAINTED_WALL_HANGING_SIGN.get(color.m_41060_()).get(), new Item.Properties().m_41487_(16)));
            coloredItems.add(item);
        }
        return coloredItems;
    }

    private static <T extends Item> List<RegistryObject<T>> registerColoredBoat() {
        ArrayList<RegistryObject<T>> coloredItems = new ArrayList<RegistryObject<T>>();
        for (DyeColor color : DyeColor.values()) {
            String itemID = color.m_41065_() + "_painted_boat";
            RegistryObject item = color.m_41060_() < 16 ? ITEMS.register(itemID, () -> new ModBoatItem(false, ModBoatEntity.Type.byId(color.m_41060_()), new Item.Properties())) : ITEMS.register(itemID, () -> new Item(new Item.Properties()));
            coloredItems.add(item);
        }
        return coloredItems;
    }

    private static <T extends Item> List<RegistryObject<T>> registerColoredChestBoat() {
        ArrayList<RegistryObject<T>> coloredItems = new ArrayList<RegistryObject<T>>();
        for (DyeColor color : DyeColor.values()) {
            String itemID = color.m_41065_() + "_painted_chest_boat";
            RegistryObject item = color.m_41060_() < 16 ? ITEMS.register(itemID, () -> new ModBoatItem(true, ModBoatEntity.Type.byId(color.m_41060_()), new Item.Properties())) : ITEMS.register(itemID, () -> new Item(new Item.Properties()));
            coloredItems.add(item);
        }
        return coloredItems;
    }

    public static void register(IEventBus eventBus) {
        ITEMS.register(eventBus);
    }
}

