/*
 * Decompiled with CFR 0.152.
 */
package net.im_maker.paintable.common.item.custom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.im_maker.paintable.Paintable;
import net.im_maker.paintable.common.item.ModItems;
import net.im_maker.paintable.common.tags.ModBlockTags;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.HangingSignBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.registries.ForgeRegistries;

public class DippedPaintBrushItem
extends Item {
    private final DyeColor color;
    private final List<DyeColor> customColorOrder = new ArrayList<DyeColor>(Arrays.asList(DyeColor.WHITE, DyeColor.LIGHT_GRAY, DyeColor.GRAY, DyeColor.BLACK, DyeColor.BROWN, DyeColor.RED, DyeColor.ORANGE, DyeColor.YELLOW, DyeColor.LIME, DyeColor.GREEN, DyeColor.CYAN, DyeColor.LIGHT_BLUE, DyeColor.BLUE, DyeColor.PURPLE, DyeColor.MAGENTA, DyeColor.PINK));

    public DippedPaintBrushItem(DyeColor paintColor, Item.Properties properties) {
        super(properties);
        this.color = paintColor;
        this.customColorOrder.addAll(Arrays.asList(DyeColor.values()));
    }

    public boolean m_41470_() {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        ItemStack itemStack = new ItemStack((ItemLike)this);
        itemStack.m_41721_(stack.m_41773_() + 1);
        if (itemStack.m_41773_() >= itemStack.m_41776_()) {
            return new ItemStack((ItemLike)ModItems.PAINT_BRUSH.get());
        }
        return itemStack;
    }

    public boolean isRepairable(ItemStack itemstack) {
        return false;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    private void paint(String blockName, ItemStack itemStack, Player player, UseOnContext context, Level world, BlockPos blockPos, BlockState blockState) {
        this.paint(blockName, itemStack, player, context, world, blockPos, blockState, true);
    }

    private void paint(String blockName, ItemStack itemStack, Player player, UseOnContext context, Level world, BlockPos blockPos, BlockState blockState, Boolean i) {
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.f_10562_.m_285767_((ServerPlayer)player, blockPos, itemStack);
        }
        if (itemStack.m_41773_() != 15) {
            if (player != null) {
                itemStack.m_41622_(1, (LivingEntity)player, player1 -> player1.m_21190_(context.m_43724_()));
            }
        } else {
            context.m_43723_().m_21008_(context.m_43724_(), new ItemStack((ItemLike)ModItems.PAINT_BRUSH.get()));
            world.m_5594_((Player)null, blockPos, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (i.booleanValue()) {
            ResourceLocation blockLocation = blockName.contains("%s") ? new ResourceLocation("paintable:" + String.format(blockName, this.color + "_painted_")) : new ResourceLocation("paintable:" + this.color + "_painted_" + blockName);
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(blockLocation);
            if (!blockState.m_155947_()) {
                world.m_46597_(blockPos, block.m_152465_(blockState));
            } else {
                BlockEntity blockE = null;
                BlockEntity blockEntity = world.m_7702_(blockPos);
                CompoundTag data = null;
                if (blockEntity instanceof SignBlockEntity) {
                    SignBlockEntity SignBlock = (SignBlockEntity)blockEntity;
                    data = SignBlock.serializeNBT();
                    blockE = BlockEntity.m_155241_((BlockPos)blockPos, (BlockState)block.m_49966_(), (CompoundTag)data);
                } else if (blockEntity instanceof HangingSignBlockEntity) {
                    HangingSignBlockEntity HangingSignBlock = (HangingSignBlockEntity)blockEntity;
                    data = HangingSignBlock.serializeNBT();
                    blockE = BlockEntity.m_155241_((BlockPos)blockPos, (BlockState)block.m_49966_(), (CompoundTag)data);
                }
                if (blockE != null) {
                    world.m_46597_(blockPos, blockE.m_58900_().m_60734_().m_152465_(blockEntity.m_58900_()));
                    blockEntity = world.m_7702_(blockPos);
                    blockEntity.deserializeNBT(data);
                }
            }
            world.m_5594_((Player)null, blockPos, SoundEvents.f_215708_, SoundSource.BLOCKS, 1.0f, 1.0f);
        } else {
            for (IModInfo mod : ModList.get().getMods()) {
                Block block = Paintable.getBlockFromString(mod.getModId(), this.color + "_" + blockName);
                System.out.println(mod.getModId() + this.color);
                if (block == null || block == Blocks.f_50016_) continue;
                world.m_46597_(blockPos, block.m_152465_(blockState));
                System.out.println(mod.getModId() + this.color);
                world.m_5594_((Player)null, blockPos, SoundEvents.f_215708_, SoundSource.BLOCKS, 1.0f, 1.0f);
                break;
            }
        }
    }

    private Boolean canPaint(String block) {
        return block.contains(":" + this.color + "_") || block.contains("stripped_" + this.color + "_");
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos blockPos = context.m_8083_();
        BlockState blockState = world.m_8055_(blockPos);
        ItemStack itemStack = context.m_43722_();
        Player player = context.m_43723_();
        InteractionResult pass = InteractionResult.PASS;
        InteractionResult success = InteractionResult.m_19078_((boolean)world.f_46443_);
        String blockID = ForgeRegistries.BLOCKS.getKey((Object)blockState.m_60734_()).toString();
        if (this.canPaint(blockID).booleanValue()) {
            return pass;
        }
        if (blockState.m_204336_(BlockTags.f_13090_)) {
            this.paint("planks", itemStack, player, context, world, blockPos, blockState);
            return success;
        }
        if (blockState.m_204336_(BlockTags.f_13096_)) {
            this.paint("stairs", itemStack, player, context, world, blockPos, blockState);
            return success;
        }
        if (blockState.m_204336_(BlockTags.f_13097_)) {
            this.paint("slab", itemStack, player, context, world, blockPos, blockState);
            return success;
        }
        if (blockState.m_204336_(BlockTags.f_13098_)) {
            this.paint("fence", itemStack, player, context, world, blockPos, blockState);
            return success;
        }
        if (blockState.m_204336_(Tags.Blocks.FENCE_GATES_WOODEN)) {
            this.paint("fence_gate", itemStack, player, context, world, blockPos, blockState);
            return success;
        }
        if (blockState.m_204336_(BlockTags.f_13092_)) {
            this.paint("button", itemStack, player, context, world, blockPos, blockState);
            return success;
        }
        if (blockState.m_204336_(BlockTags.f_13100_)) {
            this.paint("pressure_plate", itemStack, player, context, world, blockPos, blockState);
            return success;
        }
        if (blockState.m_204336_(BlockTags.f_13066_)) {
            this.paint("sign", itemStack, player, context, world, blockPos, blockState);
            return success;
        }
        if (blockState.m_204336_(BlockTags.f_13067_)) {
            this.paint("wall_sign", itemStack, player, context, world, blockPos, blockState);
            return success;
        }
        if (blockState.m_204336_(BlockTags.f_243838_)) {
            this.paint("hanging_sign", itemStack, player, context, world, blockPos, blockState);
            return success;
        }
        if (blockState.m_204336_(BlockTags.f_244544_)) {
            this.paint("wall_hanging_sign", itemStack, player, context, world, blockPos, blockState);
            return success;
        }
        if (blockState.m_204336_(ModBlockTags.PAINTABLE_BRICKS)) {
            this.paint("bricks", itemStack, player, context, world, blockPos, blockState);
            return success;
        }
        if (blockState.m_204336_(ModBlockTags.PAINTABLE_BRICK_STAIRS)) {
            this.paint("brick_stairs", itemStack, player, context, world, blockPos, blockState);
            return success;
        }
        if (blockState.m_204336_(ModBlockTags.PAINTABLE_BRICK_SLABS)) {
            this.paint("brick_slab", itemStack, player, context, world, blockPos, blockState);
            return success;
        }
        if (blockState.m_204336_(ModBlockTags.PAINTABLE_BRICK_WALLS)) {
            this.paint("brick_wall", itemStack, player, context, world, blockPos, blockState);
            return success;
        }
        if (blockState.m_204336_(ModBlockTags.PAINTABLE_MUD_BRICKS)) {
            this.paint("mud_bricks", itemStack, player, context, world, blockPos, blockState);
            return success;
        }
        if (blockState.m_204336_(ModBlockTags.PAINTABLE_MUD_BRICK_STAIRS)) {
            this.paint("mud_brick_stairs", itemStack, player, context, world, blockPos, blockState);
            return success;
        }
        if (blockState.m_204336_(ModBlockTags.PAINTABLE_MUD_BRICK_SLABS)) {
            this.paint("mud_brick_slab", itemStack, player, context, world, blockPos, blockState);
            return success;
        }
        if (blockState.m_204336_(ModBlockTags.PAINTABLE_MUD_BRICK_WALLS)) {
            this.paint("mud_brick_wall", itemStack, player, context, world, blockPos, blockState);
            return success;
        }
        if (blockState.m_204336_(BlockTags.f_13106_) && !blockID.contains("stripped") && blockID.contains("log")) {
            this.paint("log", itemStack, player, context, world, blockPos, blockState);
            return success;
        }
        if (blockState.m_204336_(BlockTags.f_13106_) && !blockID.contains("stripped") && blockID.contains("wood")) {
            this.paint("wood", itemStack, player, context, world, blockPos, blockState);
            return success;
        }
        if (blockState.m_204336_(BlockTags.f_13106_) && blockID.contains("stripped") && (blockID.contains("log") || blockID.contains("stem"))) {
            this.paint("stripped_%slog", itemStack, player, context, world, blockPos, blockState);
            return success;
        }
        if (blockState.m_204336_(BlockTags.f_13106_) && blockID.contains("stripped") && (blockID.contains("wood") || blockID.contains("hyphae"))) {
            this.paint("stripped_%swood", itemStack, player, context, world, blockPos, blockState);
            return success;
        }
        if (blockState.m_204336_(ModBlockTags.PAINTABLE_CONCRETE_VANILLA) || blockState.m_204336_(ModBlockTags.PAINTABLE_CONCRETE)) {
            this.paint("concrete", itemStack, player, context, world, blockPos, blockState, false);
            return success;
        }
        return pass;
    }
}

