/*
 * Decompiled with CFR 0.152.
 */
package net.im_maker.paintable.datagen;

import java.util.ArrayList;
import java.util.Arrays;
import net.im_maker.paintable.Paintable;
import net.im_maker.paintable.common.block.ModBlocks;
import net.im_maker.paintable.common.block.custom.FilledPaintBucketBlock;
import net.im_maker.paintable.common.block.custom.PaintBucketBlock;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "paintable", exFileHelper);
    }

    private Block block(DyeColor color, String block) {
        ResourceLocation blockLocation = new ResourceLocation("paintable", color + "_painted_" + block);
        return (Block)ForgeRegistries.BLOCKS.getValue(blockLocation);
    }

    private ResourceLocation blockR(DyeColor color, String block) {
        return new ResourceLocation("paintable", "block/" + color + "_painted_" + block);
    }

    private RegistryObject<Block> blockO(DyeColor color, String block) {
        ResourceLocation blockLocation = new ResourceLocation("paintable", color + "_painted_" + block);
        return RegistryObject.create((ResourceLocation)blockLocation, (IForgeRegistry)ForgeRegistries.BLOCKS);
    }

    private Block blockOSSS(DyeColor color, String block) {
        ResourceLocation blockLocation = new ResourceLocation("paintable", "stripped_" + color + "_painted_" + block);
        return (Block)ForgeRegistries.BLOCKS.getValue(blockLocation);
    }

    private void strippedLogBlock(RotatedPillarBlock block, RotatedPillarBlock baseName) {
        this.axisBlock(block, this.blockTexture((Block)baseName), this.blockTexture((Block)baseName));
    }

    private void filledPaintBucketBlock(Block b, String texture) {
        ResourceLocation paint_bucket = new ResourceLocation("paintable", "block/" + texture);
        for (int i = 0; i <= 4; ++i) {
            String num = String.valueOf(i);
            Object p = "";
            if (i != 0) {
                p = "_level" + num;
            }
            ConfiguredModel eModel = ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("paint_bucket/level" + num + "/" + this.name(b) + "_level" + num, new ResourceLocation("paintable", "block/template_paint_bucket" + (String)p))).texture("paint_bucket", paint_bucket)).renderType("cutout")).buildLast();
            ConfiguredModel nModel = ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("paint_bucket/level" + num + "/" + this.name(b) + "_level" + num, new ResourceLocation("paintable", "block/template_paint_bucket" + (String)p))).texture("paint_bucket", paint_bucket)).renderType("cutout")).rotationY(270).buildLast();
            ConfiguredModel sModel = ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("paint_bucket/level" + num + "/" + this.name(b) + "_level" + num, new ResourceLocation("paintable", "block/template_paint_bucket" + (String)p))).texture("paint_bucket", paint_bucket)).renderType("cutout")).rotationY(90).buildLast();
            ConfiguredModel wModel = ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("paint_bucket/level" + num + "/" + this.name(b) + "_level" + num, new ResourceLocation("paintable", "block/template_paint_bucket" + (String)p))).texture("paint_bucket", paint_bucket)).renderType("cutout")).rotationY(180).buildLast();
            this.getVariantBuilder(b).partialState().with((Property)FilledPaintBucketBlock.FACING, (Comparable)Direction.EAST).with((Property)FilledPaintBucketBlock.LEVEL_PAINT, (Comparable)Integer.valueOf(i)).setModels(new ConfiguredModel[]{eModel}).partialState().with((Property)FilledPaintBucketBlock.FACING, (Comparable)Direction.NORTH).with((Property)FilledPaintBucketBlock.LEVEL_PAINT, (Comparable)Integer.valueOf(i)).setModels(new ConfiguredModel[]{nModel}).partialState().with((Property)FilledPaintBucketBlock.FACING, (Comparable)Direction.SOUTH).with((Property)FilledPaintBucketBlock.LEVEL_PAINT, (Comparable)Integer.valueOf(i)).setModels(new ConfiguredModel[]{sModel}).partialState().with((Property)FilledPaintBucketBlock.FACING, (Comparable)Direction.WEST).with((Property)FilledPaintBucketBlock.LEVEL_PAINT, (Comparable)Integer.valueOf(i)).setModels(new ConfiguredModel[]{wModel});
        }
    }

    private void paintBucketBlock(Block b, String texture) {
        ResourceLocation paint_bucket = new ResourceLocation("paintable", "block/" + texture);
        ConfiguredModel eModel = ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("paint_bucket/" + this.name(b), new ResourceLocation("paintable", "block/template_paint_bucket"))).texture("paint_bucket", paint_bucket)).renderType("cutout")).buildLast();
        ConfiguredModel nModel = ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("paint_bucket/" + this.name(b), new ResourceLocation("paintable", "block/template_paint_bucket"))).texture("paint_bucket", paint_bucket)).renderType("cutout")).rotationY(270).buildLast();
        ConfiguredModel sModel = ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("paint_bucket/" + this.name(b), new ResourceLocation("paintable", "block/template_paint_bucket"))).texture("paint_bucket", paint_bucket)).renderType("cutout")).rotationY(90).buildLast();
        ConfiguredModel wModel = ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("paint_bucket/" + this.name(b), new ResourceLocation("paintable", "block/template_paint_bucket"))).texture("paint_bucket", paint_bucket)).renderType("cutout")).rotationY(180).buildLast();
        this.getVariantBuilder(b).partialState().with((Property)PaintBucketBlock.FACING, (Comparable)Direction.EAST).setModels(new ConfiguredModel[]{eModel}).partialState().with((Property)PaintBucketBlock.FACING, (Comparable)Direction.NORTH).setModels(new ConfiguredModel[]{nModel}).partialState().with((Property)PaintBucketBlock.FACING, (Comparable)Direction.SOUTH).setModels(new ConfiguredModel[]{sModel}).partialState().with((Property)PaintBucketBlock.FACING, (Comparable)Direction.WEST).setModels(new ConfiguredModel[]{wModel});
    }

    protected void registerStatesAndModels() {
        ArrayList<DyeColor> colors = new ArrayList<DyeColor>(Arrays.asList(DyeColor.WHITE, DyeColor.LIGHT_GRAY, DyeColor.GRAY, DyeColor.BLACK, DyeColor.BROWN, DyeColor.RED, DyeColor.ORANGE, DyeColor.YELLOW, DyeColor.LIME, DyeColor.GREEN, DyeColor.CYAN, DyeColor.LIGHT_BLUE, DyeColor.BLUE, DyeColor.PURPLE, DyeColor.MAGENTA, DyeColor.PINK));
        for (DyeColor color : colors) {
            this.logBlock((RotatedPillarBlock)this.block(color, "log"));
            this.strippedLogBlock((RotatedPillarBlock)this.block(color, "wood"), (RotatedPillarBlock)this.block(color, "log"));
            this.logBlock((RotatedPillarBlock)this.blockOSSS(color, "log"));
            this.strippedLogBlock((RotatedPillarBlock)this.blockOSSS(color, "wood"), (RotatedPillarBlock)this.blockOSSS(color, "log"));
            this.blockWithItem(this.blockO(color, "planks"));
            this.stairsBlock((StairBlock)this.block(color, "stairs"), this.blockR(color, "planks"));
            this.slabBlock((SlabBlock)this.block(color, "slab"), this.blockR(color, "planks"), this.blockR(color, "planks"));
            this.fenceBlock((FenceBlock)this.block(color, "fence"), this.blockR(color, "planks"));
            this.fenceGateBlock((FenceGateBlock)this.block(color, "fence_gate"), this.blockR(color, "planks"));
            this.buttonBlock((ButtonBlock)this.block(color, "button"), this.blockR(color, "planks"));
            this.pressurePlateBlock((PressurePlateBlock)this.block(color, "pressure_plate"), this.blockR(color, "planks"));
            this.doorBlockWithRenderType((DoorBlock)this.block(color, "door"), this.modLoc("block/" + color + "_painted_door_bottom"), this.modLoc("block/" + color + "_painted_door_top"), "cutout");
            this.trapdoorBlockWithRenderType((TrapDoorBlock)this.block(color, "trapdoor"), this.modLoc("block/" + color + "_painted_trapdoor"), true, "cutout");
            this.blockWithItem(this.blockO(color, "bricks"));
            this.stairsBlock((StairBlock)this.block(color, "brick_stairs"), this.blockR(color, "bricks"));
            this.slabBlock((SlabBlock)this.block(color, "brick_slab"), this.blockR(color, "bricks"), this.blockR(color, "bricks"));
            this.wallBlock((WallBlock)this.block(color, "brick_wall"), this.blockR(color, "bricks"));
            this.blockWithItem(this.blockO(color, "mud_bricks"));
            this.stairsBlock((StairBlock)this.block(color, "mud_brick_stairs"), this.blockR(color, "mud_bricks"));
            this.slabBlock((SlabBlock)this.block(color, "mud_brick_slab"), this.blockR(color, "mud_bricks"), this.blockR(color, "mud_bricks"));
            this.wallBlock((WallBlock)this.block(color, "mud_brick_wall"), this.blockR(color, "mud_bricks"));
            this.filledPaintBucketBlock(Paintable.getBlockFromString(color + "_paint_bucket"), color + "_paint_bucket");
            this.signBlock((StandingSignBlock)this.block(color, "sign"), (WallSignBlock)this.block(color, "wall_sign"), this.blockTexture(this.block(color, "planks")));
            this.hangingSignBlock((Block)ModBlocks.PAINTED_HANGING_SIGN.get(color.m_41060_()).get(), (Block)ModBlocks.PAINTED_WALL_HANGING_SIGN.get(color.m_41060_()).get(), this.blockTexture(this.blockOSSS(color, "log")));
        }
        this.paintBucketBlock(Paintable.getBlockFromString("paint_bucket"), "paint_bucket");
    }

    private void hangingSignBlock(Block signBlock, Block wallSignBlock, ResourceLocation texture) {
        ModelBuilder sign = this.models().sign(this.name(signBlock), texture);
        this.hangingSignBlock(signBlock, wallSignBlock, (ModelFile)sign);
    }

    private void hangingSignBlock(Block signBlock, Block wallSignBlock, ModelFile sign) {
        this.simpleBlock(signBlock, sign);
        this.simpleBlock(wallSignBlock, sign);
    }

    private String name(Block block) {
        return this.key(block).m_135815_();
    }

    private ResourceLocation key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    private void blockWithItem(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), this.cubeAll((Block)blockRegistryObject.get()));
    }
}

