/*
 * Decompiled with CFR 0.152.
 */
package net.im_maker.paintable.datagen;

import java.util.ArrayList;
import java.util.Arrays;
import net.im_maker.paintable.common.item.ModItems;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModItemModelProvider
extends ItemModelProvider {
    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "paintable", existingFileHelper);
    }

    private RegistryObject<Block> block(String block) {
        ResourceLocation blockLocation = new ResourceLocation("paintable", block);
        return RegistryObject.create((ResourceLocation)blockLocation, (IForgeRegistry)ForgeRegistries.BLOCKS);
    }

    private RegistryObject<Block> block(DyeColor color, String block) {
        ResourceLocation blockLocation = new ResourceLocation("paintable", color + "_painted_" + block);
        return RegistryObject.create((ResourceLocation)blockLocation, (IForgeRegistry)ForgeRegistries.BLOCKS);
    }

    private RegistryObject<Item> item(DyeColor color, String item) {
        ResourceLocation itemLocation = new ResourceLocation("paintable", color + "_painted_" + item);
        return RegistryObject.create((ResourceLocation)itemLocation, (IForgeRegistry)ForgeRegistries.ITEMS);
    }

    private RegistryObject<Block> blockSSS(DyeColor color, String block) {
        ResourceLocation blockLocation = new ResourceLocation("paintable", "stripped_" + color + "_painted_" + block);
        return RegistryObject.create((ResourceLocation)blockLocation, (IForgeRegistry)ForgeRegistries.BLOCKS);
    }

    protected void registerModels() {
        ArrayList<DyeColor> colors = new ArrayList<DyeColor>(Arrays.asList(DyeColor.WHITE, DyeColor.LIGHT_GRAY, DyeColor.GRAY, DyeColor.BLACK, DyeColor.BROWN, DyeColor.RED, DyeColor.ORANGE, DyeColor.YELLOW, DyeColor.LIME, DyeColor.GREEN, DyeColor.CYAN, DyeColor.LIGHT_BLUE, DyeColor.BLUE, DyeColor.PURPLE, DyeColor.MAGENTA, DyeColor.PINK));
        this.handheldItem(ModItems.PAINT_BRUSH);
        this.simpleBlockItem(this.block("paint_bucket"));
        for (DyeColor color : colors) {
            ResourceLocation paint_brushLocation = new ResourceLocation("paintable", color + "_paint_brush");
            RegistryObject paint_brush = RegistryObject.create((ResourceLocation)paint_brushLocation, (IForgeRegistry)ForgeRegistries.ITEMS);
            this.handheldItem((RegistryObject<Item>)paint_brush);
            this.simpleItem(this.item(color, "boat"));
            this.simpleItem(this.item(color, "chest_boat"));
            this.evenSimplerBlockItem(this.block(color, "log"));
            this.evenSimplerBlockItem(this.block(color, "wood"));
            this.evenSimplerBlockItem(this.blockSSS(color, "log"));
            this.evenSimplerBlockItem(this.blockSSS(color, "wood"));
            this.evenSimplerBlockItem(this.block(color, "planks"));
            this.evenSimplerBlockItem(this.block(color, "stairs"));
            this.evenSimplerBlockItem(this.block(color, "slab"));
            this.fenceItem(this.block(color, "fence"), this.block(color, "planks"));
            this.evenSimplerBlockItem(this.block(color, "fence_gate"));
            this.buttonItem(this.block(color, "button"), this.block(color, "planks"));
            this.evenSimplerBlockItem(this.block(color, "pressure_plate"));
            this.simpleBlockItem(this.block(color, "door"));
            this.trapdoorItem(this.block(color, "trapdoor"));
            this.simpleItem(this.item(color, "sign"));
            this.simpleItem(this.item(color, "hanging_sign"));
            this.evenSimplerBlockItem(this.block(color, "bricks"));
            this.evenSimplerBlockItem(this.block(color, "brick_stairs"));
            this.evenSimplerBlockItem(this.block(color, "brick_slab"));
            this.wallItem(this.block(color, "brick_wall"), this.block(color, "bricks"));
            this.evenSimplerBlockItem(this.block(color, "mud_bricks"));
            this.evenSimplerBlockItem(this.block(color, "mud_brick_stairs"));
            this.evenSimplerBlockItem(this.block(color, "mud_brick_slab"));
            this.wallItem(this.block(color, "mud_brick_wall"), this.block(color, "mud_bricks"));
            this.simpleBlockItem(this.block(color + "_paint_bucket"));
        }
    }

    private ItemModelBuilder simpleItem(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("paintable", "item/" + item.getId().m_135815_()));
    }

    public void evenSimplerBlockItem(RegistryObject<Block> block) {
        this.withExistingParent("paintable:" + ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.modLoc("block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_()));
    }

    public void trapdoorItem(RegistryObject<Block> block) {
        this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.modLoc("block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_() + "_bottom"));
    }

    public void fenceItem(RegistryObject<Block> block, RegistryObject<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.mcLoc("block/fence_inventory"))).texture("texture", new ResourceLocation("paintable", "block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)baseBlock.get())).m_135815_()));
    }

    public void buttonItem(RegistryObject<Block> block, RegistryObject<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.mcLoc("block/button_inventory"))).texture("texture", new ResourceLocation("paintable", "block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)baseBlock.get())).m_135815_()));
    }

    public void wallItem(RegistryObject<Block> block, RegistryObject<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.mcLoc("block/wall_inventory"))).texture("wall", new ResourceLocation("paintable", "block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)baseBlock.get())).m_135815_()));
    }

    private ItemModelBuilder handheldItem(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/handheld"))).texture("layer0", new ResourceLocation("paintable", "item/" + item.getId().m_135815_()));
    }

    private ItemModelBuilder simpleBlockItem(RegistryObject<Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("paintable", "item/" + item.getId().m_135815_()));
    }

    private ItemModelBuilder simpleBlockItemBlockTexture(RegistryObject<Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("paintable", "block/" + item.getId().m_135815_()));
    }
}

