/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.entity.goal;

import com.yungnickyoung.minecraft.ribbits.data.RibbitInstrument;
import com.yungnickyoung.minecraft.ribbits.entity.RibbitEntity;
import com.yungnickyoung.minecraft.ribbits.module.RibbitInstrumentModule;
import com.yungnickyoung.minecraft.ribbits.services.Services;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;

public class RibbitPlayMusicGoal
extends Goal {
    private final RibbitEntity ribbit;
    private final double speedModifier;
    private final int minRequiredPlayTicks;
    private final int maxRequiredPlayTicks;
    private int requiredPlayTicks;
    private Path path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;

    public RibbitPlayMusicGoal(RibbitEntity ribbit, double speedModifier, int minRequiredPlayTicks, int maxRequiredPlayTicks) {
        this.ribbit = ribbit;
        this.speedModifier = speedModifier;
        this.minRequiredPlayTicks = minRequiredPlayTicks;
        this.maxRequiredPlayTicks = maxRequiredPlayTicks;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.ribbit.m_9236_().m_46462_()) {
            return false;
        }
        this.ribbit.m_9236_().m_45976_(RibbitEntity.class, this.ribbit.m_20191_().m_82377_(64.0, 16.0, 64.0)).stream().filter(RibbitEntity::getPlayingInstrument).forEach(ribbit -> {
            if (ribbit.getMasterRibbit() != null) {
                this.ribbit.setMasterRibbit(ribbit.getMasterRibbit());
            }
        });
        if (this.ribbit.getMasterRibbit() != null && this.ribbit.getMasterRibbit().isBandFull()) {
            this.ribbit.setMasterRibbit(null);
            return false;
        }
        return !this.ribbit.getUmbrellaFalling() && !this.ribbit.m_21224_();
    }

    public boolean m_8045_() {
        return !this.ribbit.getUmbrellaFalling() && !this.ribbit.m_21224_() && (this.ribbit.getPlayingInstrument() || this.ribbit.getMasterRibbit() == null || !this.ribbit.getMasterRibbit().isBandFull());
    }

    public void m_8056_() {
        this.ribbit.setInstrument(RibbitInstrumentModule.NONE);
        if (this.ribbit.getMasterRibbit() != null) {
            this.path = this.ribbit.m_21573_().m_6570_((Entity)this.ribbit.getMasterRibbit(), 0);
            this.ribbit.m_21573_().m_26536_(this.path, this.speedModifier);
        }
        if (this.ribbit.getMasterRibbit() == null) {
            this.ribbit.setMasterRibbit(this.ribbit);
        }
        this.requiredPlayTicks = this.ribbit.m_217043_().m_216339_(this.minRequiredPlayTicks, this.maxRequiredPlayTicks);
    }

    public void m_8041_() {
        this.ribbit.getMasterRibbit().removeRibbitFromPlayingMusic(this.ribbit);
        this.ribbit.getMasterRibbit().removeBandMember(this.ribbit.getRibbitData().getInstrument());
        if (this.ribbit.isMasterRibbit()) {
            this.ribbit.findNewMasterRibbit();
        }
        this.ribbit.setPlayingInstrument(false);
        this.ribbit.setTicksPlayingMusic(0);
        this.ribbit.setInstrument(RibbitInstrumentModule.NONE);
    }

    public boolean m_183429_() {
        return true;
    }

    public boolean m_6767_() {
        return this.ribbit.m_21188_() != null || this.ribbit.m_203117_() || this.ribbit.m_6060_() || this.ribbit.getTicksPlayingMusic() > this.requiredPlayTicks;
    }

    public void m_8037_() {
        if (this.ribbit.getMasterRibbit() == null || this.ribbit.getMasterRibbit().m_21224_() || !this.ribbit.getMasterRibbit().getPlayingInstrument()) {
            this.ribbit.m_9236_().m_45976_(RibbitEntity.class, this.ribbit.m_20191_().m_82377_(64.0, 16.0, 64.0)).stream().filter(RibbitEntity::getPlayingInstrument).forEach(ribbit -> {
                if (ribbit.getMasterRibbit() != null) {
                    this.ribbit.setMasterRibbit(ribbit.getMasterRibbit());
                }
            });
            if (this.ribbit.getMasterRibbit() != null && this.ribbit.getMasterRibbit().isBandFull()) {
                this.ribbit.setMasterRibbit(null);
                return;
            }
            if (this.ribbit.getMasterRibbit() == null) {
                this.ribbit.setMasterRibbit(this.ribbit);
            }
        }
        RibbitEntity masterRibbit = this.ribbit.getMasterRibbit();
        this.ribbit.m_21563_().m_24960_((Entity)masterRibbit, 30.0f, 30.0f);
        double d = this.ribbit.m_20275_(masterRibbit.m_20185_(), masterRibbit.m_20186_(), masterRibbit.m_20189_());
        this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
        if (!this.ribbit.getPlayingInstrument() && this.ticksUntilNextPathRecalculation == 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || masterRibbit.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.ribbit.m_217043_().m_188501_() < 0.05f)) {
            this.pathedTargetX = masterRibbit.m_20185_();
            this.pathedTargetY = masterRibbit.m_20186_();
            this.pathedTargetZ = masterRibbit.m_20189_();
            this.ticksUntilNextPathRecalculation = 4 + this.ribbit.m_217043_().m_188503_(7);
            if (d > 1024.0) {
                this.ticksUntilNextPathRecalculation += 10;
            } else if (d > 256.0) {
                this.ticksUntilNextPathRecalculation += 5;
            }
            if (!this.ribbit.m_21573_().m_5624_((Entity)masterRibbit, this.speedModifier)) {
                this.ticksUntilNextPathRecalculation += 15;
            }
            this.ticksUntilNextPathRecalculation = this.m_183277_(this.ticksUntilNextPathRecalculation);
        }
        if (!this.ribbit.getPlayingInstrument() && d <= 9.0 && !this.ribbit.m_20069_()) {
            if (this.ribbit.getRibbitData().getInstrument() == RibbitInstrumentModule.NONE) {
                RibbitInstrument instrument = RibbitInstrumentModule.getRandomInstrument(masterRibbit.getBandMembers());
                if (instrument == null) {
                    return;
                }
                this.ribbit.setInstrument(instrument);
                this.ribbit.getMasterRibbit().addBandMember(this.ribbit.getRibbitData().getInstrument());
            }
            this.ribbit.m_21573_().m_26573_();
            this.ribbit.setPlayingInstrument(true);
            this.ribbit.setTicksPlayingMusic(0);
            Services.PLATFORM.onRibbitStartMusicGoal((ServerLevel)this.ribbit.m_9236_(), this.ribbit, masterRibbit);
            masterRibbit.addRibbitToPlayingMusic(this.ribbit);
        }
        if (this.ribbit.getPlayingInstrument()) {
            this.ribbit.m_21573_().m_26573_();
            if (d > 9.0) {
                this.ribbit.setPlayingInstrument(false);
                masterRibbit.removeBandMember(this.ribbit.getRibbitData().getInstrument());
                this.ribbit.setInstrument(RibbitInstrumentModule.NONE);
                masterRibbit.removeRibbitFromPlayingMusic(this.ribbit);
                this.ribbit.setTicksPlayingMusic(0);
                return;
            }
            if (this.ribbit.equals((Object)masterRibbit)) {
                HashSet<Player> playersHearingMusic = new HashSet<Player>(this.ribbit.getPlayersHearingMusic());
                List playersInRange = this.ribbit.m_9236_().m_6443_(Player.class, this.ribbit.m_20191_().m_82377_(32.0, 32.0, 32.0), EntitySelector.f_20403_);
                for (Player player2 : playersInRange) {
                    if (playersHearingMusic.contains(player2)) continue;
                    playersHearingMusic.add(player2);
                    Services.PLATFORM.onPlayerEnterBandRange((ServerPlayer)player2, (ServerLevel)this.ribbit.m_9236_(), this.ribbit);
                }
                playersHearingMusic.removeIf(player -> {
                    if (player.m_213877_() || !playersInRange.contains(player)) {
                        Services.PLATFORM.onPlayerExitBandRange((ServerPlayer)player, (ServerLevel)this.ribbit.m_9236_(), this.ribbit);
                        return true;
                    }
                    return false;
                });
                this.ribbit.setPlayersHearingMusic(playersHearingMusic);
            }
            this.ribbit.setTicksPlayingMusic(this.ribbit.getTicksPlayingMusic() + 1);
        }
    }
}

